/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.accounting.commons.jms;

import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TextMessage;
import org.apache.activemq.broker.SslContext;
import pl.edu.icm.unicore.accounting.commons.jms.DataSender;
import pl.edu.icm.unicore.accounting.commons.jms.JMSParticipant;

public class JMSSender
extends JMSParticipant
implements DataSender {
    private MessageProducer producer;
    private boolean reconnect = true;

    public JMSSender(String destinationUrl, String queue) throws JMSException {
        super(destinationUrl, queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean connect() {
        try {
            this.commonConnect(1);
            this.connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException exception) {
                    JMSSender.this.reconnect = true;
                }
            });
            this.producer = this.session.createProducer(this.destination);
        }
        catch (JMSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            SslContext.setCurrentSslContext(null);
        }
        this.reconnect = false;
        return true;
    }

    @Override
    public boolean send(String message) {
        if (this.reconnect && !this.connect()) {
            return false;
        }
        try {
            TextMessage jmsMessage = this.session.createTextMessage(message);
            this.producer.send((Message)jmsMessage);
        }
        catch (IllegalStateException e) {
            logger.info((Object)("JMS: " + e.getMessage() + " Scheduling reconnect."));
            this.reconnect = true;
            return false;
        }
        catch (JMSException e) {
            this.reconnect = true;
            logger.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void close() throws JMSException {
        this.closePreviuosConnectionIfNeeded();
    }
}

