/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.accounting.commons.jms;

import java.io.File;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.SslContext;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.accounting.commons.jms.EasySslContext;
import pl.edu.icm.unicore.accounting.commons.utils.StringUtils;

public class JMSParticipant {
    protected static final Logger logger = Logger.getLogger(JMSParticipant.class);
    protected String destinationUrl;
    protected String queue;
    protected boolean useCredentials = false;
    protected String username;
    protected String password;
    protected EasySslContext sslContext = null;
    protected Connection connection;
    protected Session session;
    protected Destination destination;

    public JMSParticipant(String destinationUrl, String queue) throws JMSException {
        this.destinationUrl = destinationUrl;
        this.queue = queue;
    }

    public void setCredentials(String username, String password) {
        logger.debug((Object)("Using credentials: username[" + username + "], password[******]"));
        this.useCredentials = true;
        this.username = username;
        this.password = password;
    }

    public void setupSslContext(String keyStore, String keyStorePassword, String truststore, String truststorePassword) throws Exception {
        this.sslContext = new EasySslContext();
        this.sslContext.setKeyStorePassword(keyStorePassword);
        this.sslContext.setTrustStorePassword(truststorePassword);
        if (keyStore != null && !keyStore.trim().equals("")) {
            this.sslContext.setKeyStore(new File(keyStore));
        }
        if (truststore != null && !truststore.trim().equals("")) {
            this.sslContext.setTrustStore(new File(truststore));
        }
        this.sslContext.afterPropertiesSet();
    }

    protected void closePreviuosConnectionIfNeeded() {
        if (this.connection != null) {
            try {
                logger.info((Object)"JMS: Closing unused connection...");
                this.connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        this.connection = null;
    }

    protected void commonConnect(int ackType) throws JMSException {
        String infoString = "Connecting to jms: " + this.destinationUrl + ", queue name = " + this.queue;
        if (!StringUtils.isEmpty((String)this.username)) {
            infoString = infoString + ", username: " + this.username;
        }
        logger.info((Object)infoString);
        SslContext.setCurrentSslContext((SslContext)this.sslContext);
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.destinationUrl);
        this.closePreviuosConnectionIfNeeded();
        this.connection = this.useCredentials ? connectionFactory.createConnection(this.username, this.password) : connectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, ackType);
        this.destination = this.session.createQueue(this.queue);
    }
}

