/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.accounting.commons.jms;

import java.util.Properties;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.accounting.commons.jms.DataSender;
import pl.edu.icm.unicore.accounting.commons.jms.JMSConsumer;
import pl.edu.icm.unicore.accounting.commons.jms.JMSParticipant;
import pl.edu.icm.unicore.accounting.commons.jms.JMSSender;

public class JMSFactory {
    protected static final Logger logger = Logger.getLogger(JMSFactory.class);
    public static final String PROP_NAME_JMS_BROKER_URL = "jms.url";
    public static final String PROP_NAME_JMS_QUEUE = "jms.queue";
    public static final String PROP_NAME_JMS_USERNAME = "jms.username";
    public static final String PROP_NAME_JMS_PASSWORD = "jms.password";
    public static final String PROP_NAME_JMS_KEYSTORE = "jms.keystore";
    public static final String PROP_NAME_JMS_KEYSTORE_PASSWORD = "jms.keystore.password";
    public static final String PROP_NAME_JMS_TRUSTSTORE = "jms.truststore";
    public static final String PROP_NAME_JMS_TRUSTSTORE_PASSWORD = "jms.truststore.password";
    public static final String DEFAULT_JMS_BROKER_URL = "tcp://localhost:61616";
    public static final String DEFAULT_JMS_PORT = "61616";
    public static final String DEFAULT_JMS_QUEUE = "jobs";

    public static JMSConsumer getConsumer(Properties properties) {
        JMSFactory factory = new JMSFactory();
        return (JMSConsumer)factory.getObject(properties, true);
    }

    public static DataSender getProducer(Properties properties) {
        JMSFactory factory = new JMSFactory();
        return (DataSender)((Object)factory.getObject(properties, false));
    }

    private JMSParticipant getObject(Properties properties, boolean isConsumer) {
        JMSParticipant jms = null;
        String brokerUrl = properties.getProperty(PROP_NAME_JMS_BROKER_URL);
        String queueName = properties.getProperty(PROP_NAME_JMS_QUEUE);
        String username = properties.getProperty(PROP_NAME_JMS_USERNAME);
        String password = properties.getProperty(PROP_NAME_JMS_PASSWORD);
        String keystore = properties.getProperty(PROP_NAME_JMS_KEYSTORE);
        String keystorePassword = properties.getProperty(PROP_NAME_JMS_KEYSTORE_PASSWORD);
        String truststore = properties.getProperty(PROP_NAME_JMS_TRUSTSTORE);
        String truststorePassword = properties.getProperty(PROP_NAME_JMS_TRUSTSTORE_PASSWORD);
        if (brokerUrl == null || brokerUrl.trim().equals("")) {
            logger.warn((Object)"Unable to find jms broker url. Using default: tcp://localhost:61616");
            brokerUrl = DEFAULT_JMS_BROKER_URL;
        }
        if (queueName == null || queueName.trim().equals("")) {
            logger.warn((Object)"Unable to find jms queue name. Using default: jobs");
            queueName = DEFAULT_JMS_QUEUE;
        }
        try {
            logger.info((Object)("Using JMS server: " + brokerUrl + " queue: " + queueName));
            jms = isConsumer ? new JMSConsumer(brokerUrl, queueName) : new JMSSender(brokerUrl, queueName);
            if (username != null && password != null && !username.trim().equals("")) {
                jms.setCredentials(username, password);
            }
            jms.setupSslContext(keystore, keystorePassword, truststore, truststorePassword);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return jms;
    }
}

