/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.accounting.commons.jms;

import java.util.Timer;
import java.util.TimerTask;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.apache.activemq.broker.SslContext;
import pl.edu.icm.unicore.accounting.commons.jms.JMSParticipant;

public class JMSConsumer
extends JMSParticipant {
    public static final int RESCHEDULE_DELAY_MULT = 2;
    public static final int RESCHEDULE_DELAY_MAX = 600000;
    public static final int RESCHEDULE_DELAY_START = 10000;
    private MessageConsumer consumer;
    private MessageListener listener;
    private Timer timer = new Timer("JMS Consumer Timer", true);

    public JMSConsumer(String destinationUrl, String queue) throws JMSException {
        super(destinationUrl, queue);
    }

    @Override
    protected void commonConnect(int ackType) throws JMSException {
        super.commonConnect(ackType);
        this.consumer = this.session.createConsumer(this.destination);
    }

    public void setMessageListener(MessageListener messageListener) {
        this.listener = messageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup(MessageListener listener) throws JMSException {
        try {
            this.commonConnect(2);
            this.consumer.setMessageListener(listener);
            this.connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException exception) {
                    long delay = JMSConsumer.this.rescheduleTime(5000L);
                    JMSConsumer.this.timer.schedule((TimerTask)new Reconnect(delay), delay);
                }
            });
        }
        finally {
            SslContext.setCurrentSslContext(null);
        }
    }

    public void start() {
        logger.info((Object)"RUS JMS Consumer started");
        this.timer.schedule((TimerTask)new Reconnect(5000L), 2L);
    }

    public void stop() {
        this.setMessageListener(null);
        try {
            if (this.consumer != null) {
                this.consumer.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public long rescheduleTime(long previous) {
        long delay = previous * 2L;
        if (delay > 600000L) {
            delay = 600000L;
        }
        return delay;
    }

    private final class Reconnect
    extends TimerTask {
        private long lastTimeout;

        public Reconnect(long lastTimeout) {
            this.lastTimeout = lastTimeout;
        }

        @Override
        public void run() {
            if (JMSConsumer.this.listener == null) {
                return;
            }
            try {
                JMSConsumer.this.setup(JMSConsumer.this.listener);
            }
            catch (JMSException e) {
                long delay = JMSConsumer.this.rescheduleTime(this.lastTimeout);
                JMSParticipant.logger.error((Object)("Rescheduling JMS connection. Will retry in " + delay / 1000L + "s. Cause: " + e.getMessage()), (Throwable)e);
                JMSConsumer.this.timer.schedule((TimerTask)new Reconnect(delay), delay);
            }
        }
    }
}

