/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.accounting.commons.jms;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.activemq.broker.SslContext;

public class EasySslContext
extends SslContext {
    private String keyStoreType = "jks";
    private String trustStoreType = "jks";
    private String secureRandomAlgorithm = "SHA1PRNG";
    private String keyStoreAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private String trustStoreAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    private File keyStore;
    private File trustStore;
    private String keyStorePassword;
    private String trustStorePassword;

    public void afterPropertiesSet() throws Exception {
        this.keyManagers.addAll(this.createKeyManagers());
        this.trustManagers.addAll(this.createTrustManagers());
        if (this.secureRandom == null) {
            this.secureRandom = this.createSecureRandom();
        }
    }

    private SecureRandom createSecureRandom() throws NoSuchAlgorithmException {
        return SecureRandom.getInstance(this.secureRandomAlgorithm);
    }

    private Collection<TrustManager> createTrustManagers() throws Exception {
        KeyStore ks = this.createTrustManagerKeyStore();
        if (ks == null) {
            return new ArrayList<TrustManager>(0);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.trustStoreAlgorithm);
        tmf.init(ks);
        return Arrays.asList(tmf.getTrustManagers());
    }

    private Collection<KeyManager> createKeyManagers() throws Exception {
        KeyStore ks = this.createKeyManagerKeyStore();
        if (ks == null) {
            return new ArrayList<KeyManager>(0);
        }
        KeyManagerFactory tmf = KeyManagerFactory.getInstance(this.keyStoreAlgorithm);
        tmf.init(ks, this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray());
        return Arrays.asList(tmf.getKeyManagers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore createTrustManagerKeyStore() throws Exception {
        if (this.trustStore == null) {
            return null;
        }
        KeyStore ks = KeyStore.getInstance(this.trustStoreType);
        FileInputStream is = new FileInputStream(this.trustStore);
        try {
            ks.load(is, this.trustStorePassword == null ? null : this.trustStorePassword.toCharArray());
        }
        finally {
            ((InputStream)is).close();
        }
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore createKeyManagerKeyStore() throws Exception {
        if (this.keyStore == null) {
            return null;
        }
        KeyStore ks = KeyStore.getInstance(this.keyStoreType);
        FileInputStream is = new FileInputStream(this.keyStore);
        try {
            ks.load(is, this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray());
        }
        finally {
            ((InputStream)is).close();
        }
        return ks;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public File getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(File keyResource) {
        this.keyStore = keyResource;
    }

    public File getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(File trustResource) {
        this.trustStore = trustResource;
    }

    public String getKeyStoreAlgorithm() {
        return this.keyStoreAlgorithm;
    }

    public void setKeyStoreAlgorithm(String keyAlgorithm) {
        this.keyStoreAlgorithm = keyAlgorithm;
    }

    public String getTrustStoreAlgorithm() {
        return this.trustStoreAlgorithm;
    }

    public void setTrustStoreAlgorithm(String trustAlgorithm) {
        this.trustStoreAlgorithm = trustAlgorithm;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyPassword) {
        this.keyStorePassword = keyPassword;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustPassword) {
        this.trustStorePassword = trustPassword;
    }

    public void setKeyStoreType(String keyType) {
        this.keyStoreType = keyType;
    }

    public void setTrustStoreType(String trustType) {
        this.trustStoreType = trustType;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }
}

