/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

public class Base64Binary {
    private byte[] value;
    private static final byte EQUALS_SIGN = 61;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;
    private static final byte[] DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};

    public Base64Binary(String value) {
        this.value = Base64Binary.decode(value);
    }

    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Base64Binary) {
            if (this.value.length != ((Base64Binary)obj).getValue().length) {
                return false;
            }
            for (int i = 0; i < this.value.length; ++i) {
                if (this.value[i] == ((Base64Binary)obj).getValue()[i]) continue;
                return false;
            }
        }
        return true;
    }

    private static byte[] decode(String s) {
        byte[] bytes = s.getBytes();
        return Base64Binary.decode(bytes, 0, bytes.length);
    }

    private static byte[] decode(byte[] source, int off, int len) {
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        int i = 0;
        byte sbiCrop = 0;
        byte sbiDecode = 0;
        for (i = 0; i < len; ++i) {
            sbiCrop = (byte)(source[i] & 0x7F);
            sbiDecode = DECODABET[sbiCrop];
            if (sbiDecode >= -5) {
                if (sbiDecode < -1) continue;
                b4[b4Posn++] = sbiCrop;
                if (b4Posn <= 3) continue;
                outBuffPosn += Base64Binary.decode4to3(b4, 0, outBuff, outBuffPosn);
                b4Posn = 0;
                if (sbiCrop != 61) continue;
                break;
            }
            throw new IllegalArgumentException("Bad Base64 input character at " + i + ": " + source[i] + "(decimal)");
        }
        byte[] out = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
        return out;
    }

    private static int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset) {
        if (source[srcOffset + 2] == 61) {
            int outBuff = DECODABET[source[srcOffset]] << 24 >>> 6 | DECODABET[source[srcOffset + 1]] << 24 >>> 12;
            destination[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (source[srcOffset + 3] == 61) {
            int outBuff = DECODABET[source[srcOffset]] << 24 >>> 6 | DECODABET[source[srcOffset + 1]] << 24 >>> 12 | DECODABET[source[srcOffset + 2]] << 24 >>> 18;
            destination[destOffset] = (byte)(outBuff >>> 16);
            destination[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        int outBuff = DECODABET[source[srcOffset]] << 24 >>> 6 | DECODABET[source[srcOffset + 1]] << 24 >>> 12 | DECODABET[source[srcOffset + 2]] << 24 >>> 18 | DECODABET[source[srcOffset + 3]] << 24 >>> 24;
        destination[destOffset] = (byte)(outBuff >> 16);
        destination[destOffset + 1] = (byte)(outBuff >> 8);
        destination[destOffset + 2] = (byte)outBuff;
        return 3;
    }

    public int hashCode() {
        int hashValue = 0;
        for (int i = 0; i < this.value.length; ++i) {
            hashValue += this.value[i] * (this.value.length ^ this.value.length - i - 1);
        }
        return hashValue;
    }
}

