/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.simplePDP.initializers;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.herasaf.xacml.core.simplePDP.InitializationException;
import org.herasaf.xacml.core.simplePDP.initializers.Initializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInitializer<T>
implements Initializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInitializer.class);
    private static final String CLASS_ENDING = ".class";
    private static final String DOLLAR_SIGN = "$";
    private static final String MOCK_KEYWORD = "Mock";
    private static final String ABSTRACT_KEYWORD = "Abstract";
    private static final String URL_PROTOCOL_JAR = "jar";
    private static final String URL_PROTOCOL_FILE = "file";
    private static final String URL_PROTOCOL_ZIP = "zip";
    private static final String URL_PROTOCOL_WSJAR = "wsjar";
    private static final String URL_PROTOCOL_CODE_SOURCE = "code-source";
    private static final String JAR_URL_SEPARATOR = "!/";

    protected abstract String getDefaultSearchContextPath();

    protected abstract Class<T> getTargetClass();

    protected abstract String getURIFromType(T var1);

    protected abstract void setInstancesIntoConverter(Map<String, T> var1);

    @Override
    public void run() {
        Set<String> classNames = this.getClassNames(this.getDefaultSearchContextPath());
        for (String customSearchContext : this.getCustomSearchContexts()) {
            classNames.addAll(this.getClassNames(customSearchContext));
        }
        Set<T> instances = this.createInstancesFromClassNames(classNames, this.getTargetClass());
        Map<String, T> instancesMap = this.convertSetToMap(instances);
        this.setInstancesIntoConverter(instancesMap);
        this.furtherInitializations(instancesMap);
    }

    protected Collection<String> getCustomSearchContexts() {
        return new ArrayList<String>();
    }

    private Set<String> getClassNames(String searchContext) {
        Enumeration<URL> resourceURLs;
        HashSet<String> classNames = new HashSet<String>();
        if (searchContext == null) {
            return classNames;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            resourceURLs = cl.getResources(searchContext);
        }
        catch (IOException e1) {
            InitializationException ie = new InitializationException("Unable to get resources from classpath.");
            LOGGER.error(ie.getMessage());
            throw ie;
        }
        while (resourceURLs.hasMoreElements()) {
            URL url = resourceURLs.nextElement();
            if (AbstractInitializer.isJarURL(url)) {
                classNames.addAll(this.collectClassNamesFromJar(url, searchContext));
                continue;
            }
            if (URL_PROTOCOL_FILE.equals(url.getProtocol())) {
                classNames.addAll(this.collectClassNamesFromFile(url, searchContext));
                continue;
            }
            InitializationException e = new InitializationException("The search context path must either point to a JAR (.jar, .zip (BEA WebLogic, WebSphere), .wsjar (BEA WebLogic, WebSphere), code-source (Oracle OC4J)) file or to a directory");
            LOGGER.error(e.getMessage());
            throw e;
        }
        return classNames;
    }

    protected void furtherInitializations(Map<String, T> instancesMap) {
    }

    private Map<String, T> convertSetToMap(Set<T> instances) {
        HashMap<String, T> targetMap = new HashMap<String, T>();
        for (T instance : instances) {
            targetMap.put(this.getURIFromType(instance), instance);
        }
        return targetMap;
    }

    private static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol) || URL_PROTOCOL_CODE_SOURCE.equals(protocol) && url.getPath().contains(JAR_URL_SEPARATOR);
    }

    private static boolean isJarEntryValid(JarEntry entry) {
        String name = entry.getName();
        return name.endsWith(CLASS_ENDING) && !entry.isDirectory() && !name.contains(ABSTRACT_KEYWORD) && !name.contains(MOCK_KEYWORD) && !name.contains(DOLLAR_SIGN);
    }

    private static JarFile getJarFileFromURL(URL url) {
        JarFile jarFile;
        URLConnection urlConnection;
        try {
            urlConnection = url.openConnection();
        }
        catch (IOException e) {
            InitializationException ie = new InitializationException("Unable to open URL connection to JAR file.", e);
            LOGGER.error(ie.getMessage());
            throw ie;
        }
        if (urlConnection instanceof JarURLConnection) {
            JarURLConnection jarUrlConnection = (JarURLConnection)urlConnection;
            try {
                jarFile = jarUrlConnection.getJarFile();
            }
            catch (IOException e) {
                InitializationException ie = new InitializationException("Unable to retrieve JAR file from the jar url connection.", e);
                LOGGER.error(ie.getMessage());
                throw ie;
            }
        } else {
            InitializationException e = new InitializationException("Unable to read the JAR file.");
            LOGGER.error(e.getMessage());
            throw e;
        }
        return jarFile;
    }

    private Set<String> collectClassNamesFromJar(URL url, String searchContext) {
        JarFile jarFile = AbstractInitializer.getJarFileFromURL(url);
        HashSet<String> classNames = new HashSet<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!AbstractInitializer.isJarEntryValid(entry) || !entry.getName().startsWith(searchContext)) continue;
            String name = entry.getName();
            name = name.substring(0, name.indexOf(CLASS_ENDING));
            name = name.replaceAll("\\/", ".");
            classNames.add(name);
        }
        return classNames;
    }

    private Set<String> collectClassNamesFromFile(URL url, String searchContext) {
        File directory;
        HashSet<String> classNames = new HashSet<String>();
        try {
            directory = new File(url.toURI().getPath());
        }
        catch (URISyntaxException e) {
            InitializationException ie = new InitializationException("Unable to retreive path to the files.", e);
            LOGGER.error(ie.getMessage());
            throw ie;
        }
        if (directory.isDirectory()) {
            File[] allFiles = directory.listFiles();
            for (int i = 0; i < allFiles.length; ++i) {
                if (allFiles[i].isDirectory()) {
                    try {
                        classNames.addAll(this.collectClassNamesFromFile(new URL(URL_PROTOCOL_FILE, url.getHost(), url.getPath() + "/" + allFiles[i].getName()), searchContext + "/" + allFiles[i].getName()));
                        continue;
                    }
                    catch (MalformedURLException e) {
                        InitializationException ie = new InitializationException("Unable to load classes from file system.", e);
                        LOGGER.error(ie.getMessage());
                        throw ie;
                    }
                }
                if (!allFiles[i].getName().endsWith(CLASS_ENDING) || allFiles[i].getName().startsWith(ABSTRACT_KEYWORD) || allFiles[i].getName().contains(MOCK_KEYWORD) || allFiles[i].getName().contains(DOLLAR_SIGN)) continue;
                String path = url.getPath();
                path = path.substring(path.indexOf(searchContext));
                path = path.replaceAll("/", ".");
                String name = path + "." + allFiles[i].getName();
                classNames.add(name.substring(0, name.indexOf(CLASS_ENDING)));
            }
        } else {
            String path;
            try {
                path = url.toURI().getPath();
            }
            catch (URISyntaxException e) {
                InitializationException ie = new InitializationException("Unable to retreive path to the files.", e);
                LOGGER.error(ie.getMessage());
                throw ie;
            }
            InitializationException ie = new InitializationException("The URL pointing to " + path + " must be a directory.");
            LOGGER.error(ie.getMessage());
            throw ie;
        }
        return classNames;
    }

    private Set<T> createInstancesFromClassNames(Set<String> classNames, Class<T> classType) {
        HashSet<T> classes = new HashSet<T>();
        for (String name : classNames) {
            Object instance;
            Class<?> clazz;
            try {
                clazz = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                InitializationException ie = new InitializationException("Illegal state. Cannot load class " + name + " from JAR.");
                LOGGER.error(ie.getMessage(), (Throwable)e);
                throw ie;
            }
            int modifier = clazz.getModifiers();
            if (Modifier.isAbstract(modifier) || Modifier.isInterface(modifier)) {
                LOGGER.warn("The class " + clazz.getName() + " cannot be instatiated because it is either abstract or an interface.");
                continue;
            }
            try {
                instance = clazz.newInstance();
            }
            catch (InstantiationException e) {
                InitializationException ie = new InitializationException("Cannot read class file from JAR.", e);
                LOGGER.error(ie.getMessage());
                throw ie;
            }
            catch (IllegalAccessException e) {
                InitializationException ie = new InitializationException("Cannot read class file from JAR.", e);
                LOGGER.error(ie.getMessage());
                throw ie;
            }
            if (!classType.isInstance(instance)) continue;
            classes.add(classType.cast(instance));
        }
        return classes;
    }
}

