/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.simplePDP;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.herasaf.xacml.core.api.PDP;
import org.herasaf.xacml.core.api.PolicyRetrievalPoint;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyCombiningAlgorithm;
import org.herasaf.xacml.core.simplePDP.InitializationException;
import org.herasaf.xacml.core.simplePDP.SimplePDP;
import org.herasaf.xacml.core.simplePDP.SimplePDPConfiguration;
import org.herasaf.xacml.core.simplePDP.initializers.DataTypesJAXBInitializer;
import org.herasaf.xacml.core.simplePDP.initializers.FunctionsJAXBInitializer;
import org.herasaf.xacml.core.simplePDP.initializers.Initializer;
import org.herasaf.xacml.core.simplePDP.initializers.JAXBInitializer;
import org.herasaf.xacml.core.simplePDP.initializers.PolicyCombiningAlgorithmsJAXBInitializer;
import org.herasaf.xacml.core.simplePDP.initializers.RuleCombiningAlgorithmsJAXBInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimplePDPFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplePDPFactory.class);
    private static Set<Initializer> initializers;

    private SimplePDPFactory() {
    }

    public static Set<Initializer> getDefaultInitializers() {
        HashSet<Initializer> initializers = new HashSet<Initializer>();
        initializers.add(new FunctionsJAXBInitializer());
        initializers.add(new DataTypesJAXBInitializer());
        initializers.add(new RuleCombiningAlgorithmsJAXBInitializer());
        initializers.add(new PolicyCombiningAlgorithmsJAXBInitializer());
        initializers.add(new JAXBInitializer());
        return initializers;
    }

    public static void setInitalizers(Set<Initializer> initalizers) {
        LOGGER.info("Custom initializers are in use.");
        initializers = initalizers;
    }

    public static void resetInitializers() {
        initializers = SimplePDPFactory.getDefaultInitializers();
    }

    public static PDP getSimplePDP(SimplePDPConfiguration simplePDPConfiguration) {
        SimplePDPFactory.runInitializers();
        return new SimplePDP(simplePDPConfiguration);
    }

    public static PDP getSimplePDP(SimplePDPConfiguration simplePDPConfiguration, Class<? extends SimplePDP> customPDP) {
        SimplePDPFactory.runInitializers();
        try {
            Constructor<? extends SimplePDP> constructor = customPDP.getConstructor(SimplePDPConfiguration.class);
            SimplePDP pdp = constructor.newInstance(simplePDPConfiguration);
            return pdp;
        }
        catch (SecurityException e) {
            InitializationException ie = new InitializationException("Cannot create custom PDP: " + customPDP.getCanonicalName(), e);
            LOGGER.error(ie.getMessage());
            throw ie;
        }
        catch (NoSuchMethodException e) {
            InitializationException ie = new InitializationException("Cannot create custom PDP: " + customPDP.getCanonicalName(), e);
            LOGGER.error(ie.getMessage());
            throw ie;
        }
        catch (IllegalArgumentException e) {
            InitializationException ie = new InitializationException("Cannot create custom PDP: " + customPDP.getCanonicalName(), e);
            LOGGER.error(ie.getMessage());
            throw ie;
        }
        catch (InstantiationException e) {
            InitializationException ie = new InitializationException("Cannot create custom PDP: " + customPDP.getCanonicalName(), e);
            LOGGER.error(ie.getMessage());
            throw ie;
        }
        catch (IllegalAccessException e) {
            InitializationException ie = new InitializationException("Cannot create custom PDP: " + customPDP.getCanonicalName(), e);
            LOGGER.error(ie.getMessage());
            throw ie;
        }
        catch (InvocationTargetException e) {
            InitializationException ie = new InitializationException("Cannot create custom PDP: " + customPDP.getCanonicalName(), e);
            LOGGER.error(ie.getMessage());
            throw ie;
        }
    }

    public static PDP getSimplePDP(PolicyCombiningAlgorithm rootCombiningAlgorithm) {
        SimplePDPConfiguration simplePDPConfiguration = new SimplePDPConfiguration();
        simplePDPConfiguration.setRootCombiningAlgorithm(rootCombiningAlgorithm);
        return SimplePDPFactory.getSimplePDP(simplePDPConfiguration);
    }

    public static PDP getSimplePDP(PolicyRetrievalPoint policyRetrievalPoint) {
        SimplePDPConfiguration simplePDPConfiguration = new SimplePDPConfiguration();
        simplePDPConfiguration.setPolicyRetrievalPoint(policyRetrievalPoint);
        return SimplePDPFactory.getSimplePDP(simplePDPConfiguration);
    }

    public static PDP getSimplePDP(PolicyCombiningAlgorithm rootCombiningAlgorithm, PolicyRetrievalPoint policyRetrievalPoint) {
        SimplePDPConfiguration simplePDPConfiguration = new SimplePDPConfiguration();
        simplePDPConfiguration.setRootCombiningAlgorithm(rootCombiningAlgorithm);
        simplePDPConfiguration.setPolicyRetrievalPoint(policyRetrievalPoint);
        return SimplePDPFactory.getSimplePDP(simplePDPConfiguration);
    }

    public static PDP getSimplePDP() {
        return SimplePDPFactory.getSimplePDP(new SimplePDPConfiguration());
    }

    private static void runInitializers() {
        Set<Initializer> inits = initializers == null ? SimplePDPFactory.getDefaultInitializers() : initializers;
        if (inits != null) {
            for (Initializer initializer : inits) {
                initializer.run();
            }
        }
    }
}

