/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.converter;

import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.herasaf.xacml.core.NotInitializedException;
import org.herasaf.xacml.core.dataTypeAttribute.DataTypeAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URNToDataTypeConverter
extends XmlAdapter<String, DataTypeAttribute<?>> {
    private final Logger logger = LoggerFactory.getLogger(URNToDataTypeConverter.class);
    private static Map<String, DataTypeAttribute<?>> dataTypeAttributes;

    public static void setDataTypeAttributes(Map<String, DataTypeAttribute<?>> dataTypes) {
        dataTypeAttributes = dataTypes;
    }

    public String marshal(DataTypeAttribute<?> dataTypeAttr) {
        String dataTypeAttrString;
        try {
            dataTypeAttrString = dataTypeAttr.toString();
        }
        catch (NullPointerException e) {
            this.logger.error("Argument dataTypeAttr must not be null: ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return dataTypeAttrString;
    }

    public DataTypeAttribute<?> unmarshal(String dataTypeId) {
        DataTypeAttribute<?> dta;
        try {
            dta = dataTypeAttributes.get(dataTypeId);
        }
        catch (NullPointerException e) {
            this.logger.error("URNToDataTypeConverter not properly initialized.");
            throw new NotInitializedException(e);
        }
        if (dta != null) {
            return dta;
        }
        throw new IllegalArgumentException("DataTypeAttribute " + dataTypeId + " unknown.");
    }
}

