/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.combiningAlgorithm.policy;

import org.herasaf.xacml.core.combiningAlgorithm.policy.AbstractPolicyCombiningAlgorithm;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.XACMLDefaultStatusCode;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.impl.PolicySetType;
import org.herasaf.xacml.core.targetMatcher.TargetMatchingResult;

public abstract class PolicyOrderedCombiningAlgorithm
extends AbstractPolicyCombiningAlgorithm {
    private static final long serialVersionUID = 1L;

    public DecisionType evaluate(RequestType request, Evaluatable evals, EvaluationContext evaluationContext) {
        TargetMatchingResult decision = this.matchTarget(request, evals.getTarget(), evaluationContext);
        if (decision == TargetMatchingResult.NO_MATCH) {
            return DecisionType.NOT_APPLICABLE;
        }
        if (decision == TargetMatchingResult.INDETERMINATE) {
            return DecisionType.INDETERMINATE;
        }
        try {
            DecisionType dec = this.evaluateEvaluatableList(request, ((PolicySetType)evals).getOrderedEvaluatables(evaluationContext), evaluationContext);
            evaluationContext.setTargetMatched(true);
            return dec;
        }
        catch (ClassCastException e) {
            evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
            return DecisionType.INDETERMINATE;
        }
    }
}

