/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.data;

import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.ChangeACL;
import de.fzj.unicore.xnjs.io.ChangePermissions;
import de.fzj.unicore.xnjs.io.FileFilter;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.Permissions;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.io.XnjsStorageInfo;
import eu.unicore.emi.data.EMI_Configuration;
import eu.unicore.emi.data.EMI_SRMClient;
import eu.unicore.emi.data.EMI_SRMCopyClientV2;
import eu.unicore.emi.data.EMI_SRMGetClientV2;
import eu.unicore.emi.data.EMI_SRMLsClientV2;
import eu.unicore.emi.data.EMI_SRMMkDirClientV2;
import eu.unicore.emi.data.EMI_SRMMvClientV2;
import eu.unicore.emi.data.EMI_SRMPutClientV2;
import eu.unicore.emi.data.EMI_SRMRmClientV2;
import eu.unicore.emi.data.EMI_SRMRmdirClientV2;
import eu.unicore.emi.data.EMI_SRMSetPermissionClientV2;
import eu.unicore.security.Client;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.UUID;
import org.globus.util.GlobusURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRMStorageAdapter
implements IStorageAdapter {
    private final Client client;
    private static Logger logger = LoggerFactory.getLogger(SRMStorageAdapter.class);
    private EMI_Configuration configuration = null;
    private String url_prefix = null;
    private boolean _testing = false;
    private String storageRoot = "/";
    private String savedProxy = null;
    private EMI_SRMLsClientV2.Listed recentlyListed = EMI_SRMLsClientV2.Listed.NOTHING;

    public SRMStorageAdapter(Client client, String srmHost, int srmPort) {
        this.client = client;
        this.configuration = new EMI_Configuration();
        this.configuration.setTransport("GSI");
        this.configuration.setUseproxy(true);
        this.configuration.setDebug(true);
        this.url_prefix = srmHost.startsWith("srm://") ? String.valueOf(srmHost) + ":" + srmPort : "srm://" + srmHost + ":" + srmPort;
        this._testing = Boolean.getBoolean("sms.srm._testing");
    }

    public SRMStorageAdapter(Client client, String srmHost, int srmPort, String proxy) {
        this(client, srmHost, srmPort);
        this.savedProxy = proxy;
    }

    private SRMStorageAdapter(Client client) {
        this.client = client;
        this.configuration = new EMI_Configuration();
        this.configuration.setTransport("GSI");
        this.configuration.setUseproxy(true);
        this.configuration.setDebug(true);
        this.url_prefix = "";
        this._testing = Boolean.getBoolean("sms.srm._testing");
    }

    public boolean isACLSupported(String path) {
        return false;
    }

    public XnjsFile[] ls(String base, int offset, int limit, boolean filter) throws ExecutionException {
        logger.debug("offset: " + offset + ", limit: " + limit + ", filter: " + filter);
        XnjsFileWithACL[] xnjsFile = this.ls(base);
        return xnjsFile;
    }

    public XnjsFileWithACL[] ls(String url) throws ExecutionException {
        url = this.makeAbsolute(url);
        logger.debug("ls " + url);
        EMI_Configuration conf = this.configuration;
        conf.setX509_user_proxy(this.storeProxy());
        conf.setSrmProtocolVersion(2);
        conf.setLongLsFormat(true);
        conf.setRecursionDepth(1);
        conf.setLogger(LoggerFactory.getLogger(EMI_SRMLsClientV2.class));
        url = String.valueOf(this.url_prefix) + url;
        GlobusURL[] gurl = new GlobusURL[1];
        String[] urls = new String[]{url};
        try {
            gurl[0] = new GlobusURL(url);
        }
        catch (MalformedURLException e) {
            logger.error("ls failed", (Throwable)e);
        }
        EMI_SRMLsClientV2 client = new EMI_SRMLsClientV2(conf, gurl, urls);
        try {
            client.connect();
            try {
                client.start();
            }
            catch (Exception e) {
                logger.error("ls failed", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("ls failed", (Throwable)e);
        }
        conf.setLongLsFormat(false);
        conf.setRecursionDepth(1);
        XnjsFileWithACL[] xnjsFile = client.getXnjsListing();
        this.recentlyListed = client.getRecentlyListed();
        this.destroyProxy(conf.getX509_user_proxy());
        return xnjsFile;
    }

    public void mkdir(String url) throws ExecutionException {
        if ("/".equals(url = this.makeAbsolute(url))) {
            return;
        }
        logger.debug("mkdir " + url);
        EMI_Configuration conf = this.configuration;
        conf.setX509_user_proxy(this.storeProxy());
        conf.setSrmProtocolVersion(2);
        conf.setLogger(LoggerFactory.getLogger(EMI_SRMMkDirClientV2.class));
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        url = String.valueOf(this.url_prefix) + url;
        GlobusURL gurl = null;
        try {
            gurl = new GlobusURL(url);
        }
        catch (MalformedURLException e) {
            logger.error("", (Throwable)e);
        }
        EMI_SRMMkDirClientV2 client = new EMI_SRMMkDirClientV2(conf, gurl, url);
        try {
            ((EMI_SRMClient)client).connect();
            try {
                ((EMI_SRMClient)client).start();
            }
            catch (Exception e) {
                logger.error("mkdir error", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("mkdir error", (Throwable)e);
        }
        this.destroyProxy(conf.getX509_user_proxy());
    }

    public void rename(String src, String dst) throws ExecutionException {
        src = this.makeAbsolute(src);
        dst = this.makeAbsolute(dst);
        EMI_Configuration conf = this.configuration;
        conf.setX509_user_proxy(this.storeProxy());
        conf.setSrmProtocolVersion(2);
        conf.setLogger(LoggerFactory.getLogger(EMI_SRMMvClientV2.class));
        src = String.valueOf(this.url_prefix) + src;
        dst = String.valueOf(this.url_prefix) + dst;
        GlobusURL[] gurl = new GlobusURL[2];
        try {
            gurl[0] = new GlobusURL(src);
            gurl[1] = new GlobusURL(dst);
        }
        catch (MalformedURLException e) {
            logger.error("", (Throwable)e);
        }
        EMI_SRMMvClientV2 client = new EMI_SRMMvClientV2(conf, gurl, new String[]{src, dst});
        try {
            ((EMI_SRMClient)client).connect();
            try {
                ((EMI_SRMClient)client).start();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        this.destroyProxy(conf.getX509_user_proxy());
    }

    public void rmdir(String url) throws ExecutionException {
        if ("/".equals(url = this.makeAbsolute(url))) {
            return;
        }
        this.ls(url);
        if (this.recentlyListed == EMI_SRMLsClientV2.Listed.NOTHING) {
            return;
        }
        if (this.recentlyListed == EMI_SRMLsClientV2.Listed.FILE) {
            this.rm(url);
            return;
        }
        EMI_Configuration conf = this.configuration;
        conf.setX509_user_proxy(this.storeProxy());
        conf.setSrmProtocolVersion(2);
        conf.setLogger(LoggerFactory.getLogger(EMI_SRMRmdirClientV2.class));
        url = String.valueOf(this.url_prefix) + url;
        GlobusURL gurl = null;
        try {
            gurl = new GlobusURL(url);
        }
        catch (MalformedURLException e) {
            logger.error("", (Throwable)e);
        }
        EMI_SRMRmdirClientV2 client = new EMI_SRMRmdirClientV2(conf, gurl, url);
        try {
            ((EMI_SRMClient)client).connect();
            try {
                ((EMI_SRMClient)client).start();
            }
            catch (Exception e) {
                logger.error("rmdir failed", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("rmdir failed", (Throwable)e);
        }
        this.destroyProxy(conf.getX509_user_proxy());
    }

    public void rm(String url) throws ExecutionException {
        url = this.makeAbsolute(url);
        EMI_Configuration conf = this.configuration;
        conf.setX509_user_proxy(this.storeProxy());
        conf.setLogger(LoggerFactory.getLogger(EMI_SRMRmClientV2.class));
        conf.setSrmProtocolVersion(2);
        url = String.valueOf(this.url_prefix) + url;
        GlobusURL[] gurl = new GlobusURL[1];
        try {
            gurl[0] = new GlobusURL(url);
        }
        catch (MalformedURLException e) {
            logger.error("rm failed", (Throwable)e);
        }
        EMI_SRMRmClientV2 client = new EMI_SRMRmClientV2(conf, gurl, new String[]{url});
        try {
            ((EMI_SRMClient)client).connect();
            try {
                ((EMI_SRMClient)client).start();
            }
            catch (Exception e) {
                logger.error("rm failed", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("rm failed", (Throwable)e);
        }
        this.destroyProxy(conf.getX509_user_proxy());
    }

    public void cp(String src, String dst) throws ExecutionException {
        src = this.makeAbsolute(src);
        dst = this.makeAbsolute(dst);
        EMI_Configuration conf = this.configuration;
        conf.setX509_user_proxy(this.storeProxy());
        conf.setSrmProtocolVersion(2);
        conf.setLogger(LoggerFactory.getLogger(EMI_SRMCopyClientV2.class));
        src = String.valueOf(this.url_prefix) + src;
        dst = String.valueOf(this.url_prefix) + dst;
        GlobusURL[] gsrc = new GlobusURL[1];
        GlobusURL[] gdst = new GlobusURL[1];
        try {
            gsrc[0] = new GlobusURL(src);
            gdst[0] = new GlobusURL(dst);
        }
        catch (MalformedURLException e) {
            logger.error("cp failed", (Throwable)e);
        }
        EMI_SRMCopyClientV2 client = new EMI_SRMCopyClientV2(conf, gsrc, gdst);
        try {
            ((EMI_SRMClient)client).connect();
            try {
                ((EMI_SRMClient)client).start();
            }
            catch (Exception e) {
                logger.error("cp failed", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("cp failed", (Throwable)e);
        }
        this.destroyProxy(conf.getX509_user_proxy());
    }

    public XnjsStorageInfo getAvailableDiskSpace(String path) {
        XnjsStorageInfo info = new XnjsStorageInfo();
        info.setFreeSpace(-1L);
        info.setTotalSpace(-1L);
        info.setUsableSpace(-1L);
        return info;
    }

    public String getFileSeparator() throws ExecutionException {
        return "/";
    }

    public String getFileSystemIdentifier() {
        return this.url_prefix;
    }

    public static InputStream getInputStream(Client client, String url) throws ExecutionException {
        logger.debug("getInputStream " + url);
        if (!url.startsWith("srm://")) {
            throw new ExecutionException("no srm url: " + url.substring(0, 10) + "...");
        }
        return new SRMStorageAdapter(client).getInputStream(url);
    }

    public InputStream getInputStream(String url) throws ExecutionException {
        InputStream is;
        EMI_Configuration conf;
        block13: {
            if (!url.startsWith(this.storageRoot)) {
                url = String.valueOf(this.storageRoot) + url;
            }
            logger.debug("getInputStream " + url);
            conf = this.configuration;
            conf.setX509_user_proxy(this.storeProxy());
            conf.setSrmProtocolVersion(2);
            conf.setLogger(LoggerFactory.getLogger(EMI_SRMGetClientV2.class));
            conf.setStreams_num(1);
            conf.setServerMode("passive");
            GlobusURL[] gurl = new GlobusURL[1];
            try {
                gurl[0] = new GlobusURL(String.valueOf(this.url_prefix) + url);
            }
            catch (MalformedURLException e) {
                logger.error("getInputStream failed", (Throwable)e);
            }
            if (gurl[0].getPort() == -1) {
                try {
                    gurl[0] = new GlobusURL(String.valueOf(gurl[0].getProtocol()) + "://" + gurl[0].getHost() + ":8443/" + gurl[0].getPath());
                }
                catch (MalformedURLException e) {
                    logger.error("getInputStream failed", (Throwable)e);
                }
            }
            GlobusURL[] gurl1 = new GlobusURL[1];
            try {
                gurl1[0] = new GlobusURL("file:////tmp/dummy.file");
            }
            catch (MalformedURLException e) {
                logger.error("getInputStream failed", (Throwable)e);
            }
            is = null;
            EMI_SRMGetClientV2 client = new EMI_SRMGetClientV2(conf, gurl, gurl1);
            Thread t = null;
            try {
                client.connect();
                client.setDebug(false);
                is = client.getInputStream();
                if (is != null) {
                    try {
                        t = new Thread(client);
                        t.start();
                    }
                    catch (Exception e) {
                        logger.error("srm transfer thread failed", (Throwable)e);
                    }
                    break block13;
                }
                logger.error("getInputStream: is = null");
                throw new ExecutionException("inputStream = null");
            }
            catch (Exception e) {
                logger.error("connect(), getInputStream() failed", (Throwable)e);
            }
        }
        this.destroyProxy(conf.getX509_user_proxy());
        return is;
    }

    public OutputStream getOutputStream(String url) throws ExecutionException {
        OutputStream os;
        EMI_Configuration conf;
        block8: {
            if (!url.startsWith(this.storageRoot)) {
                url = String.valueOf(this.storageRoot) + url;
            }
            conf = this.configuration;
            conf.setX509_user_proxy(this.storeProxy());
            conf.setSrmProtocolVersion(2);
            conf.setStreams_num(1);
            conf.setLogger(LoggerFactory.getLogger(EMI_SRMPutClientV2.class));
            conf.setServerMode("passive");
            logger.debug("getOutputStream " + url);
            url = String.valueOf(this.url_prefix) + url;
            GlobusURL[] gurl = new GlobusURL[1];
            GlobusURL[] gurl1 = new GlobusURL[1];
            try {
                gurl[0] = new GlobusURL("file:////bin/echo");
                gurl1[0] = new GlobusURL(url);
            }
            catch (MalformedURLException e) {
                logger.error("getOutputStream failed", (Throwable)e);
            }
            os = null;
            EMI_SRMPutClientV2 client = new EMI_SRMPutClientV2(conf, gurl, gurl1);
            Thread t = null;
            try {
                client.connect();
                client.setDebug(false);
                os = client.getOutputStream();
                if (os != null) {
                    try {
                        t = new Thread(client);
                        t.start();
                    }
                    catch (Exception e) {
                        logger.error("srm transfer thread failed", (Throwable)e);
                    }
                    break block8;
                }
                logger.error("getOutputStream: is = null");
                throw new ExecutionException("outputStream = null");
            }
            catch (Exception e) {
                logger.error("connect(), getOutputStream() failed", (Throwable)e);
            }
        }
        this.destroyProxy(conf.getX509_user_proxy());
        logger.debug("returning");
        return os;
    }

    public OutputStream getOutputStream(String resource, boolean append) throws ExecutionException {
        logger.debug("getOutputStream( " + resource + ", " + append + ")");
        if (append) {
            throw new ExecutionException("srm doesn't support appending writes");
        }
        return this.getOutputStream(resource);
    }

    public XnjsFileWithACL getProperties(String url) throws ExecutionException {
        logger.debug("getProperties " + url);
        if (url == null || url.equals("null")) {
            logger.debug("getProperties == null");
            return null;
        }
        if (!url.startsWith(this.storageRoot)) {
            url = String.valueOf(this.storageRoot) + url;
        }
        EMI_Configuration conf = this.configuration;
        conf.setX509_user_proxy(this.storeProxy());
        conf.setSrmProtocolVersion(2);
        conf.setLongLsFormat(true);
        conf.setRecursionDepth(0);
        conf.setLogger(LoggerFactory.getLogger(EMI_SRMLsClientV2.class));
        url = String.valueOf(this.url_prefix) + url;
        GlobusURL[] gurl = new GlobusURL[1];
        String[] urls = new String[]{url};
        try {
            gurl[0] = new GlobusURL(url);
        }
        catch (MalformedURLException e) {
            logger.error("getProperties failed for " + url, (Throwable)e);
        }
        EMI_SRMLsClientV2 client = new EMI_SRMLsClientV2(conf, gurl, urls);
        try {
            client.connect();
            try {
                client.start();
            }
            catch (Exception e) {
                logger.error("getProperties failed for " + url, (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("getProperties failed for " + url, (Throwable)e);
        }
        conf.setLongLsFormat(false);
        conf.setRecursionDepth(1);
        if (client.getXnjsListing() != null && client.getXnjsListing().length != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("getProperties: " + client.getXnjsListing()[0].getPath() + " (" + client.getXnjsListing().length + " items)");
            }
            this.destroyProxy(conf.getX509_user_proxy());
            return client.getXnjsListing()[0];
        }
        logger.debug("getProperties: null");
        this.destroyProxy(conf.getX509_user_proxy());
        return null;
    }

    private String storeProxy() throws ExecutionException {
        if (this._testing) {
            return "/tmp/x509up_u1000";
        }
        String pem = (String)this.client.getExtraAttributes().get("Proxy");
        if (pem == null) {
            if (this.savedProxy == null) {
                return null;
            }
            pem = this.savedProxy;
        }
        pem = pem.replaceAll("BEGIN PRIVATE KEY", "BEGIN RSA PRIVATE KEY");
        pem = pem.replaceAll("END PRIVATE KEY", "END RSA PRIVATE KEY");
        File f = null;
        FileOutputStream fos = null;
        try {
            try {
                f = File.createTempFile(UUID.randomUUID().toString(), "_proxy");
                fos = new FileOutputStream(f);
                fos.write(pem.getBytes());
                fos.close();
            }
            catch (Exception e) {
                throw new ExecutionException("Creating user proxy temp file failed", (Throwable)e);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return f.getAbsolutePath();
    }

    private void destroyProxy(String proxyFile) {
    }

    public void setStorageRoot(String root) {
        this.storageRoot = root;
    }

    public String getStorageRoot() {
        return this.storageRoot;
    }

    public void chmod(String url, Permissions perm) throws ExecutionException {
        url = this.makeAbsolute(url);
        logger.debug("chmod " + url);
        EMI_Configuration conf = this.configuration;
        conf.setX509_user_proxy(this.storeProxy());
        conf.setSrmProtocolVersion(2);
        conf.setLogger(LoggerFactory.getLogger(EMI_SRMSetPermissionClientV2.class));
        String ug = "";
        String o = "";
        if (perm.isReadable()) {
            ug = String.valueOf(ug) + "R";
            o = String.valueOf(o) + "R";
        }
        if (perm.isWritable()) {
            ug = String.valueOf(ug) + "W";
        }
        if (perm.isExecutable()) {
            ug = String.valueOf(ug) + "X";
            o = String.valueOf(o) + "X";
        }
        if (ug.isEmpty()) {
            ug = "NONE";
            o = "NONE";
        }
        conf.setSetOwnerPermissionMode(ug);
        conf.setSetGroupPermissionMode(ug);
        conf.setSetOtherPermissionMode(o);
        conf.setSetPermissionType("CHANGE");
        url = String.valueOf(this.url_prefix) + url;
        GlobusURL gurl = null;
        try {
            gurl = new GlobusURL(url);
        }
        catch (MalformedURLException e) {
            logger.error("chmod failed", (Throwable)e);
        }
        EMI_SRMSetPermissionClientV2 client = new EMI_SRMSetPermissionClientV2(conf, gurl, url);
        try {
            ((EMI_SRMClient)client).connect();
            try {
                ((EMI_SRMClient)client).start();
            }
            catch (Exception e) {
                logger.error("chmod failed", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("chmod failed", (Throwable)e);
        }
        conf.setSetGroupPermissionMode(null);
        conf.setSetOtherPermissionMode(null);
        conf.setSetOwnerPermissionMode(null);
        conf.setSetPermissionType(null);
        this.destroyProxy(conf.getX509_user_proxy());
    }

    public void chmod2(String url, ChangePermissions[] perm, boolean recursive) throws ExecutionException {
        url = this.makeAbsolute(url);
        logger.debug("chmod " + url);
        if (recursive) {
            throw new ExecutionException("no recursive allowed");
        }
        EMI_Configuration conf = this.configuration;
        conf.setX509_user_proxy(this.storeProxy());
        conf.setSrmProtocolVersion(2);
        conf.setLogger(LoggerFactory.getLogger(EMI_SRMSetPermissionClientV2.class));
        boolean permissionTypeSet = false;
        int i = 0;
        while (i < perm.length) {
            if (!permissionTypeSet) {
                permissionTypeSet = true;
                if (perm[i].getMode() == ChangePermissions.Mode.ADD) {
                    conf.setSetPermissionType("ADD");
                } else if (perm[i].getMode() == ChangePermissions.Mode.SET) {
                    conf.setSetPermissionType("CHANGE");
                } else if (perm[i].getMode() == ChangePermissions.Mode.SUBTRACT) {
                    conf.setSetPermissionType("REMOVE");
                } else {
                    permissionTypeSet = false;
                }
            }
            if (perm[i].getClazz() == ChangePermissions.PermissionsClass.OWNER) {
                conf.setSetOwnerPermissionMode(perm[i].getPermissions().toUpperCase());
            } else if (perm[i].getClazz() == ChangePermissions.PermissionsClass.GROUP) {
                conf.setSetGroupPermissionMode(perm[i].getPermissions().toUpperCase());
            } else if (perm[i].getClazz() == ChangePermissions.PermissionsClass.OTHER) {
                conf.setSetOtherPermissionMode(perm[i].getPermissions().toUpperCase());
            }
            ++i;
        }
        if (!permissionTypeSet) {
            throw new ExecutionException("no permission change type set");
        }
        url = String.valueOf(this.url_prefix) + url;
        GlobusURL gurl = null;
        try {
            gurl = new GlobusURL(url);
        }
        catch (MalformedURLException e) {
            logger.error("chmod failed", (Throwable)e);
        }
        EMI_SRMSetPermissionClientV2 client = new EMI_SRMSetPermissionClientV2(conf, gurl, url);
        try {
            ((EMI_SRMClient)client).connect();
            try {
                ((EMI_SRMClient)client).start();
            }
            catch (Exception e) {
                logger.error("chmod failed", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("chmod failed", (Throwable)e);
        }
        conf.setSetGroupPermissionMode(null);
        conf.setSetOtherPermissionMode(null);
        conf.setSetOwnerPermissionMode(null);
        conf.setSetPermissionType(null);
        this.destroyProxy(conf.getX509_user_proxy());
    }

    public XnjsFile[] find(String base, FileFilter options, int offset, int limit) throws ExecutionException {
        throw new ExecutionException("not implemented yet");
    }

    public void chgrp(String file, String newGroup, boolean recursive) throws ExecutionException {
        throw new ExecutionException("not implemented yet");
    }

    public void setfacl(String file, boolean clearAll, ChangeACL[] changeACL, boolean recursive) throws ExecutionException {
        throw new ExecutionException("not implemented yet");
    }

    public void setUmask(String umask) {
    }

    public String getUmask() {
        return "77";
    }

    protected String makeAbsolute(String path) {
        return new File(this.getStorageRoot(), path).getPath();
    }
}

