/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.data;

import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.xnjs.StorageAdapterFactory;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import eu.unicore.emi.data.SRMStorageAdapter;
import eu.unicore.emi.data.SRMStorageAdapterFactory;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRMStorage
extends SMSBaseImpl {
    private static final Logger logger = LoggerFactory.getLogger(SRMStorage.class);
    public static final String SRM_HOST = "srm.host";
    public static final String SRM_PORT = "srm.port";
    @Persist
    private String srmHost;
    @Persist
    private String srmPort;
    @Persist
    private String savedProxy;

    public void initialise(String name, Map<String, Object> params) throws Exception {
        super.initialise(name, params);
        StorageDescription sd = (StorageDescription)params.get(SMSBaseImpl.INIT_STORAGE_DESCRIPTION);
        this.srmHost = (String)sd.getAdditionalProperties().get(SRM_HOST);
        this.srmPort = (String)sd.getAdditionalProperties().get(SRM_PORT);
        this.workdir = this.storageDescription.getPathSpec();
        if (this.workdir == null) {
            this.workdir = "/";
        }
        if (this.getClient().getExtraAttributes().containsKey("Proxy")) {
            this.savedProxy = (String)this.getClient().getExtraAttributes().get("Proxy");
        }
        logger.info("Created SMS " + this.getUniqueID() + " accessing SRM at " + this.getSRMHost() + ":" + this.getSRMPort() + " " + "(got proxy cert: " + (this.savedProxy != null) + ")");
    }

    protected String getStorageRoot() {
        return this.workdir;
    }

    public IStorageAdapter getStorageAdapter() {
        if (this.savedProxy == null) {
            return new SRMStorageAdapter(this.getClient(), this.getSRMHost(), this.getSRMPort());
        }
        return new SRMStorageAdapter(this.getClient(), this.getSRMHost(), this.getSRMPort(), this.savedProxy);
    }

    protected StorageAdapterFactory getStorageAdapterFactory() {
        return new SRMStorageAdapterFactory(this.getSRMHost(), this.getSRMPort());
    }

    public String getSRMHost() {
        if (this.srmHost == null) {
            this.srmHost = this.kernel.getContainerProperties().getRawProperties().getProperty(SRM_HOST, "localhost");
            logger.debug("Using default SRM host " + this.srmHost);
        }
        return this.srmHost;
    }

    public int getSRMPort() {
        if (this.srmPort == null) {
            this.srmPort = this.kernel.getContainerProperties().getRawProperties().getProperty(SRM_PORT, "8443");
            logger.debug("Using default SRM port " + this.srmPort);
        }
        return Integer.parseInt(this.srmPort);
    }
}

