/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.data;

import eu.unicore.emi.data.EMI_SRMClient;
import gov.fnal.srm.util.CopyJob;
import org.apache.axis.types.URI;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortFilesRequest;
import org.dcache.srm.v2_2.SrmAbortFilesResponse;
import org.dcache.srm.v2_2.SrmPutDoneRequest;
import org.dcache.srm.v2_2.SrmPutDoneResponse;
import org.dcache.srm.v2_2.SrmReleaseFilesRequest;
import org.dcache.srm.v2_2.SrmReleaseFilesResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.globus.util.GlobusURL;
import org.slf4j.Logger;

public class EMI_SRMV2CopyJob
implements CopyJob {
    private GlobusURL from;
    private GlobusURL to;
    private ISRM srm;
    private boolean isDone;
    private Logger logger;
    private GlobusURL surl;
    private boolean isSrmPrepareToGet;
    private EMI_SRMClient client;
    private String requestToken;

    public EMI_SRMV2CopyJob(GlobusURL from, GlobusURL to, ISRM srm, String requestToken, Logger logger, GlobusURL surl, boolean isSrmPrepareToGet, EMI_SRMClient client) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("both source and destinationmust be non-null");
        }
        this.from = from;
        this.to = to;
        this.srm = srm;
        this.requestToken = requestToken;
        this.logger = logger;
        this.surl = surl;
        this.isSrmPrepareToGet = isSrmPrepareToGet;
        this.client = client;
    }

    public EMI_SRMV2CopyJob(GlobusURL from, GlobusURL to, Logger logger, GlobusURL surl, boolean isSrmPrepareToGet, EMI_SRMClient client) {
        this(from, to, null, null, logger, surl, isSrmPrepareToGet, client);
    }

    public GlobusURL getSource() {
        return this.from;
    }

    public GlobusURL getDestination() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EMI_SRMV2CopyJob)) {
            return false;
        }
        EMI_SRMV2CopyJob copy_job = (EMI_SRMV2CopyJob)o;
        return this.to.equals((Object)copy_job.to) && this.from.equals((Object)copy_job.from);
    }

    public String toString() {
        return "CopyJob, source = " + this.from.getURL() + " destination = " + this.to.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(boolean success, String error) {
        EMI_SRMV2CopyJob eMI_SRMV2CopyJob = this;
        synchronized (eMI_SRMV2CopyJob) {
            if (this.isDone) {
                return;
            }
        }
        if (success) {
            if (this.isSrmPrepareToGet) {
                this.client.setReportSucceeded(this.surl, null);
            } else {
                this.client.setReportSucceeded(null, this.surl);
            }
        } else {
            error = "received TURL but failed to copy: " + error;
            if (this.isSrmPrepareToGet) {
                this.client.setReportFailed(this.surl, null, error);
            } else {
                this.client.setReportFailed(null, this.surl, error);
            }
        }
        if (this.srm != null) {
            try {
                URI[] surlArray = new URI[]{new URI(this.surl.getURL())};
                if (success) {
                    if (this.isSrmPrepareToGet) {
                        SrmReleaseFilesRequest srmReleaseFilesRequest = new SrmReleaseFilesRequest();
                        srmReleaseFilesRequest.setRequestToken(this.requestToken);
                        srmReleaseFilesRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
                        SrmReleaseFilesResponse srmReleaseFilesResponse = this.srm.srmReleaseFiles(srmReleaseFilesRequest);
                        TReturnStatus returnStatus = srmReleaseFilesResponse.getReturnStatus();
                        if (returnStatus == null) {
                            this.logger.error("srmReleaseFilesResponse return status is null");
                            return;
                        }
                        this.logger.info("srmReleaseFilesResponse status code=" + returnStatus.getStatusCode());
                    } else {
                        SrmPutDoneRequest srmPutDoneRequest = new SrmPutDoneRequest();
                        srmPutDoneRequest.setRequestToken(this.requestToken);
                        srmPutDoneRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
                        SrmPutDoneResponse srmPutDoneResponse = this.srm.srmPutDone(srmPutDoneRequest);
                        TReturnStatus returnStatus = srmPutDoneResponse.getReturnStatus();
                        if (returnStatus == null) {
                            this.logger.error("srmPutDone return status is null");
                            return;
                        }
                        this.logger.info("srmPutDone status code=" + returnStatus.getStatusCode());
                    }
                } else {
                    SrmAbortFilesRequest srmAbortFilesRequest = new SrmAbortFilesRequest();
                    srmAbortFilesRequest.setRequestToken(this.requestToken);
                    srmAbortFilesRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
                    SrmAbortFilesResponse srmAbortFilesResponse = this.srm.srmAbortFiles(srmAbortFilesRequest);
                    if (srmAbortFilesResponse == null) {
                        this.logger.error(" srmAbortFilesResponse is null");
                    } else {
                        TReturnStatus returnStatus = srmAbortFilesResponse.getReturnStatus();
                        if (returnStatus == null) {
                            this.logger.error("srmAbortFiles return status is null");
                            return;
                        }
                        this.logger.info("srmAbortFiles status code=" + returnStatus.getStatusCode());
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(e.toString());
            }
        }
        eMI_SRMV2CopyJob = this;
        synchronized (eMI_SRMV2CopyJob) {
            this.isDone = true;
        }
    }
}

