/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.data;

import eu.unicore.emi.data.EMI_Configuration;
import eu.unicore.emi.data.EMI_Copier;
import eu.unicore.emi.data.EMI_SRMClient;
import eu.unicore.emi.data.EMI_SRMV2CopyJob;
import gov.fnal.srm.util.Report;
import gov.fnal.srm.util.SRMDispatcher;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis.types.URI;
import org.apache.axis.types.UnsignedLong;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ArrayOfString;
import org.dcache.srm.v2_2.ArrayOfTExtraInfo;
import org.dcache.srm.v2_2.ArrayOfTPutFileRequest;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortFilesRequest;
import org.dcache.srm.v2_2.SrmAbortFilesResponse;
import org.dcache.srm.v2_2.SrmPrepareToPutRequest;
import org.dcache.srm.v2_2.SrmPrepareToPutResponse;
import org.dcache.srm.v2_2.SrmStatusOfPutRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfPutRequestResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TAccessPattern;
import org.dcache.srm.v2_2.TConnectionType;
import org.dcache.srm.v2_2.TExtraInfo;
import org.dcache.srm.v2_2.TFileStorageType;
import org.dcache.srm.v2_2.TOverwriteMode;
import org.dcache.srm.v2_2.TPutFileRequest;
import org.dcache.srm.v2_2.TPutRequestFileStatus;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.srm.v2_2.TTransferParameters;
import org.globus.ftp.OutputStreamDataSource;
import org.globus.util.GlobusURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMI_SRMPutClientV2
extends EMI_SRMClient
implements Runnable {
    private GlobusURL[] from;
    private GlobusURL[] to;
    private String[] protocols;
    private HashMap<String, Integer> pendingSurlsToIndex = new HashMap();
    private EMI_Copier copier;
    private Thread hook;
    private ISRM srmv2;
    private String requestToken;
    private SrmPrepareToPutResponse response;
    private static final Logger logger = LoggerFactory.getLogger(EMI_SRMPutClientV2.class);
    private OutputStreamDataSource dataSource;

    public EMI_SRMPutClientV2(EMI_Configuration configuration, GlobusURL[] from, GlobusURL[] to) {
        super(configuration);
        this.report = new Report(from, to, configuration.getReport());
        this.protocols = configuration.getProtocols();
        this.from = from;
        this.to = to;
        logger.info("EMI_SRMPutClientV2()");
    }

    public OutputStream getOutputStream() {
        logger.info("getOutputStream()");
        return new BufferedOutputStream(this.dataSource.getOutputStream(), 0x100000);
    }

    public void setProtocols(String[] protocols) {
        logger.info("setProtocols()");
        this.protocols = protocols;
    }

    @Override
    public void start() throws Exception {
        logger.info("start()");
    }

    @Override
    public void connect() throws Exception {
        logger.info("connect()");
        GlobusURL srmUrl = this.to[0];
        this.srmv2 = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
        this.dataSource = new OutputStreamDataSource(0x100000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        logger.info("run()");
        try {
            try {
                int expectedResponseLength;
                SrmPrepareToPutRequest srmPrepareToPutRequest;
                TPutFileRequest[] fileRequests;
                int len;
                block72: {
                    this.copier = new EMI_Copier(this.urlcopy, this.configuration, this.dataSource);
                    this.copier.setDebug(this.debug);
                    new Thread(this.copier).start();
                    len = this.from.length;
                    fileRequests = new TPutFileRequest[len];
                    String storagetype = this.configuration.getStorageType();
                    String[] SURLS = new String[len];
                    int i = 0;
                    while (true) {
                        if (i >= len) {
                            this.hook = new Thread(this);
                            Runtime.getRuntime().addShutdownHook(this.hook);
                            srmPrepareToPutRequest = new SrmPrepareToPutRequest();
                            if (storagetype != null) {
                                if (!storagetype.equals("volatile")) break;
                                srmPrepareToPutRequest.setDesiredFileStorageType(TFileStorageType.VOLATILE);
                            }
                            break block72;
                        }
                        GlobusURL filesource = this.from[i];
                        int filetype = SRMDispatcher.getUrlType((GlobusURL)filesource);
                        if ((filetype & 8) == 0) {
                            throw new IOException(" source is not file " + filesource.getURL());
                        }
                        if ((filetype & 0x80) == 128) {
                            throw new IOException(" source is directory " + filesource.getURL());
                        }
                        if ((filetype & 0x20) == 0) {
                            throw new IOException(" source is not readable " + filesource.getURL());
                        }
                        File f = new File(filesource.getPath());
                        long filesize = f.length();
                        SURLS[i] = this.to[i].getURL();
                        URI uri = new URI(SURLS[i]);
                        fileRequests[i] = new TPutFileRequest();
                        fileRequests[i].setExpectedFileSize(new UnsignedLong(filesize));
                        fileRequests[i].setTargetSURL(uri);
                        this.pendingSurlsToIndex.put(SURLS[i], new Integer(i));
                        ++i;
                    }
                    if (storagetype.equals("durable")) {
                        srmPrepareToPutRequest.setDesiredFileStorageType(TFileStorageType.DURABLE);
                    } else {
                        if (!storagetype.equals("permanent")) throw new IllegalArgumentException("Unknown storage type \"" + storagetype + "\"");
                        srmPrepareToPutRequest.setDesiredFileStorageType(TFileStorageType.PERMANENT);
                    }
                }
                srmPrepareToPutRequest.setDesiredTotalRequestTime(new Integer((int)this.configuration.getRequestLifetime()));
                srmPrepareToPutRequest.setArrayOfFileRequests(new ArrayOfTPutFileRequest(fileRequests));
                TAccessPattern ap = null;
                if (this.configuration.getAccessPattern() != null) {
                    ap = TAccessPattern.fromString((String)this.configuration.getAccessPattern());
                }
                TConnectionType ct = null;
                if (this.configuration.getConnectionType() != null) {
                    ct = TConnectionType.fromString((String)this.configuration.getConnectionType());
                }
                ArrayOfString protocolArray = null;
                if (this.protocols != null) {
                    protocolArray = new ArrayOfString(this.protocols);
                }
                ArrayOfString arrayOfClientNetworks = null;
                if (this.configuration.getArrayOfClientNetworks() != null) {
                    arrayOfClientNetworks = new ArrayOfString(this.configuration.getArrayOfClientNetworks());
                }
                if (ap != null || ct != null || arrayOfClientNetworks != null || protocolArray != null) {
                    srmPrepareToPutRequest.setTransferParameters(new TTransferParameters(ap, ct, arrayOfClientNetworks, protocolArray));
                }
                TRetentionPolicy rp = null;
                TAccessLatency al = null;
                if (this.configuration.getRetentionPolicy() != null) {
                    rp = TRetentionPolicy.fromString((String)this.configuration.getRetentionPolicy());
                }
                if (this.configuration.getAccessLatency() != null) {
                    al = TAccessLatency.fromString((String)this.configuration.getAccessLatency());
                }
                if (al != null && rp == null) {
                    throw new IllegalArgumentException("if access latency is specified, then retention policy have to be specified as well");
                }
                if (rp != null) {
                    srmPrepareToPutRequest.setTargetFileRetentionPolicyInfo(new TRetentionPolicyInfo(rp, al));
                }
                if (this.configuration.getOverwriteMode() != null) {
                    srmPrepareToPutRequest.setOverwriteOption(TOverwriteMode.fromString((String)this.configuration.getOverwriteMode()));
                }
                if (this.configuration.getSpaceToken() != null) {
                    srmPrepareToPutRequest.setTargetSpaceToken(this.configuration.getSpaceToken());
                }
                if (this.configuration.getExtraParameters().size() > 0) {
                    TExtraInfo[] extraInfoArray = new TExtraInfo[this.configuration.getExtraParameters().size()];
                    int counter = 0;
                    Map<String, String> extraParameters = this.configuration.getExtraParameters();
                    Iterator<String> i = extraParameters.keySet().iterator();
                    while (true) {
                        if (!i.hasNext()) {
                            ArrayOfTExtraInfo arrayOfExtraInfo = new ArrayOfTExtraInfo(extraInfoArray);
                            srmPrepareToPutRequest.setStorageSystemInfo(arrayOfExtraInfo);
                            break;
                        }
                        String key = i.next();
                        String value = extraParameters.get(key);
                        extraInfoArray[counter++] = new TExtraInfo(key, value);
                    }
                }
                this.response = this.srmv2.srmPrepareToPut(srmPrepareToPutRequest);
                if (this.response == null) {
                    throw new IOException(" null response");
                }
                TReturnStatus status = this.response.getReturnStatus();
                if (status == null) {
                    throw new IOException(" null return status");
                }
                TStatusCode statusCode = status.getStatusCode();
                if (statusCode == null) {
                    throw new IOException(" null status code");
                }
                String explanation = status.getExplanation();
                if (RequestStatusTool.isFailedRequestStatus((TReturnStatus)status)) {
                    if (explanation == null) throw new IOException("srmPrepareToPut submission failed, unexpected or failed status : " + statusCode);
                    throw new IOException("srmPrepareToPut submission failed, unexpected or failed status : " + statusCode + " explanation= " + explanation);
                }
                this.requestToken = this.response.getRequestToken();
                logger.debug(" srm returned requestToken = " + this.requestToken);
                if (this.response.getArrayOfFileStatuses() == null) {
                    throw new IOException("returned PutRequestFileStatuses is an empty array");
                }
                TPutRequestFileStatus[] putRequestFileStatuses = this.response.getArrayOfFileStatuses().getStatusArray();
                if (putRequestFileStatuses.length != len) {
                    throw new IOException("incorrect number of GetRequestFileStatusesin RequestStatus expected " + len + " received " + putRequestFileStatuses.length);
                }
                do {
                    SrmStatusOfPutRequestResponse srmStatusOfPutRequestResponse;
                    if (this.pendingSurlsToIndex.isEmpty()) {
                        return;
                    }
                    long estimatedWaitInSeconds = 5L;
                    int i = 0;
                    while (true) {
                        if (i >= len) {
                            if (!this.pendingSurlsToIndex.isEmpty()) break;
                            logger.debug("no more pending transfers, breaking the loop");
                            Runtime.getRuntime().removeShutdownHook(this.hook);
                            return;
                        }
                        TPutRequestFileStatus putRequestFileStatus = putRequestFileStatuses[i];
                        URI surl = putRequestFileStatus.getSURL();
                        if (surl == null) {
                            logger.error("invalid putRequestFileStatus, surl is null");
                        } else {
                            String surl_string = surl.toString();
                            if (!this.pendingSurlsToIndex.containsKey(surl_string)) {
                                logger.error("invalid putRequestFileStatus, surl = " + surl_string + " not found");
                            } else {
                                int indx;
                                TReturnStatus fileStatus = putRequestFileStatus.getStatus();
                                if (fileStatus == null) {
                                    throw new IOException(" null file return status");
                                }
                                TStatusCode fileStatusCode = fileStatus.getStatusCode();
                                if (fileStatusCode == null) {
                                    throw new IOException(" null file status code");
                                }
                                if (RequestStatusTool.isFailedFileRequestStatus((TReturnStatus)fileStatus)) {
                                    String error = "retrieval of surl " + surl_string + " failed, status = " + fileStatusCode + " explanation=" + fileStatus.getExplanation();
                                    logger.error(error);
                                    indx = this.pendingSurlsToIndex.remove(surl_string);
                                    this.setReportFailed(this.from[indx], this.to[indx], error);
                                } else if (putRequestFileStatus.getTransferURL() != null && putRequestFileStatus.getTransferURL() != null) {
                                    GlobusURL globusTURL = new GlobusURL(putRequestFileStatus.getTransferURL().toString());
                                    indx = this.pendingSurlsToIndex.remove(surl_string);
                                    this.setReportFailed(this.from[indx], this.to[indx], "received TURL, but did not complete transfer");
                                    EMI_SRMV2CopyJob job = new EMI_SRMV2CopyJob(this.from[indx], globusTURL, this.srmv2, this.requestToken, logger, this.to[indx], false, this);
                                    this.copier.addCopyJob(job);
                                } else if (putRequestFileStatus.getEstimatedWaitTime() != null && (long)putRequestFileStatus.getEstimatedWaitTime().intValue() < estimatedWaitInSeconds && putRequestFileStatus.getEstimatedWaitTime() >= 1) {
                                    estimatedWaitInSeconds = putRequestFileStatus.getEstimatedWaitTime().intValue();
                                }
                            }
                        }
                        ++i;
                    }
                    if (estimatedWaitInSeconds > 60L) {
                        estimatedWaitInSeconds = 60L;
                    }
                    try {
                        logger.info("sleeping " + estimatedWaitInSeconds + " seconds ...");
                        Thread.sleep(estimatedWaitInSeconds * 1000L);
                    }
                    catch (InterruptedException ie) {
                        logger.error(ie.toString());
                    }
                    SrmStatusOfPutRequestRequest srmStatusOfPutRequestRequest = new SrmStatusOfPutRequestRequest();
                    srmStatusOfPutRequestRequest.setRequestToken(this.requestToken);
                    String[] pendingSurlStrings = this.pendingSurlsToIndex.keySet().toArray(new String[0]);
                    expectedResponseLength = pendingSurlStrings.length;
                    URI[] surlArray = new URI[expectedResponseLength];
                    int i2 = 0;
                    while (true) {
                        if (i2 >= expectedResponseLength) {
                            srmStatusOfPutRequestRequest.setArrayOfTargetSURLs(new ArrayOfAnyURI(surlArray));
                            srmStatusOfPutRequestResponse = this.srmv2.srmStatusOfPutRequest(srmStatusOfPutRequestRequest);
                            if (srmStatusOfPutRequestResponse != null) break;
                            throw new IOException(" null srmStatusOfPutRequestResponse");
                        }
                        surlArray[i2] = new URI(pendingSurlStrings[i2]);
                        ++i2;
                    }
                    if (srmStatusOfPutRequestResponse.getArrayOfFileStatuses() == null) {
                        logger.error("putRequestFileStatuses == null");
                        throw new IOException("putRequestFileStatuses == null");
                    }
                    putRequestFileStatuses = srmStatusOfPutRequestResponse.getArrayOfFileStatuses().getStatusArray();
                    if (putRequestFileStatuses.length != expectedResponseLength) {
                        logger.error("incorrect number of RequestFileStatuses");
                        throw new IOException("incorrect number of RequestFileStatuses");
                    }
                    status = srmStatusOfPutRequestResponse.getReturnStatus();
                    if (status == null) {
                        throw new IOException(" null return status");
                    }
                    statusCode = status.getStatusCode();
                    if (statusCode != null) continue;
                    throw new IOException(" null status code");
                } while (!RequestStatusTool.isFailedRequestStatus((TReturnStatus)status));
                String error = "srmPrepareToPut update failed, status : " + statusCode + " explanation=" + status.getExplanation();
                logger.error(error);
                int i = 0;
                while (true) {
                    if (i >= expectedResponseLength) {
                        throw new IOException(error);
                    }
                    TReturnStatus frstatus = putRequestFileStatuses[i].getStatus();
                    if (frstatus != null) {
                        logger.error("PutFileRequest[" + putRequestFileStatuses[i].getSURL() + "] status=" + frstatus.getStatusCode() + " explanation=" + frstatus.getExplanation());
                        if (!RequestStatusTool.isTransientStateStatus((TReturnStatus)frstatus)) {
                            this.pendingSurlsToIndex.remove(putRequestFileStatuses[i].getSURL().toString());
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
                try {
                    if (this.copier != null) {
                        logger.info("stopping copier");
                        this.copier.stop();
                        this.abortAllPendingFiles();
                    }
                }
                catch (Exception e1) {
                    logger.error(e1.toString());
                }
                if (this.copier != null) {
                    this.copier.doneAddingJobs();
                    try {
                        this.copier.waitCompletion();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                this.report.dumpReport();
                if (this.report.everythingAllRight()) return;
                logger.error("srm copy of at least one file failed or not completed");
                this.copier.stop();
                logger.error("Copier stopped");
                return;
            }
        }
        finally {
            if (this.copier != null) {
                this.copier.doneAddingJobs();
                try {
                    this.copier.waitCompletion();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.report.dumpReport();
            if (!this.report.everythingAllRight()) {
                logger.error("srm copy of at least one file failed or not completed");
                this.copier.stop();
                logger.error("Copier stopped");
            }
        }
    }

    private void abortAllPendingFiles() throws Exception {
        logger.info("abortAllPendingFiles()");
        if (this.pendingSurlsToIndex.isEmpty()) {
            return;
        }
        if (this.response != null) {
            this.requestToken = this.response.getRequestToken();
            if (this.requestToken != null) {
                String[] surl_strings = this.pendingSurlsToIndex.keySet().toArray(new String[0]);
                int len = surl_strings.length;
                logger.info("Releasing all remaining file requests");
                URI[] surlArray = new URI[len];
                int i = 0;
                while (i < len) {
                    surlArray[i] = new URI(surl_strings[i]);
                    ++i;
                }
                SrmAbortFilesRequest srmAbortFilesRequest = new SrmAbortFilesRequest();
                srmAbortFilesRequest.setRequestToken(this.requestToken);
                srmAbortFilesRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
                SrmAbortFilesResponse srmAbortFilesResponse = this.srmv2.srmAbortFiles(srmAbortFilesRequest);
                if (srmAbortFilesResponse == null) {
                    logger.error(" srmAbortFilesResponse is null");
                } else {
                    TReturnStatus returnStatus = srmAbortFilesResponse.getReturnStatus();
                    if (returnStatus == null) {
                        logger.error("srmAbortFiles return status is null");
                        return;
                    }
                    logger.info("srmAbortFiles status code=" + returnStatus.getStatusCode());
                }
            } else if (this.response.getArrayOfFileStatuses() != null && this.response.getArrayOfFileStatuses().getStatusArray() != null) {
                int i = 0;
                while (i < this.response.getArrayOfFileStatuses().getStatusArray().length) {
                    URI surl = this.response.getArrayOfFileStatuses().getStatusArray(i).getSURL();
                    TReturnStatus fst = this.response.getArrayOfFileStatuses().getStatusArray(i).getStatus();
                    logger.error("SURL[" + i + "]=" + surl.toString() + " status=" + fst.getStatusCode() + " explanation=" + fst.getExplanation());
                    ++i;
                }
            }
        }
    }
}

