/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.data;

import eu.unicore.emi.data.EMI_Configuration;
import eu.unicore.emi.data.EMI_SRMClient;
import org.apache.axis.types.URI;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmMvRequest;
import org.dcache.srm.v2_2.SrmMvResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMI_SRMMvClientV2
extends EMI_SRMClient {
    private GSSCredential cred = null;
    private GlobusURL[] surls;
    private String[] surl_strings;
    private ISRM isrm;
    private static final Logger logger = LoggerFactory.getLogger(EMI_SRMMvClientV2.class);

    public EMI_SRMMvClientV2(EMI_Configuration configuration, GlobusURL[] surls, String[] surl_strings) {
        super(configuration);
        this.surls = surls;
        this.surl_strings = surl_strings;
        try {
            this.cred = this.getGssCredential();
        }
        catch (Exception e) {
            this.cred = null;
            logger.error("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        GlobusURL srmUrl = this.surls[0];
        this.isrm = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        if (this.cred.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        SrmMvRequest req = new SrmMvRequest();
        req.setFromSURL(new URI(this.surl_strings[0]));
        req.setToSURL(new URI(this.surl_strings[1]));
        SrmMvResponse resp = this.isrm.srmMv(req);
        TReturnStatus rs = resp.getReturnStatus();
        if (rs.getStatusCode() != TStatusCode.SRM_SUCCESS) {
            TStatusCode rc = rs.getStatusCode();
            StringBuffer sb = new StringBuffer();
            sb.append("Return code: " + rc.toString() + "\n");
            sb.append("Explanation: " + rs.getExplanation() + "\n");
            logger.debug(sb.toString());
        }
    }
}

