/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.data;

import eu.unicore.emi.data.EMI_Configuration;
import eu.unicore.emi.data.EMI_SRMClient;
import org.apache.axis.types.URI;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmMkdirRequest;
import org.dcache.srm.v2_2.SrmMkdirResponse;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMI_SRMMkDirClientV2
extends EMI_SRMClient {
    private GSSCredential cred = null;
    private GlobusURL surl;
    private String surl_string;
    private ISRM isrm;
    private static final Logger logger = LoggerFactory.getLogger(EMI_SRMMkDirClientV2.class);

    public EMI_SRMMkDirClientV2(EMI_Configuration configuration, GlobusURL surl, String surl_string) {
        super(configuration);
        this.surl = surl;
        this.surl_string = surl_string;
        try {
            this.cred = this.getGssCredential();
        }
        catch (Exception e) {
            this.cred = null;
            logger.error("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        GlobusURL srmUrl = this.surl;
        this.isrm = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    @Override
    public void start() throws Exception {
        if (this.cred.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        SrmMkdirRequest req = new SrmMkdirRequest();
        req.setSURL(new URI(this.surl_string));
        SrmMkdirResponse resp = this.isrm.srmMkdir(req);
        TReturnStatus rs = resp.getReturnStatus();
        if (rs.getStatusCode() != TStatusCode.SRM_SUCCESS) {
            TStatusCode rc = rs.getStatusCode();
            StringBuffer sb = new StringBuffer();
            sb.append("Return code: " + rc.toString() + "\n");
            sb.append("Explanation: " + rs.getExplanation() + "\n");
            logger.info(sb.toString());
        }
    }
}

