/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.data;

import de.fzj.unicore.xnjs.io.Permissions;
import de.fzj.unicore.xnjs.io.XnjsFileImpl;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import eu.unicore.emi.data.EMI_Configuration;
import eu.unicore.emi.data.EMI_SRMClient;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.axis.types.URI;
import org.apache.axis.types.UnsignedLong;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortRequestRequest;
import org.dcache.srm.v2_2.SrmAbortRequestResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TFileLocality;
import org.dcache.srm.v2_2.TFileStorageType;
import org.dcache.srm.v2_2.TFileType;
import org.dcache.srm.v2_2.TGroupPermission;
import org.dcache.srm.v2_2.TMetaDataPathDetail;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.srm.v2_2.TUserPermission;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMI_SRMLsClientV2
extends EMI_SRMClient
implements Runnable {
    private GSSCredential cred = null;
    private GlobusURL[] surls;
    private String[] surl_strings;
    private ISRM isrm;
    private String requestToken;
    private Thread hook;
    private XnjsFileImpl[] xnjsFiles = null;
    private Listed recentlyListed = Listed.NOTHING;
    private static final Logger logger = LoggerFactory.getLogger(EMI_SRMLsClientV2.class);

    public EMI_SRMLsClientV2(EMI_Configuration configuration, GlobusURL[] surls, String[] surl_strings) {
        super(configuration);
        this.surls = surls;
        this.surl_strings = surl_strings;
        try {
            this.cred = this.getGssCredential();
        }
        catch (Exception e) {
            this.cred = null;
            logger.error("Couldn't getGssCredential.");
        }
    }

    public Listed getRecentlyListed() {
        Listed tmp = this.recentlyListed;
        this.recentlyListed = Listed.NOTHING;
        return tmp;
    }

    public XnjsFileWithACL[] getXnjsListing() {
        if (this.xnjsFiles == null) {
            logger.info("getXnjsListing null");
        } else {
            logger.info("getXnjsListing " + this.xnjsFiles.length);
        }
        if (this.xnjsFiles != null) {
            return this.xnjsFiles;
        }
        return new XnjsFileImpl[0];
    }

    @Override
    public void connect() throws Exception {
        GlobusURL srmUrl = this.surls[0];
        this.isrm = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    /*
     * Exception decompiling
     */
    @Override
    public void start() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void fillXnjsFileListing(TMetaDataPathDetail[] details) {
        logger.info("fillXnjsFileListing " + details.length);
        ArrayList<XnjsFileImpl> list = new ArrayList<XnjsFileImpl>();
        this.fillXnjsFileListingDetails(details, list);
        this.xnjsFiles = list.toArray(new XnjsFileImpl[0]);
        logger.info("fillXnjsFileListing done");
    }

    private void fillXnjsFileListingDetails(TMetaDataPathDetail[] details, ArrayList<XnjsFileImpl> list) {
        this.recentlyListed = Listed.FILE;
        int i = 0;
        while (i < details.length) {
            block30: {
                block31: {
                    block29: {
                        if (details[i].getPath().endsWith(this.surls[0].getPath()) && details[i].getType() == TFileType.DIRECTORY) break block29;
                        if (details[i].getLastModificationTime() == null) break block30;
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(details[i].getLastModificationTime().getTime());
                        Permissions permissions = new Permissions();
                        permissions.setReadable(details[i].getOwnerPermission().getMode().getValue().contains("R"));
                        permissions.setWritable(details[i].getOwnerPermission().getMode().getValue().contains("W"));
                        permissions.setExecutable(details[i].getOwnerPermission().getMode().getValue().contains("X"));
                        XnjsFileImpl xnjsFile = new XnjsFileImpl();
                        xnjsFile.setPath(details[i].getPath());
                        xnjsFile.setDirectory(details[i].getType() == TFileType.DIRECTORY);
                        xnjsFile.setLastModified(cal);
                        xnjsFile.setSize(details[i].getSize().longValue());
                        xnjsFile.setPermissions(permissions);
                        String unixPermissions = "";
                        if (details[i].getOwnerPermission().getMode().getValue().equals("R")) {
                            unixPermissions = String.valueOf(unixPermissions) + "r--";
                        } else if (details[i].getOwnerPermission().getMode().getValue().equals("RW")) {
                            unixPermissions = String.valueOf(unixPermissions) + "rw-";
                        } else if (details[i].getOwnerPermission().getMode().getValue().equals("RX")) {
                            unixPermissions = String.valueOf(unixPermissions) + "r-x";
                        } else if (details[i].getOwnerPermission().getMode().getValue().equals("RWX")) {
                            unixPermissions = String.valueOf(unixPermissions) + "rwx";
                        } else if (details[i].getOwnerPermission().getMode().getValue().equals("NONE")) {
                            unixPermissions = String.valueOf(unixPermissions) + "---";
                        }
                        if (details[i].getGroupPermission().getMode().getValue().equals("R")) {
                            unixPermissions = String.valueOf(unixPermissions) + "r--";
                        } else if (details[i].getGroupPermission().getMode().getValue().equals("RW")) {
                            unixPermissions = String.valueOf(unixPermissions) + "rw-";
                        } else if (details[i].getGroupPermission().getMode().getValue().equals("RX")) {
                            unixPermissions = String.valueOf(unixPermissions) + "r-x";
                        } else if (details[i].getGroupPermission().getMode().getValue().equals("RWX")) {
                            unixPermissions = String.valueOf(unixPermissions) + "rwx";
                        } else if (details[i].getGroupPermission().getMode().getValue().equals("NONE")) {
                            unixPermissions = String.valueOf(unixPermissions) + "---";
                        }
                        if (details[i].getOtherPermission().getValue().equals("R")) {
                            unixPermissions = String.valueOf(unixPermissions) + "r--";
                        } else if (details[i].getOtherPermission().getValue().equals("RW")) {
                            unixPermissions = String.valueOf(unixPermissions) + "rw-";
                        } else if (details[i].getOtherPermission().getValue().equals("RX")) {
                            unixPermissions = String.valueOf(unixPermissions) + "r-x";
                        } else if (details[i].getOtherPermission().getValue().equals("RWX")) {
                            unixPermissions = String.valueOf(unixPermissions) + "rwx";
                        } else if (details[i].getOtherPermission().getValue().equals("NONE")) {
                            unixPermissions = String.valueOf(unixPermissions) + "---";
                        }
                        xnjsFile.setUNIXPermissions(unixPermissions);
                        xnjsFile.setOwner(details[i].getOwnerPermission().getUserID());
                        xnjsFile.setGroup(details[i].getGroupPermission().getGroupID());
                        list.add(xnjsFile);
                        break block31;
                    }
                    this.recentlyListed = Listed.DIRECTORY;
                }
                if (details[i].getArrayOfSubPaths() != null && details[i].getArrayOfSubPaths().getPathDetailArray() != null) {
                    this.fillXnjsFileListingDetails(details[i].getArrayOfSubPaths().getPathDetailArray(), list);
                }
            }
            ++i;
        }
    }

    @Override
    public void run() {
        try {
            logger.info("stopping ");
            if (this.requestToken != null) {
                this.abortRequest();
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }

    public void abortRequest() throws Exception {
        SrmAbortRequestRequest abortRequest = new SrmAbortRequestRequest();
        abortRequest.setRequestToken(this.requestToken);
        SrmAbortRequestResponse abortResponse = this.isrm.srmAbortRequest(abortRequest);
        if (abortResponse == null) {
            logger.error(" SrmAbort is null");
        } else {
            TReturnStatus returnStatus = abortResponse.getReturnStatus();
            if (returnStatus == null) {
                logger.error("srmAbort return status is null");
                return;
            }
            logger.info("srmAbortRequest status code=" + returnStatus.getStatusCode());
        }
    }

    public URI getTSURLInfo(String surl) throws Exception {
        URI uri = new URI(surl);
        return uri;
    }

    public static void printResults(StringBuffer sb, TMetaDataPathDetail[] ta, int depth, String depthPrefix, boolean longFormat) {
        if (ta != null) {
            int i = 0;
            while (i < ta.length) {
                TMetaDataPathDetail metaDataPathDetail = ta[i];
                if (metaDataPathDetail != null) {
                    if (metaDataPathDetail.getStatus().getStatusCode() == TStatusCode.fromString((String)"SRM_INVALID_PATH")) {
                        sb.append("SRM_INVALID_PATH").append(" ").append(depthPrefix).append(" File/directory " + i + " " + metaDataPathDetail.getPath() + " does not exist. \n");
                    } else {
                        sb.append(depthPrefix);
                        UnsignedLong size = metaDataPathDetail.getSize();
                        if (size != null) {
                            sb.append(" ").append(size.longValue());
                        }
                        sb.append(" ").append(metaDataPathDetail.getPath());
                        if (metaDataPathDetail.getType() == TFileType.DIRECTORY) {
                            sb.append("/");
                        }
                        if (metaDataPathDetail.getStatus().getStatusCode() != TStatusCode.SRM_SUCCESS) {
                            sb.append(" (" + metaDataPathDetail.getStatus().getStatusCode() + "," + metaDataPathDetail.getStatus().getExplanation() + ")");
                        }
                        sb.append('\n');
                        if (longFormat) {
                            StringBuffer dsb;
                            Date tdate;
                            sb.append(" space token(s) :");
                            if (metaDataPathDetail.getArrayOfSpaceTokens() != null) {
                                int j = 0;
                                while (j < metaDataPathDetail.getArrayOfSpaceTokens().getStringArray().length) {
                                    if (j == metaDataPathDetail.getArrayOfSpaceTokens().getStringArray().length - 1) {
                                        sb.append(metaDataPathDetail.getArrayOfSpaceTokens().getStringArray()[j]);
                                    } else {
                                        sb.append(String.valueOf(metaDataPathDetail.getArrayOfSpaceTokens().getStringArray()[j]) + ",");
                                    }
                                    ++j;
                                }
                            } else {
                                sb.append("none found");
                            }
                            sb.append('\n');
                            TFileStorageType stortype = metaDataPathDetail.getFileStorageType();
                            if (stortype != null) {
                                sb.append(depthPrefix);
                                sb.append(" storage type:").append(stortype.getValue());
                                sb.append('\n');
                            } else {
                                sb.append(" type: null");
                                sb.append('\n');
                            }
                            TRetentionPolicyInfo rpi = metaDataPathDetail.getRetentionPolicyInfo();
                            if (rpi != null) {
                                TRetentionPolicy rt = rpi.getRetentionPolicy();
                                if (rt != null) {
                                    sb.append(depthPrefix);
                                    sb.append(" retention policy:").append(rt.getValue());
                                    sb.append('\n');
                                } else {
                                    sb.append(" retention policy: null");
                                    sb.append('\n');
                                }
                                TAccessLatency al = rpi.getAccessLatency();
                                if (al != null) {
                                    sb.append(depthPrefix);
                                    sb.append(" access latency:").append(al.getValue());
                                    sb.append('\n');
                                } else {
                                    sb.append(" access latency: null");
                                    sb.append('\n');
                                }
                            } else {
                                sb.append(" retentionpolicyinfo : null");
                                sb.append('\n');
                            }
                            TFileLocality locality = metaDataPathDetail.getFileLocality();
                            if (locality != null) {
                                sb.append(depthPrefix);
                                sb.append(" locality:").append(locality.getValue());
                                sb.append('\n');
                            } else {
                                sb.append(" locality: null");
                                sb.append('\n');
                            }
                            if (metaDataPathDetail.getCheckSumValue() != null) {
                                sb.append(depthPrefix).append(" - Checksum value:  " + metaDataPathDetail.getCheckSumValue() + '\n');
                            }
                            if (metaDataPathDetail.getCheckSumType() != null) {
                                sb.append(depthPrefix).append(" - Checksum type:  " + metaDataPathDetail.getCheckSumType() + '\n');
                            }
                            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                            FieldPosition tfp = new FieldPosition(0);
                            if (metaDataPathDetail.getOwnerPermission() != null) {
                                TUserPermission up = metaDataPathDetail.getOwnerPermission();
                                sb.append(depthPrefix).append("  UserPermission:");
                                sb.append(" uid=").append(up.getUserID());
                                sb.append(" Permissions");
                                sb.append(up.getMode().getValue());
                                sb.append('\n');
                            }
                            if (metaDataPathDetail.getGroupPermission() != null) {
                                TGroupPermission gp = metaDataPathDetail.getGroupPermission();
                                sb.append(depthPrefix).append("  GroupPermission:");
                                sb.append(" gid=").append(gp.getGroupID());
                                sb.append(" Permissions");
                                sb.append(gp.getMode().getValue());
                                sb.append('\n');
                            }
                            if (metaDataPathDetail.getOtherPermission() != null) {
                                sb.append(depthPrefix).append(" WorldPermission: ");
                                sb.append(metaDataPathDetail.getOtherPermission().getValue());
                                sb.append('\n');
                            }
                            if (metaDataPathDetail.getCreatedAtTime() != null && (tdate = metaDataPathDetail.getCreatedAtTime().getTime()) != null) {
                                dsb = new StringBuffer();
                                df.format(tdate, dsb, tfp);
                                sb.append(depthPrefix).append("created at:").append(dsb);
                                sb.append('\n');
                            }
                            if (metaDataPathDetail.getLastModificationTime() != null && (tdate = metaDataPathDetail.getLastModificationTime().getTime()) != null) {
                                dsb = new StringBuffer();
                                df.format(tdate, dsb, tfp);
                                sb.append(depthPrefix);
                                sb.append("modified at:").append(dsb);
                                sb.append('\n');
                            }
                            if (metaDataPathDetail.getLifetimeAssigned() != null) {
                                sb.append(depthPrefix).append("  - Assigned lifetime (in seconds):  " + metaDataPathDetail.getLifetimeAssigned() + '\n');
                            }
                            if (metaDataPathDetail.getLifetimeLeft() != null) {
                                sb.append(depthPrefix).append(" - Lifetime left (in seconds):  " + metaDataPathDetail.getLifetimeLeft() + '\n');
                            }
                            sb.append(depthPrefix).append(" - Original SURL:  " + metaDataPathDetail.getPath() + '\n' + " - Status:  " + metaDataPathDetail.getStatus().getExplanation() + '\n' + " - Type:  " + metaDataPathDetail.getType() + '\n');
                        }
                        if (metaDataPathDetail.getArrayOfSubPaths() != null) {
                            TMetaDataPathDetail[] subpaths = metaDataPathDetail.getArrayOfSubPaths().getPathDetailArray();
                            if (subpaths == ta) {
                                sb.append(depthPrefix).append(" circular subpath reference !!!");
                            } else {
                                EMI_SRMLsClientV2.printResults(sb, subpaths, depth + 1, String.valueOf(depthPrefix) + "    ", longFormat);
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    public static enum Listed {
        NOTHING,
        DIRECTORY,
        FILE;

    }
}

