/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.data;

import eu.unicore.emi.data.EMI_Configuration;
import eu.unicore.emi.data.EMI_Copier;
import eu.unicore.emi.data.EMI_SRMClient;
import eu.unicore.emi.data.EMI_SRMV2CopyJob;
import gov.fnal.srm.util.Report;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis.types.URI;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ArrayOfString;
import org.dcache.srm.v2_2.ArrayOfTExtraInfo;
import org.dcache.srm.v2_2.ArrayOfTGetFileRequest;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortFilesRequest;
import org.dcache.srm.v2_2.SrmAbortFilesResponse;
import org.dcache.srm.v2_2.SrmPrepareToGetRequest;
import org.dcache.srm.v2_2.SrmPrepareToGetResponse;
import org.dcache.srm.v2_2.SrmStatusOfGetRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfGetRequestResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TAccessPattern;
import org.dcache.srm.v2_2.TConnectionType;
import org.dcache.srm.v2_2.TExtraInfo;
import org.dcache.srm.v2_2.TGetFileRequest;
import org.dcache.srm.v2_2.TGetRequestFileStatus;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.srm.v2_2.TTransferParameters;
import org.globus.ftp.InputStreamDataSink;
import org.globus.util.GlobusURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMI_SRMGetClientV2
extends EMI_SRMClient
implements Runnable {
    private String[] protocols;
    GlobusURL[] from;
    GlobusURL[] to;
    private HashMap<String, Integer> pendingSurlsToIndex = new HashMap();
    private EMI_Copier copier;
    private String requestToken;
    private Thread hook;
    private ISRM srmv2;
    private InputStreamDataSink dataSink;
    private static final Logger logger = LoggerFactory.getLogger(EMI_SRMGetClientV2.class);

    public EMI_SRMGetClientV2(EMI_Configuration configuration, GlobusURL[] from, GlobusURL[] to) {
        super(configuration);
        logger.info("EMI_SRMGetClientV2()");
        this.report = new Report(from, to, configuration.getReport());
        this.protocols = configuration.getProtocols();
        this.from = from;
        this.to = to;
    }

    @Override
    public void connect() throws Exception {
        logger.info("connect()");
        GlobusURL srmUrl = this.from[0];
        this.srmv2 = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
        logger.info("dataSink = new InputStreamDataSink()");
        this.dataSink = new InputStreamDataSink();
    }

    public InputStream getInputStream() {
        logger.info("getInputStream()");
        return new BufferedInputStream(this.dataSink.getInputStream(), 0x100000);
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    @Override
    public void start() throws Exception {
        logger.info("start()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            try {
                String error;
                int expectedResponseLength;
                TAccessLatency al;
                TRetentionPolicy rp;
                SrmPrepareToGetRequest srmPrepareToGetRequest;
                logger.info("start()");
                this.copier = new EMI_Copier(this.urlcopy, this.configuration, this.dataSink);
                this.copier.setDebug(this.debug);
                new Thread(this.copier).start();
                int len = this.from.length;
                String[] SURLS = new String[len];
                TGetFileRequest[] fileRequests = new TGetFileRequest[len];
                int i = 0;
                while (true) {
                    if (i >= len) {
                        this.hook = new Thread(this);
                        Runtime.getRuntime().addShutdownHook(this.hook);
                        srmPrepareToGetRequest = new SrmPrepareToGetRequest();
                        srmPrepareToGetRequest.setDesiredTotalRequestTime(new Integer((int)this.configuration.getRequestLifetime()));
                        rp = null;
                        al = null;
                        if (this.configuration.getRetentionPolicy() != null) {
                            rp = TRetentionPolicy.fromString((String)this.configuration.getRetentionPolicy());
                        }
                        if (this.configuration.getAccessLatency() != null) {
                            al = TAccessLatency.fromString((String)this.configuration.getAccessLatency());
                        }
                        if (al == null || rp != null) break;
                        throw new IllegalArgumentException("if access latency is specified, then retention policy have to be specified as well");
                    }
                    SURLS[i] = this.from[i].getURL();
                    URI uri = new URI(SURLS[i]);
                    fileRequests[i] = new TGetFileRequest();
                    fileRequests[i].setSourceSURL(uri);
                    this.pendingSurlsToIndex.put(SURLS[i], new Integer(i));
                    ++i;
                }
                if (rp != null) {
                    srmPrepareToGetRequest.setTargetFileRetentionPolicyInfo(new TRetentionPolicyInfo(rp, al));
                }
                srmPrepareToGetRequest.setArrayOfFileRequests(new ArrayOfTGetFileRequest(fileRequests));
                TAccessPattern ap = null;
                if (this.configuration.getAccessPattern() != null) {
                    ap = TAccessPattern.fromString((String)this.configuration.getAccessPattern());
                }
                TConnectionType ct = null;
                if (this.configuration.getConnectionType() != null) {
                    ct = TConnectionType.fromString((String)this.configuration.getConnectionType());
                }
                ArrayOfString protocolArray = null;
                if (this.protocols != null) {
                    protocolArray = new ArrayOfString(this.protocols);
                }
                ArrayOfString arrayOfClientNetworks = null;
                if (this.configuration.getArrayOfClientNetworks() != null) {
                    arrayOfClientNetworks = new ArrayOfString(this.configuration.getArrayOfClientNetworks());
                }
                if (ap != null || ct != null || arrayOfClientNetworks != null || protocolArray != null) {
                    srmPrepareToGetRequest.setTransferParameters(new TTransferParameters(ap, ct, arrayOfClientNetworks, protocolArray));
                }
                if (this.configuration.getExtraParameters().size() > 0) {
                    TExtraInfo[] extraInfoArray = new TExtraInfo[this.configuration.getExtraParameters().size()];
                    int counter = 0;
                    Map<String, String> extraParameters = this.configuration.getExtraParameters();
                    Iterator<String> i2 = extraParameters.keySet().iterator();
                    while (true) {
                        if (!i2.hasNext()) {
                            ArrayOfTExtraInfo arrayOfExtraInfo = new ArrayOfTExtraInfo(extraInfoArray);
                            srmPrepareToGetRequest.setStorageSystemInfo(arrayOfExtraInfo);
                            break;
                        }
                        String key = i2.next();
                        String value = extraParameters.get(key);
                        extraInfoArray[counter++] = new TExtraInfo(key, value);
                    }
                }
                logger.info("calling srmPrepareToGet");
                SrmPrepareToGetResponse response = this.srmv2.srmPrepareToGet(srmPrepareToGetRequest);
                logger.info("received response");
                if (response == null) {
                    throw new IOException(" null response");
                }
                TReturnStatus status = response.getReturnStatus();
                if (status == null) {
                    throw new IOException(" null return status");
                }
                TStatusCode statusCode = status.getStatusCode();
                if (statusCode == null) {
                    throw new IOException(" null status code");
                }
                if (RequestStatusTool.isFailedRequestStatus((TReturnStatus)status)) {
                    throw new IOException("srmPrepareToGet submission failed, unexpected or failed status : " + statusCode + " explanation=" + status.getExplanation());
                }
                this.requestToken = response.getRequestToken();
                logger.debug(" srm returned requestToken = " + this.requestToken);
                if (response.getArrayOfFileStatuses() == null) {
                    throw new IOException("returned GetRequestFileStatuses is an empty array");
                }
                TGetRequestFileStatus[] getRequestFileStatuses = response.getArrayOfFileStatuses().getStatusArray();
                if (getRequestFileStatuses.length != len) {
                    throw new IOException("incorrect number of GetRequestFileStatusesin RequestStatus expected " + len + " received " + getRequestFileStatuses.length);
                }
                do {
                    SrmStatusOfGetRequestResponse srmStatusOfGetRequestResponse;
                    if (this.pendingSurlsToIndex.isEmpty()) {
                        return;
                    }
                    long estimatedWaitInSeconds = 5L;
                    int i22 = 0;
                    while (true) {
                        if (i22 >= len) {
                            if (!this.pendingSurlsToIndex.isEmpty()) break;
                            logger.debug("no more pending transfers, breaking the loop");
                            Runtime.getRuntime().removeShutdownHook(this.hook);
                            return;
                        }
                        TGetRequestFileStatus getRequestFileStatus = getRequestFileStatuses[i22];
                        URI surl = getRequestFileStatus.getSourceSURL();
                        if (surl == null) {
                            logger.error("invalid getRequestFileStatus, surl is null");
                        } else {
                            String surl_string = surl.toString();
                            if (!this.pendingSurlsToIndex.containsKey(surl_string)) {
                                logger.error("invalid getRequestFileStatus, surl = " + surl_string + " not found");
                            } else {
                                int indx;
                                TReturnStatus fileStatus = getRequestFileStatus.getStatus();
                                if (fileStatus == null) {
                                    throw new IOException(" null file return status");
                                }
                                TStatusCode fileStatusCode = fileStatus.getStatusCode();
                                if (fileStatusCode == null) {
                                    throw new IOException(" null file status code");
                                }
                                if (RequestStatusTool.isFailedFileRequestStatus((TReturnStatus)fileStatus)) {
                                    String error2 = "retreval of surl " + surl_string + " failed, status = " + fileStatusCode + " explanation=" + fileStatus.getExplanation();
                                    logger.error(error2);
                                    indx = this.pendingSurlsToIndex.remove(surl_string);
                                    this.setReportFailed(this.from[indx], this.to[indx], error2);
                                } else if (getRequestFileStatus.getTransferURL() != null) {
                                    GlobusURL globusTURL = new GlobusURL(getRequestFileStatus.getTransferURL().toString());
                                    indx = this.pendingSurlsToIndex.remove(surl_string);
                                    this.setReportFailed(this.from[indx], this.to[indx], "received TURL, but did not complete transfer");
                                    EMI_SRMV2CopyJob job = new EMI_SRMV2CopyJob(globusTURL, this.to[indx], this.srmv2, this.requestToken, logger, this.from[indx], true, this);
                                    this.copier.addCopyJob(job);
                                } else if (getRequestFileStatus.getEstimatedWaitTime() != null && (long)getRequestFileStatus.getEstimatedWaitTime().intValue() < estimatedWaitInSeconds && getRequestFileStatus.getEstimatedWaitTime() >= 1) {
                                    estimatedWaitInSeconds = getRequestFileStatus.getEstimatedWaitTime().intValue();
                                }
                            }
                        }
                        ++i22;
                    }
                    if (estimatedWaitInSeconds > 60L) {
                        estimatedWaitInSeconds = 60L;
                    }
                    try {
                        logger.info("sleeping " + estimatedWaitInSeconds + " seconds ...");
                        Thread.sleep(estimatedWaitInSeconds * 1000L);
                    }
                    catch (InterruptedException i22) {
                        // empty catch block
                    }
                    SrmStatusOfGetRequestRequest srmStatusOfGetRequestRequest = new SrmStatusOfGetRequestRequest();
                    srmStatusOfGetRequestRequest.setRequestToken(this.requestToken);
                    String[] pendingSurlStrings = this.pendingSurlsToIndex.keySet().toArray(new String[0]);
                    expectedResponseLength = pendingSurlStrings.length;
                    URI[] surlArray = new URI[expectedResponseLength];
                    int i3 = 0;
                    while (true) {
                        if (i3 >= expectedResponseLength) {
                            srmStatusOfGetRequestRequest.setArrayOfSourceSURLs(new ArrayOfAnyURI(surlArray));
                            srmStatusOfGetRequestResponse = this.srmv2.srmStatusOfGetRequest(srmStatusOfGetRequestRequest);
                            if (srmStatusOfGetRequestResponse != null) break;
                            throw new IOException(" null srmStatusOfGetRequestResponse");
                        }
                        surlArray[i3] = new URI(pendingSurlStrings[i3]);
                        ++i3;
                    }
                    if (srmStatusOfGetRequestResponse.getArrayOfFileStatuses() == null) {
                        error = "array of RequestFileStatuses is null ";
                        statusCode = status.getStatusCode();
                        if (statusCode != null) {
                            error = String.valueOf(error) + " status : " + statusCode + " explanation=" + status.getExplanation();
                        }
                        logger.error(error);
                        throw new IOException(error);
                    }
                    getRequestFileStatuses = srmStatusOfGetRequestResponse.getArrayOfFileStatuses().getStatusArray();
                    if (getRequestFileStatuses == null || getRequestFileStatuses.length != expectedResponseLength) {
                        error = "incorrect number of RequestFileStatuses";
                        statusCode = status.getStatusCode();
                        if (statusCode != null) {
                            error = String.valueOf(error) + " status : " + statusCode + " explanation=" + status.getExplanation();
                        }
                        logger.error(error);
                        throw new IOException(error);
                    }
                    status = srmStatusOfGetRequestResponse.getReturnStatus();
                    if (status == null) {
                        throw new IOException(" null return status");
                    }
                    statusCode = status.getStatusCode();
                    if (statusCode != null) continue;
                    throw new IOException(" null status code");
                } while (!RequestStatusTool.isFailedRequestStatus((TReturnStatus)status));
                error = "srmPrepareToGet update failed, status : " + statusCode + " explanation=" + status.getExplanation();
                logger.error(error);
                int i4 = 0;
                while (true) {
                    if (i4 >= expectedResponseLength) {
                        throw new IOException(error);
                    }
                    TReturnStatus frstatus = getRequestFileStatuses[i4].getStatus();
                    if (frstatus != null) {
                        logger.error("GetFileRequest[" + getRequestFileStatuses[i4].getSourceSURL() + "] status=" + frstatus.getStatusCode() + " explanation=" + frstatus.getExplanation());
                        if (!RequestStatusTool.isTransientStateStatus((TReturnStatus)frstatus)) {
                            this.pendingSurlsToIndex.remove(getRequestFileStatuses[i4].getSourceSURL().toString());
                        }
                    }
                    ++i4;
                }
            }
            catch (Exception e) {
                logger.info(e.toString());
                try {
                    if (this.copier != null) {
                        logger.info("stopping copier");
                        this.copier.stop();
                        this.abortAllPendingFiles();
                    }
                }
                catch (Exception e1) {
                    logger.error(e1.toString());
                }
                if (this.copier != null) {
                    this.copier.doneAddingJobs();
                    try {
                        this.copier.waitCompletion();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                this.report.dumpReport();
                if (this.report.everythingAllRight()) return;
                logger.error("srm copy of at least one file failed or not completed");
                this.copier.stop();
                return;
            }
        }
        finally {
            if (this.copier != null) {
                this.copier.doneAddingJobs();
                try {
                    this.copier.waitCompletion();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.report.dumpReport();
            if (!this.report.everythingAllRight()) {
                logger.error("srm copy of at least one file failed or not completed");
                this.copier.stop();
            }
        }
    }

    private void abortAllPendingFiles() throws Exception {
        logger.info("abortAllPendingFiles()");
        if (this.pendingSurlsToIndex.isEmpty()) {
            return;
        }
        if (this.requestToken != null) {
            String[] surl_strings = this.pendingSurlsToIndex.keySet().toArray(new String[0]);
            int len = surl_strings.length;
            logger.info("Releasing all remaining file requests");
            URI[] surlArray = new URI[len];
            int i = 0;
            while (i < len) {
                surlArray[i] = new URI(surl_strings[i]);
                ++i;
            }
            SrmAbortFilesRequest srmAbortFilesRequest = new SrmAbortFilesRequest();
            srmAbortFilesRequest.setRequestToken(this.requestToken);
            srmAbortFilesRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
            SrmAbortFilesResponse srmAbortFilesResponse = this.srmv2.srmAbortFiles(srmAbortFilesRequest);
            if (srmAbortFilesResponse == null) {
                logger.error(" srmAbortFilesResponse is null");
            } else {
                TReturnStatus returnStatus = srmAbortFilesResponse.getReturnStatus();
                if (returnStatus == null) {
                    logger.error("srmAbortFiles return status is null");
                    return;
                }
                logger.info("srmAbortFiles status code=" + returnStatus.getStatusCode());
            }
        }
    }
}

