/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.data;

import eu.unicore.emi.data.EMI_Configuration;
import eu.unicore.emi.data.EMI_SRMClient;
import gov.fnal.srm.util.Report;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis.types.URI;
import org.dcache.srm.client.SRMClientV2;
import org.dcache.srm.request.AccessLatency;
import org.dcache.srm.request.FileStorageType;
import org.dcache.srm.request.OverwriteMode;
import org.dcache.srm.request.RetentionPolicy;
import org.dcache.srm.util.RequestStatusTool;
import org.dcache.srm.v2_2.ArrayOfAnyURI;
import org.dcache.srm.v2_2.ArrayOfTCopyFileRequest;
import org.dcache.srm.v2_2.ArrayOfTExtraInfo;
import org.dcache.srm.v2_2.ISRM;
import org.dcache.srm.v2_2.SrmAbortFilesRequest;
import org.dcache.srm.v2_2.SrmAbortFilesResponse;
import org.dcache.srm.v2_2.SrmCopyRequest;
import org.dcache.srm.v2_2.SrmCopyResponse;
import org.dcache.srm.v2_2.SrmStatusOfCopyRequestRequest;
import org.dcache.srm.v2_2.SrmStatusOfCopyRequestResponse;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TCopyFileRequest;
import org.dcache.srm.v2_2.TCopyRequestFileStatus;
import org.dcache.srm.v2_2.TDirOption;
import org.dcache.srm.v2_2.TExtraInfo;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMI_SRMCopyClientV2
extends EMI_SRMClient
implements Runnable {
    private GlobusURL[] from;
    private GlobusURL[] to;
    private SrmCopyRequest req = new SrmCopyRequest();
    private GSSCredential cred = null;
    private ISRM srmv2;
    private Thread hook;
    private HashMap<String, Integer> pendingSurlsMap = new HashMap();
    private String requestToken;
    private static final Logger logger = LoggerFactory.getLogger(EMI_SRMCopyClientV2.class);

    public EMI_SRMCopyClientV2(EMI_Configuration configuration, GlobusURL[] from, GlobusURL[] to) {
        super(configuration);
        this.report = new Report(from, to, configuration.getReport());
        this.from = from;
        this.to = to;
        try {
            this.cred = this.getGssCredential();
        }
        catch (Exception e) {
            this.cred = null;
            logger.error("Couldn't getGssCredential.");
        }
    }

    @Override
    public void connect() throws Exception {
        GlobusURL srmUrl = null;
        srmUrl = this.configuration.isPushmode() ? this.from[0] : this.to[0];
        this.srmv2 = new SRMClientV2(srmUrl, this.getGssCredential(), this.configuration.getRetry_timeout(), this.configuration.getRetry_num(), this.doDelegation, this.fullDelegation, this.gss_expected_name, this.configuration.getWebservice_path(), this.configuration.getTransport());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void start() throws Exception {
        if (this.cred.getRemainingLifetime() < 60) {
            throw new Exception("Remaining lifetime of credential is less than a minute.");
        }
        try {
            try {
                TStatusCode statusCode;
                int expectedResponseLength;
                String error;
                TReturnStatus status;
                SrmCopyResponse resp;
                TAccessLatency accessLatency;
                int len = this.from.length;
                TCopyFileRequest[] copyFileRequests = new TCopyFileRequest[len];
                int i = 0;
                while (true) {
                    if (i >= this.from.length) {
                        this.hook = new Thread(this);
                        Runtime.getRuntime().addShutdownHook(this.hook);
                        String storagetype = this.configuration.getStorageType();
                        if (storagetype != null) {
                            this.req.setTargetFileStorageType(FileStorageType.fromString((String)storagetype.toUpperCase()).toTFileStorageType());
                        }
                        this.req.setDesiredTotalRequestTime(new Integer((int)this.configuration.getRequestLifetime()));
                    }
                    GlobusURL source = this.from[i];
                    GlobusURL dest = this.to[i];
                    TCopyFileRequest copyFileRequest = new TCopyFileRequest();
                    copyFileRequest.setSourceSURL(new URI(source.getURL()));
                    copyFileRequest.setTargetSURL(new URI(dest.getURL()));
                    TDirOption dirOption = new TDirOption();
                    dirOption.setIsSourceADirectory(false);
                    dirOption.setAllLevelRecursive(Boolean.TRUE);
                    copyFileRequest.setDirOption(dirOption);
                    copyFileRequests[i] = copyFileRequest;
                    this.pendingSurlsMap.put(this.from[i].getURL(), new Integer(i));
                    ++i;
                }
                TRetentionPolicy retentionPolicy = this.configuration.getRetentionPolicy() != null ? RetentionPolicy.fromString((String)this.configuration.getRetentionPolicy()).toTRetentionPolicy() : null;
                TAccessLatency tAccessLatency = accessLatency = this.configuration.getAccessLatency() != null ? AccessLatency.fromString((String)this.configuration.getAccessLatency()).toTAccessLatency() : null;
                if (accessLatency != null && retentionPolicy == null) {
                    throw new IllegalArgumentException("if access latency is specified, then retention policy have to be specified as well");
                }
                if (retentionPolicy != null) {
                    TRetentionPolicyInfo retentionPolicyInfo = new TRetentionPolicyInfo(retentionPolicy, accessLatency);
                    this.req.setTargetFileRetentionPolicyInfo(retentionPolicyInfo);
                }
                if (this.configuration.getOverwriteMode() != null) {
                    this.req.setOverwriteOption(OverwriteMode.fromString((String)this.configuration.getOverwriteMode()).toTOverwriteMode());
                }
                this.req.setArrayOfFileRequests(new ArrayOfTCopyFileRequest(copyFileRequests));
                this.req.setUserRequestDescription("This is User request description");
                if (this.configuration.getSpaceToken() != null) {
                    this.req.setTargetSpaceToken(this.configuration.getSpaceToken());
                }
                if (this.configuration.getExtraParameters().size() > 0) {
                    TExtraInfo[] extraInfoArray = new TExtraInfo[this.configuration.getExtraParameters().size()];
                    int counter = 0;
                    Map<String, String> extraParameters = this.configuration.getExtraParameters();
                    Iterator<String> i2 = extraParameters.keySet().iterator();
                    while (true) {
                        if (!i2.hasNext()) {
                            ArrayOfTExtraInfo arrayOfExtraInfo = new ArrayOfTExtraInfo(extraInfoArray);
                            this.req.setSourceStorageSystemInfo(arrayOfExtraInfo);
                            break;
                        }
                        String key = i2.next();
                        String value = extraParameters.get(key);
                        extraInfoArray[counter++] = new TExtraInfo(key, value);
                    }
                }
                if ((resp = this.srmv2.srmCopy(this.req)) == null) {
                    throw new IOException(" null SrmCopyResponse");
                }
                TReturnStatus rs = resp.getReturnStatus();
                this.requestToken = resp.getRequestToken();
                logger.debug(" srm returned requestToken = " + this.requestToken);
                if (rs == null) {
                    throw new IOException(" null TReturnStatus ");
                }
                if (RequestStatusTool.isFailedRequestStatus((TReturnStatus)rs)) {
                    throw new IOException("srmCopy submission failed, unexpected or failed return status : " + rs.getStatusCode() + " explanation=" + rs.getExplanation());
                }
                if (resp.getArrayOfFileStatuses() == null) {
                    throw new IOException("srmCopy submission failed, arrayOfFileStatuses is null, status code :" + rs.getStatusCode() + " explanation=" + rs.getExplanation());
                }
                TCopyRequestFileStatus[] arrayOfStatuses = resp.getArrayOfFileStatuses().getStatusArray();
                if (arrayOfStatuses.length != len) {
                    throw new IOException("number of SrmCopyRequestFileStatuses is SrmRequestStatus is different from exopected " + len + " received " + arrayOfStatuses.length);
                }
                do {
                    SrmStatusOfCopyRequestResponse copyStatusRequestResponse;
                    if (this.pendingSurlsMap.isEmpty()) {
                        return;
                    }
                    long estimatedWaitInSeconds = 5L;
                    int i22 = 0;
                    while (true) {
                        if (i22 >= arrayOfStatuses.length) {
                            if (!this.pendingSurlsMap.isEmpty()) break;
                            logger.debug("no more pending transfers, breaking the loop");
                            Runtime.getRuntime().removeShutdownHook(this.hook);
                            return;
                        }
                        TCopyRequestFileStatus copyRequestFileStatus = arrayOfStatuses[i22];
                        if (copyRequestFileStatus == null) {
                            throw new IOException(" null file status code");
                        }
                        TReturnStatus fileStatus = copyRequestFileStatus.getStatus();
                        if (fileStatus == null) {
                            throw new IOException(" null file return status");
                        }
                        TStatusCode fileStatusCode = fileStatus.getStatusCode();
                        if (fileStatusCode == null) {
                            throw new IOException(" null file status code");
                        }
                        URI from_surl = copyRequestFileStatus.getSourceSURL();
                        URI to_surl = copyRequestFileStatus.getTargetSURL();
                        if (from_surl == null) {
                            throw new IOException("null from_surl");
                        }
                        if (to_surl == null) {
                            throw new IOException("null to_surl");
                        }
                        String from_surl_string = from_surl.toString();
                        String to_surl_string = to_surl.toString();
                        if (RequestStatusTool.isFailedFileRequestStatus((TReturnStatus)fileStatus)) {
                            error = "copy of " + from_surl_string + " into " + to_surl + " failed, status = " + fileStatusCode + " explanation=" + fileStatus.getExplanation();
                            logger.error(error);
                            int indx = this.pendingSurlsMap.remove(from_surl_string);
                            this.setReportFailed(this.from[indx], this.to[indx], error);
                        } else if (fileStatusCode == TStatusCode.SRM_SUCCESS || fileStatusCode == TStatusCode.SRM_DONE) {
                            int indx = this.pendingSurlsMap.remove(from_surl_string);
                            logger.info(" copying of " + from_surl_string + " to " + to_surl_string + " succeeded");
                            this.setReportSucceeded(this.from[indx], this.to[indx]);
                        }
                        if (copyRequestFileStatus.getEstimatedWaitTime() != null && (long)copyRequestFileStatus.getEstimatedWaitTime().intValue() < estimatedWaitInSeconds && copyRequestFileStatus.getEstimatedWaitTime() >= 1) {
                            estimatedWaitInSeconds = copyRequestFileStatus.getEstimatedWaitTime().intValue();
                        }
                        ++i22;
                    }
                    if (estimatedWaitInSeconds > 60L) {
                        estimatedWaitInSeconds = 60L;
                    }
                    try {
                        logger.info("sleeping " + estimatedWaitInSeconds + " seconds ...");
                        Thread.sleep(estimatedWaitInSeconds * 1000L);
                    }
                    catch (InterruptedException i22) {
                        // empty catch block
                    }
                    SrmStatusOfCopyRequestRequest request = new SrmStatusOfCopyRequestRequest();
                    request.setRequestToken(this.requestToken);
                    request.setAuthorizationID(this.req.getAuthorizationID());
                    expectedResponseLength = this.pendingSurlsMap.size();
                    URI[] surlArrayOfFromSURLs = new URI[expectedResponseLength];
                    URI[] surlArrayOfToSURLs = new URI[expectedResponseLength];
                    Iterator<Integer> it = this.pendingSurlsMap.values().iterator();
                    int i3 = 0;
                    while (true) {
                        if (!it.hasNext()) {
                            request.setArrayOfSourceSURLs(new ArrayOfAnyURI(surlArrayOfFromSURLs));
                            request.setArrayOfTargetSURLs(new ArrayOfAnyURI(surlArrayOfToSURLs));
                            copyStatusRequestResponse = this.srmv2.srmStatusOfCopyRequest(request);
                            if (copyStatusRequestResponse != null) break;
                            throw new IOException(" null copyStatusRequestResponse");
                        }
                        int indx = it.next();
                        TCopyFileRequest copyFileRequest = copyFileRequests[indx];
                        surlArrayOfFromSURLs[i3] = copyFileRequest.getSourceSURL();
                        surlArrayOfToSURLs[i3] = copyFileRequest.getTargetSURL();
                        ++i3;
                    }
                    if (copyStatusRequestResponse.getArrayOfFileStatuses() == null) {
                        throw new IOException("null SrmStatusOfCopyRequestResponse.getArrayOfFileStatuses()");
                    }
                    arrayOfStatuses = copyStatusRequestResponse.getArrayOfFileStatuses().getStatusArray();
                    if (arrayOfStatuses.length != this.pendingSurlsMap.size()) {
                        logger.error("incorrect number of arrayOfStatuses in SrmStatusOfCopyRequestResponse expected " + expectedResponseLength + " received " + arrayOfStatuses.length);
                    }
                    if ((status = copyStatusRequestResponse.getReturnStatus()) == null) {
                        throw new IOException(" null return status");
                    }
                    statusCode = status.getStatusCode();
                    if (statusCode != null) continue;
                    throw new IOException(" null status code");
                } while (!RequestStatusTool.isFailedRequestStatus((TReturnStatus)status));
                error = "srmCopy update failed, status : " + statusCode + " explanation=" + status.getExplanation();
                logger.error(error);
                int i4 = 0;
                while (true) {
                    if (i4 >= expectedResponseLength) {
                        throw new IOException(error);
                    }
                    TReturnStatus frstatus = arrayOfStatuses[i4].getStatus();
                    if (frstatus != null) {
                        logger.error("copyFileRequest[" + arrayOfStatuses[i4].getSourceSURL() + " , " + arrayOfStatuses[i4].getTargetSURL() + "] status=" + frstatus.getStatusCode() + " explanation=" + frstatus.getExplanation());
                        if (!RequestStatusTool.isTransientStateStatus((TReturnStatus)frstatus)) {
                            this.pendingSurlsMap.remove(arrayOfStatuses[i4].getSourceSURL().toString());
                        }
                    }
                    ++i4;
                }
            }
            catch (Exception e) {
                try {
                    this.abortAllPendingFiles();
                    throw e;
                }
                catch (Exception e1) {
                    logger.error(e1.toString());
                }
                throw e;
            }
        }
        finally {
            this.report.dumpReport();
            if (!this.report.everythingAllRight()) {
                logger.error("srm copy of at least one file failed or not completed");
            }
        }
    }

    @Override
    public void run() {
        try {
            logger.debug("stopping ");
            this.abortAllPendingFiles();
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }

    private void abortAllPendingFiles() throws Exception {
        if (this.pendingSurlsMap.isEmpty()) {
            return;
        }
        if (this.requestToken == null) {
            return;
        }
        String[] surl_strings = this.pendingSurlsMap.keySet().toArray(new String[0]);
        int len = surl_strings.length;
        logger.info("Releasing all remaining file requests");
        URI[] surlArray = new URI[len];
        int i = 0;
        while (i < len) {
            URI uri;
            surlArray[i] = uri = new URI(surl_strings[i]);
            ++i;
        }
        SrmAbortFilesRequest srmAbortFilesRequest = new SrmAbortFilesRequest();
        srmAbortFilesRequest.setRequestToken(this.requestToken);
        srmAbortFilesRequest.setArrayOfSURLs(new ArrayOfAnyURI(surlArray));
        SrmAbortFilesResponse srmAbortFilesResponse = this.srmv2.srmAbortFiles(srmAbortFilesRequest);
        if (srmAbortFilesResponse == null) {
            logger.error(" srmAbortFilesResponse is null");
        } else {
            TReturnStatus returnStatus = srmAbortFilesResponse.getReturnStatus();
            if (returnStatus == null) {
                logger.error("srmAbortFiles return status is null");
                return;
            }
            logger.info("srmAbortFiles status code=" + returnStatus.getStatusCode());
        }
    }
}

