/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.Adler32;
import org.globus.ftp.Buffer;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.HostPort;
import org.globus.ftp.Options;
import org.globus.ftp.RetrieveOptions;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.FTPReplyParseException;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.exception.UnexpectedReplyCodeException;
import org.globus.ftp.vanilla.Reply;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMI_GridftpClient {
    private static final Logger logger = LoggerFactory.getLogger(EMI_GridftpClient.class);
    private static final int FirstByteTimeout = 3600;
    private static final int NextByteTimeout = 600;
    private final GridFTPClient _client;
    private final String _host;
    private String _cksmType;
    private String _cksmValue;
    private int _streamsNum = 1;
    private int _tcpBufferSize = 0x100000;
    private int _bufferSize = 0x100000;
    private volatile IDiskDataSourceSink _current_source_sink;
    private long _last_transfer_time = System.currentTimeMillis();
    private long _transferred = 0L;
    private boolean _closed = false;
    private static List<String> cksmTypeList = Arrays.asList("ADLER32", "MD5", "MD4");
    private static final char[] __map = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public EMI_GridftpClient(String host, int port, int tcpBufferSize, GSSCredential cred) throws IOException, ServerException, ClientException, GlobusCredentialException, GSSException {
        this(host, port, tcpBufferSize, 0, cred);
    }

    public EMI_GridftpClient(String host, int port, int tcpBufferSize, int bufferSize, GSSCredential cred) throws IOException, ServerException, ClientException, GlobusCredentialException, GSSException {
        if (bufferSize > 0) {
            this._bufferSize = bufferSize;
            logger.debug("memory buffer size is set to " + bufferSize);
        }
        if (tcpBufferSize > 0) {
            this._tcpBufferSize = tcpBufferSize;
            logger.debug("tcp buffer size is set to " + tcpBufferSize);
        }
        if (cred == null) {
            GlobusCredential gcred = GlobusCredential.getDefaultCredential();
            cred = new GlobusGSSCredentialImpl(gcred, 1);
        }
        this._host = host;
        logger.debug("connecting to " + this._host + " on port " + port);
        this._client = new GridFTPClient(this._host, port);
        this._client.setLocalTCPBufferSize(this._tcpBufferSize);
        logger.debug("gridFTPClient tcp buffer size is set to " + this._tcpBufferSize);
        this._client.authenticate(cred);
        this._client.setType(1);
    }

    public long getLastTransferTime() {
        IDiskDataSourceSink source_sink = this._current_source_sink;
        if (source_sink != null) {
            this._last_transfer_time = source_sink.getLast_transfer_time();
        }
        return this._last_transfer_time;
    }

    public long getTransfered() {
        IDiskDataSourceSink source_sink = this._current_source_sink;
        if (source_sink != null) {
            this._transferred = source_sink.getTransfered();
        }
        return this._transferred;
    }

    public static long getAdler32(RandomAccessFile diskFile) throws IOException {
        int rc;
        Adler32 java_addler = new Adler32();
        diskFile.seek(0L);
        byte[] buffer = new byte[4096];
        long sum = 0L;
        while ((rc = diskFile.read(buffer, 0, buffer.length)) > 0) {
            sum += (long)rc;
            java_addler.update(buffer, 0, rc);
        }
        return java_addler.getValue();
    }

    public static String getCksmValue(RandomAccessFile diskFile, String type) throws IOException, NoSuchAlgorithmException {
        int rc;
        if (type.equalsIgnoreCase("adler32")) {
            return EMI_GridftpClient.long32bitToHexString(EMI_GridftpClient.getAdler32(diskFile));
        }
        MessageDigest md = MessageDigest.getInstance(type);
        diskFile.seek(0L);
        byte[] buffer = new byte[4096];
        long sum = 0L;
        while ((rc = diskFile.read(buffer, 0, buffer.length)) > 0) {
            sum += (long)rc;
            md.update(buffer, 0, rc);
        }
        return EMI_GridftpClient.printbytes(md.digest());
    }

    public String list(String directory, boolean serverPassive) throws IOException, ClientException, ServerException {
        logger.debug("list(" + directory + ")");
        this.setCommonOptions(false, serverPassive);
        this._client.changeDir(directory);
        if (serverPassive) {
            this._client.setPassive();
            this._client.setLocalActive();
        } else {
            this._client.setLocalPassive();
            this._client.setActive();
        }
        final ByteArrayOutputStream received = new ByteArrayOutputStream(1000);
        DataSink sink = new DataSink(){

            public void write(Buffer buffer) throws IOException {
                received.write(buffer.getBuffer(), 0, buffer.getLength());
            }

            public void close() throws IOException {
            }
        };
        this._client.list(" ", " ", sink);
        return received.toString();
    }

    public long getSize(String ftppath) throws IOException, ServerException {
        return this._client.getSize(ftppath);
    }

    private void setCommonOptions(boolean emode, boolean passive_server_mode) throws IOException, ClientException, ServerException {
        logger.debug("setCommonOptions(emode=" + emode + ", pasv=" + passive_server_mode + ")");
        if (this._client.isFeatureSupported("DCAU")) {
            this._client.setDataChannelAuthentication(DataChannelAuthentication.NONE);
        }
        logger.debug("set local data channel authentication mode to None");
        this._client.setLocalNoDataChannelAuthentication();
        if (emode) {
            this._client.setMode(3);
            logger.debug("parallelism: " + this._streamsNum);
            this._client.setOptions((Options)new RetrieveOptions(this._streamsNum));
        } else {
            this._client.setMode(1);
            logger.debug("stream mode transfer");
            if (!this._client.isFeatureSupported("GETPUT")) {
                if (passive_server_mode) {
                    logger.debug("server is passive");
                    HostPort serverHostPort = this._client.setPassive();
                    logger.debug("serverHostPort=" + serverHostPort.getHost() + ":" + serverHostPort.getPort());
                    this._client.setLocalActive();
                } else {
                    logger.debug("server is active");
                    this._client.setLocalPassive();
                    this._client.setActive();
                }
            }
        }
        this._client.setClientWaitParams(Integer.MAX_VALUE, 1000);
    }

    private void sendNCSAWaitCommand() throws IOException, ServerException, FTPReplyParseException, UnexpectedReplyCodeException {
        logger.debug(" sending wait command to ncsa host " + this._host);
        Reply reply = this._client.quote("SITE WAIT");
        logger.debug("Reply is " + reply);
        if (Reply.isPositiveCompletion((Reply)reply)) {
            logger.debug("sending wait command successful");
        } else {
            logger.error("WARNING: sending wait command failed");
        }
    }

    public void setChecksum(String cksmType, String cksmValue) {
        this._cksmType = cksmType;
        this._cksmValue = cksmValue;
    }

    public String getChecksumValue() {
        return this._cksmValue;
    }

    public String getChecksumType() {
        return this._cksmType;
    }

    public void gridFTPRead(String sourcepath, DataSink sink, boolean emode, boolean passive_server_mode) throws IOException, ClientException, ServerException, FTPReplyParseException, UnexpectedReplyCodeException, InterruptedException, NoSuchAlgorithmException {
        this.setCommonOptions(emode, passive_server_mode);
        if (this._host.toLowerCase().indexOf("ncsa") != -1) {
            this.sendNCSAWaitCommand();
        }
        TransferThread getter = new TransferThread(this._client, sourcepath, sink);
        getter.start();
        getter.waitCompletion(3600, 600);
        this.getTransfered();
        this.getLastTransferTime();
        this._current_source_sink = null;
    }

    public void gridFTPWrite(DataSource source, String destinationpath, boolean emode, boolean use_chksum, boolean passive_server_mode) throws InterruptedException, ClientException, ServerException, IOException, NoSuchAlgorithmException {
        logger.debug("gridFTPWrite started, destination path is " + destinationpath);
        this.setCommonOptions(emode, passive_server_mode);
        TransferThread putter = new TransferThread(this._client, destinationpath, source);
        putter.start();
        putter.waitCompletion(3600, 600);
    }

    public String getCommonChecksumAlgorithm() throws IOException, ClientException, ServerException {
        return null;
    }

    public Checksum negotiateCksm(String path) throws IOException, ServerException, ClientException, ChecksumNotSupported, ChecksumValueFormatException {
        throw new ChecksumNotSupported("", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, ServerException {
        EMI_GridftpClient eMI_GridftpClient = this;
        synchronized (eMI_GridftpClient) {
            if (this._closed) {
                return;
            }
        }
        try {
            this._client.abort();
            this._client.close(false);
            eMI_GridftpClient = this;
            synchronized (eMI_GridftpClient) {
                this._closed = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.debug("closed client");
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getStreamsNum() {
        return this._streamsNum;
    }

    public void setStreamsNum(int streamsNum) {
        this._streamsNum = streamsNum;
    }

    public int getTcpBufferSize() {
        return this._tcpBufferSize;
    }

    public void setTcpBufferSize(int tcpBufferSize) throws ClientException {
        if (tcpBufferSize > 0) {
            this._tcpBufferSize = tcpBufferSize;
            this._client.setLocalTCPBufferSize(tcpBufferSize);
        }
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public static void setSupportedChecksumTypes(String[] types) {
        cksmTypeList = new ArrayList<String>();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String algorithm = stringArray[n2];
            cksmTypeList.add(algorithm.toUpperCase());
            ++n2;
        }
    }

    public static String long32bitToHexString(long value) {
        value |= 0x100000000L;
        String svalue = Long.toHexString(value &= 0x1FFFFFFFFL);
        if ((svalue = svalue.substring(1)).length() != 8) {
            throw new IllegalStateException("32 bit integer hext string  length is not 8 bytes");
        }
        return svalue;
    }

    public static String printbytes(byte[] bs) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bs.length) {
            EMI_GridftpClient.byteToHexString(bs[i], sb);
            ++i;
        }
        return sb.toString();
    }

    private static void byteToHexString(byte b, StringBuilder sb) {
        int x = b < 0 ? 256 + b : b;
        sb.append(__map[b >> 4 & 0xF]);
        sb.append(__map[b & 0xF]);
    }

    public static class Checksum {
        public String type;
        public String value;

        public Checksum(String type, String value) {
            this.type = type;
            this.value = value;
        }
    }

    public static class ChecksumNotSupported
    extends Exception {
        private int code;

        public ChecksumNotSupported(String msg, int code) {
            super(msg);
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static class ChecksumValueFormatException
    extends Exception {
        public ChecksumValueFormatException(String msg) {
            super(msg);
        }
    }

    public static interface IDiskDataSourceSink
    extends DataSink,
    DataSource {
        public long getAdler32() throws IOException;

        public String getCksmValue(String var1) throws IOException, NoSuchAlgorithmException;

        public long getLast_transfer_time();

        public long getTransfered();

        public long length() throws IOException;
    }

    private class TransferThread
    implements Runnable {
        private boolean _done = false;
        private final GridFTPClient _client;
        private Exception _throwable;
        private final String _path;
        private final DataSink _sink;
        private final DataSource _source;
        private Thread _runner;

        public TransferThread(GridFTPClient client, String path, DataSink sink) {
            this._client = client;
            this._path = path;
            this._sink = sink;
            this._source = null;
        }

        public TransferThread(GridFTPClient client, String path, DataSource source) {
            this._client = client;
            this._path = path;
            this._sink = null;
            this._source = source;
        }

        public void start() {
            this._runner = new Thread(this);
            this._runner.start();
        }

        public void waitCompletion(int FirstByteTimeout, int NextByteTimeout) throws InterruptedException, ClientException, ServerException, IOException {
            long timeout = (long)FirstByteTimeout * 1000L;
            logger.debug("waiting for completion of transfer");
            boolean timedout = false;
            boolean interrupted = false;
            int cnt = 20;
            try {
                while (true) {
                    this.waitCompleteion(timeout);
                    if (!this.isDone() && --cnt > 0) {
                        timeout = (long)NextByteTimeout * 1000L;
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ie) {
                this._runner.interrupt();
                interrupted = true;
            }
            if (timedout || interrupted) {
                this._runner.interrupt();
                String error = "transfer timedout or interrupted";
                logger.error(error);
                throw new InterruptedException(error);
            }
            if (this.getThrowable() != null) {
                Exception e = this.getThrowable();
                logger.error(" transfer exception", (Throwable)e);
                if (e instanceof ClientException) {
                    throw (ClientException)e;
                }
                if (e instanceof ServerException) {
                    throw (ServerException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException("Unexpected exception", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitCompleteion(long timeout) throws InterruptedException {
            TransferThread transferThread = this;
            synchronized (transferThread) {
                this.wait(timeout);
            }
        }

        public synchronized void done() {
            this._done = true;
            this.notifyAll();
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            block11: {
                try {
                    try {
                        if (this._sink != null) {
                            logger.debug("starting a transfer from " + this._path);
                            this._client.setPassiveMode(true);
                            this._client.get(this._path, this._sink, null);
                        } else {
                            logger.debug("starting a transfer to " + this._path);
                            this._client.put(this._path, this._source, null);
                        }
                    }
                    catch (IOException e) {
                        logger.error(e.toString());
                        this._throwable = e;
                        this.done();
                    }
                    catch (ServerException e) {
                        logger.error(e.toString());
                        this._throwable = e;
                        this.done();
                    }
                    catch (ClientException e) {
                        logger.error(e.toString());
                        this._throwable = e;
                        this.done();
                        break block11;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                }
                finally {
                    this.done();
                }
            }
        }

        public synchronized boolean isDone() {
            return this._done;
        }

        public Exception getThrowable() {
            return this._throwable;
        }
    }
}

