/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.data;

import eu.unicore.emi.data.EMI_Configuration;
import eu.unicore.emi.data.EMI_GridftpClient;
import gov.fnal.srm.util.CopyJob;
import gov.fnal.srm.util.SRMDispatcher;
import gov.fnal.srm.util.ShellCommandExecuter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import org.dcache.srm.security.SslGsiSocketFactory;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.InputStreamDataSink;
import org.globus.ftp.OutputStreamDataSource;
import org.globus.ftp.exception.ServerException;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMI_Copier
implements Runnable {
    private final HashSet<CopyJob> copy_jobs = new HashSet();
    private boolean doneAddingJobs;
    private boolean stop;
    private Thread hook;
    private String urlcopy;
    private boolean debug = false;
    private EMI_Configuration configuration;
    private boolean completed;
    private boolean completed_successfully = true;
    private Exception error;
    private long retry_timeout;
    private int retry_num;
    private int num_jobs = 0;
    private int num_completed_successfully = 0;
    private boolean dryRun;
    private InputStreamDataSink dataSink;
    private OutputStreamDataSource dataSource;
    private EMI_GridftpClient client;
    private static final Logger logger = LoggerFactory.getLogger(EMI_Copier.class);

    public EMI_Copier(String urlcopy, EMI_Configuration configuration, InputStreamDataSink dataSink) {
        this(urlcopy, configuration, dataSink, null);
    }

    public EMI_Copier(String urlcopy, EMI_Configuration configuration, OutputStreamDataSource dataSource) {
        this(urlcopy, configuration, null, dataSource);
    }

    private EMI_Copier(String urlcopy, EMI_Configuration configuration, InputStreamDataSink dataSink, OutputStreamDataSource dataSource) {
        this.urlcopy = urlcopy;
        this.configuration = configuration;
        this.retry_num = configuration.getRetry_num();
        this.retry_timeout = configuration.getRetry_timeout();
        this.dryRun = configuration.isDryRun();
        this.dataSink = dataSink;
        this.dataSource = dataSource;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCopyJob(CopyJob job) {
        Object object = this.copy_jobs;
        synchronized (object) {
            this.copy_jobs.add(job);
            ++this.num_jobs;
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneAddingJobs() {
        Object object = this.copy_jobs;
        synchronized (object) {
            this.doneAddingJobs = true;
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    public synchronized void waitCompletion() throws Exception {
        if (this.completed) {
            if (!this.completed_successfully) {
                throw this.error;
            }
            if (this.num_completed_successfully != this.num_jobs) {
                throw new Exception("number of jobs = " + this.num_jobs + " successfully completed=" + this.num_completed_successfully);
            }
            return;
        }
        while (true) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                logger.error("waitCompletion is interrupted");
                this.notifyAll();
                throw ie;
            }
            if (this.completed) {
                if (!this.completed_successfully) {
                    throw this.error;
                }
                if (this.num_completed_successfully != this.num_jobs) {
                    throw new Exception("number of jobs = " + this.num_jobs + " successfully completed=" + this.num_completed_successfully);
                }
                return;
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        EMI_Copier eMI_Copier = this;
        synchronized (eMI_Copier) {
            this.stop = true;
            this.notifyAll();
        }
        while (true) {
            if (this.copy_jobs.isEmpty()) {
                try {
                    this.client.close();
                }
                catch (ServerException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            CopyJob nextJob = this.copy_jobs.iterator().next();
            this.copy_jobs.remove(nextJob);
            nextJob.done(false, "stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        EMI_Copier eMI_Copier;
        if (Thread.currentThread() == this.hook) {
            this.cleanup();
            return;
        }
        this.hook = new Thread(this);
        Runtime.getRuntime().addShutdownHook(this.hook);
        while (true) {
            eMI_Copier = this;
            synchronized (eMI_Copier) {
                if (this.stop) {
                    logger.debug("going to stop....");
                    this.completed = true;
                    this.completed_successfully = false;
                    this.error = new Exception(" stopped ");
                    this.notifyAll();
                    return;
                }
            }
            CopyJob nextJob = null;
            Object object = this.copy_jobs;
            synchronized (object) {
                if (this.copy_jobs.isEmpty()) {
                    logger.debug("copy_jobs is empty");
                } else {
                    logger.debug("copy_jobs is not empty");
                }
                if (this.doneAddingJobs && this.copy_jobs.isEmpty()) {
                    logger.debug("stopping copier");
                    Runtime.getRuntime().removeShutdownHook(this.hook);
                    break;
                }
                if (!this.copy_jobs.isEmpty()) {
                    nextJob = this.copy_jobs.iterator().next();
                }
            }
            if (nextJob != null) {
                boolean job_success = false;
                Throwable job_error = null;
                try {
                    int i = 0;
                    while (true) {
                        try {
                            this.copy(nextJob);
                            job_success = true;
                            logger.debug("execution of " + nextJob + " completed");
                        }
                        catch (Exception e1) {
                            logger.error("copy failed with the error", (Throwable)e1);
                            if (i < this.retry_num) {
                                ++i;
                            } else {
                                throw e1;
                            }
                            logger.error(" try again");
                            try {
                                logger.error("sleeping for " + this.retry_timeout * (long)i + " before retrying");
                                Thread.sleep(this.retry_timeout * (long)i);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    EMI_Copier eMI_Copier2 = this;
                    synchronized (eMI_Copier2) {
                        job_error = e;
                        this.completed = true;
                        this.completed_successfully = false;
                        this.error = e;
                        this.notifyAll();
                    }
                    try {
                        nextJob.done(job_success, job_error == null ? null : job_error.getMessage());
                    }
                    catch (Exception e2) {
                        logger.error("setting File Request to \"Done\" failed", (Throwable)e2);
                        if (this.doneAddingJobs && this.copy_jobs.isEmpty()) break;
                        EMI_Copier eMI_Copier3 = this;
                        synchronized (eMI_Copier3) {
                            this.completed = true;
                            this.completed_successfully = false;
                            this.error = e2;
                            this.notifyAll();
                        }
                        return;
                    }
                    return;
                    {
                        catch (Throwable throwable) {
                            try {
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    nextJob.done(job_success, job_error == null ? null : job_error.getMessage());
                                }
                                catch (Exception e3) {
                                    logger.error("setting File Request to \"Done\" failed", (Throwable)e3);
                                    if (this.doneAddingJobs && this.copy_jobs.isEmpty()) break;
                                    EMI_Copier eMI_Copier4 = this;
                                    synchronized (eMI_Copier4) {
                                        this.completed = true;
                                        this.completed_successfully = false;
                                        this.error = e3;
                                        this.notifyAll();
                                    }
                                    return;
                                }
                                throw throwable2;
                            }
                        }
                    }
                }
                try {
                    nextJob.done(job_success, job_error == null ? null : job_error.getMessage());
                }
                catch (Exception e) {
                    logger.error("setting File Request to \"Done\" failed", (Throwable)e);
                    if (this.doneAddingJobs && this.copy_jobs.isEmpty()) break;
                    EMI_Copier eMI_Copier5 = this;
                    synchronized (eMI_Copier5) {
                        this.completed = true;
                        this.completed_successfully = false;
                        this.error = e;
                        this.notifyAll();
                    }
                    return;
                }
                HashSet<CopyJob> hashSet = this.copy_jobs;
                synchronized (hashSet) {
                    this.copy_jobs.remove(nextJob);
                }
            }
            object = this;
            synchronized (object) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    this.completed = true;
                    this.completed_successfully = false;
                    this.error = new Exception(" copier was interrupted ");
                    this.notifyAll();
                    this.notify();
                }
            }
        }
        {
            eMI_Copier = this;
            synchronized (eMI_Copier) {
                this.completed = true;
                this.notifyAll();
                return;
            }
        }
    }

    public void copy(CopyJob job) throws Exception {
        GlobusURL from = job.getSource();
        GlobusURL to = job.getDestination();
        int totype = SRMDispatcher.getUrlType((GlobusURL)to);
        if ((totype & 0x80) == 128) {
            String filename = from.getPath();
            int lastSlash = filename.lastIndexOf(47);
            if (lastSlash != -1) {
                filename = filename.substring(lastSlash);
            }
            to = new GlobusURL(to.getURL().concat(filename));
        }
        logger.debug("copying " + job);
        if (from.getProtocol().equals("dcap") || to.getProtocol().equals("dcap") || this.configuration.isUse_urlcopy_script()) {
            try {
                String[] script_protocols = null;
                try {
                    script_protocols = this.scriptCopyGetSupportedProtocols();
                    int i = 0;
                    while (i < script_protocols.length) {
                        logger.debug(String.valueOf(this.urlcopy) + " supports " + script_protocols[i]);
                        ++i;
                    }
                }
                catch (Exception e) {
                    logger.error("could not get supported protocols ");
                    script_protocols = null;
                }
                boolean from_protocol_supported = false;
                boolean to_protocol_supported = false;
                if (script_protocols != null) {
                    int i = 0;
                    while (i < script_protocols.length) {
                        if (script_protocols[i].equals(from.getProtocol())) {
                            from_protocol_supported = true;
                        }
                        if (script_protocols[i].equals(to.getProtocol())) {
                            to_protocol_supported = true;
                        }
                        if (from_protocol_supported && to_protocol_supported) break;
                        ++i;
                    }
                }
                if (from_protocol_supported && to_protocol_supported) {
                    this.scriptCopy(from, to);
                    return;
                }
            }
            catch (Exception e) {
                logger.error("script copy failed with " + e);
                logger.error("trying native java copy");
            }
        }
        if ((from.getProtocol().equals("gsiftp") || from.getProtocol().equals("gridftp")) && to.getProtocol().equals("file") || from.getProtocol().equals("file") && (to.getProtocol().equals("gsiftp") || to.getProtocol().equals("gridftp"))) {
            GSSCredential credential = null;
            credential = this.configuration.isUseproxy() ? SslGsiSocketFactory.createUserCredential((String)this.configuration.getX509_user_proxy()) : SslGsiSocketFactory.getServiceCredential((String)this.configuration.getX509_user_cert(), (String)this.configuration.getX509_user_key(), (int)0);
            this.javaGridFtpCopy(from, to, credential, logger);
            return;
        }
        URL fromURL = new URL(from.getURL());
        URL toURL = new URL(to.getURL());
        this.javaUrlCopy(fromURL, toURL);
    }

    public String[] scriptCopyGetSupportedProtocols() throws Exception {
        String command = this.urlcopy;
        command = String.valueOf(command) + " -get-protocols";
        return ShellCommandExecuter.executeAndReturnOutput((String)command, (org.dcache.srm.Logger)new EMI_SRMLogger());
    }

    public void scriptCopy(GlobusURL from, GlobusURL to) throws Exception {
        int buffer_size;
        int tcp_buffer_size;
        String x509_cert_dir;
        String x509_cert;
        String x509_key;
        String x509_proxy;
        String command = this.urlcopy;
        if (this.debug) {
            command = String.valueOf(command) + " -debug true";
        }
        if ((x509_proxy = this.configuration.getX509_user_proxy()) != null) {
            command = String.valueOf(command) + " -x509_user_proxy " + x509_proxy;
        }
        if ((x509_key = this.configuration.getX509_user_key()) != null) {
            command = String.valueOf(command) + " -x509_user_key " + x509_key;
        }
        if ((x509_cert = this.configuration.getX509_user_cert()) != null) {
            command = String.valueOf(command) + " -x509_user_cert " + x509_cert;
        }
        if ((x509_cert_dir = this.configuration.getX509_user_trusted_certificates()) != null) {
            command = String.valueOf(command) + " -x509_user_certs_dir " + x509_cert_dir;
        }
        if ((tcp_buffer_size = this.configuration.getTcp_buffer_size()) > 0) {
            command = String.valueOf(command) + " -tcp_buffer_size " + tcp_buffer_size;
        }
        if ((buffer_size = this.configuration.getBuffer_size()) > 0) {
            command = String.valueOf(command) + " -buffer_size " + buffer_size;
        }
        command = String.valueOf(command) + " -src-protocol " + from.getProtocol();
        command = from.getProtocol().equals("file") ? String.valueOf(command) + " -src-host-port localhost" : String.valueOf(command) + " -src-host-port " + from.getHost() + ":" + from.getPort();
        command = String.valueOf(command) + " -src-path " + from.getPath() + " -dst-protocol " + to.getProtocol();
        command = to.getProtocol().equals("file") ? String.valueOf(command) + " -dst-host-port localhost" : String.valueOf(command) + " -dst-host-port " + to.getHost() + ":" + to.getPort();
        command = String.valueOf(command) + " -dst-path " + to.getPath();
        int rc = 0;
        if (!this.dryRun) {
            rc = ShellCommandExecuter.execute((String)command, (org.dcache.srm.Logger)new EMI_SRMLogger());
        }
        if (rc == 0) {
            logger.info(" successfuly copied " + from.getURL() + " to " + to.getURL());
            ++this.num_completed_successfully;
        } else {
            logger.error(" failed to copy " + from.getURL() + " to " + to.getURL());
            logger.error(String.valueOf(this.urlcopy) + " return code = " + rc);
            throw new Exception(String.valueOf(this.urlcopy) + " return code = " + rc);
        }
    }

    public void javaGridFtpCopy(GlobusURL src_url, GlobusURL dst_url, GSSCredential credential, Logger logger) throws Exception {
        logger.info(" javaGridFtpCopy()");
        String serverMode = this.configuration.getServerMode();
        int numberOfStreams = this.configuration.getStreams_num();
        if ((src_url.getProtocol().equals("gsiftp") || src_url.getProtocol().equals("gridftp")) && this.dataSink != null) {
            boolean emode;
            boolean passive_server_mode = true;
            if (serverMode == null) {
                passive_server_mode = true;
            } else if (serverMode.equalsIgnoreCase("passive")) {
                passive_server_mode = true;
                if (numberOfStreams != 1) {
                    logger.error("server_mode is specified as passive, setting number of streams to 1");
                    numberOfStreams = 1;
                }
            } else if (serverMode.equalsIgnoreCase("active")) {
                passive_server_mode = false;
            } else {
                throw new IllegalArgumentException("Unknown server_mode option specified \"" + serverMode + "\". Allowed options \"passive\" or \"active\"");
            }
            boolean bl = emode = numberOfStreams != 1;
            if (!this.dryRun) {
                this.client = new EMI_GridftpClient(src_url.getHost(), src_url.getPort(), this.configuration.getTcp_buffer_size(), this.configuration.getBuffer_size(), credential);
                this.client.setStreamsNum(1);
                emode = false;
                this.client.setChecksum(this.configuration.getCksmType(), this.configuration.getCksmValue());
                try {
                    this.client.gridFTPRead(src_url.getPath(), (DataSink)this.dataSink, emode, passive_server_mode);
                    ++this.num_completed_successfully;
                }
                finally {
                    this.client.close();
                }
            } else {
                ++this.num_completed_successfully;
            }
            return;
        }
        if (this.dataSource != null && (dst_url.getProtocol().equals("gsiftp") || dst_url.getProtocol().equals("gridftp"))) {
            boolean emode;
            boolean passive_server_mode = true;
            if (serverMode == null) {
                passive_server_mode = true;
            } else if (serverMode.equalsIgnoreCase("passive")) {
                passive_server_mode = true;
            } else if (serverMode.equalsIgnoreCase("active")) {
                passive_server_mode = false;
                if (numberOfStreams != 1) {
                    logger.error("server_mode is specified as active, setting number of streams to 1");
                    numberOfStreams = 1;
                }
            } else {
                throw new IllegalArgumentException("Unknown server_mode option specified \"" + serverMode + "\". Allowed options \"passive\" or \"active\"");
            }
            boolean bl = emode = numberOfStreams != 1;
            if (!this.dryRun) {
                this.client = new EMI_GridftpClient(dst_url.getHost(), dst_url.getPort(), this.configuration.getTcp_buffer_size(), this.configuration.getBuffer_size(), credential);
                this.client.setStreamsNum(1);
                emode = false;
                this.client.setChecksum(this.configuration.getCksmType(), this.configuration.getCksmValue());
                try {
                    this.client.gridFTPWrite((DataSource)this.dataSource, dst_url.getPath(), emode, false, passive_server_mode);
                    ++this.num_completed_successfully;
                }
                finally {
                    this.client.close();
                }
            } else {
                ++this.num_completed_successfully;
            }
            return;
        }
        throw new IllegalArgumentException("need file-gridftp or gridftp-file combo");
    }

    public void javaUrlCopy(URL from, URL to) throws Exception {
        int l;
        logger.debug("javaUrlCopy()");
        InputStream in = null;
        in = from.getProtocol().equals("file") ? new FileInputStream(from.getPath()) : from.openConnection().getInputStream();
        OutputStream out = null;
        if (to.getProtocol().equals("file")) {
            out = new FileOutputStream(to.getPath());
        } else {
            URLConnection to_connect = to.openConnection();
            to_connect.setDoInput(false);
            to_connect.setDoOutput(true);
            out = to_connect.getOutputStream();
        }
        int buffer_size = this.configuration.getBuffer_size();
        if (buffer_size <= 0) {
            buffer_size = 4096;
        }
        byte[] bytes = new byte[buffer_size];
        long total = 0L;
        while ((l = in.read(bytes)) != -1) {
            total += (long)l;
            out.write(bytes, 0, l);
        }
        logger.debug("successfuly copied " + total + " bytes from " + from + " to " + to);
        ++this.num_completed_successfully;
    }

    private void cleanup() {
        CopyJob[] jobs = new CopyJob[]{};
        if ((jobs = this.copy_jobs.toArray(jobs)) == null) {
            return;
        }
        int i = 0;
        while (i < jobs.length) {
            jobs[i].done(false, "stopped by cleanup");
            ++i;
        }
    }

    private class EMI_SRMLogger
    implements org.dcache.srm.Logger {
        private Logger logger = LoggerFactory.getLogger(EMI_Copier.class);

        private EMI_SRMLogger() {
        }

        public void elog(String arg0) {
            this.logger.error(arg0);
        }

        public void elog(Throwable arg0) {
            this.logger.error("", arg0);
        }

        public void elog(String msg, Throwable arg0) {
            this.logger.error(msg, arg0);
        }

        public void log(String arg0) {
            this.logger.info(arg0);
        }
    }
}

