/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.data;

import gov.fnal.srm.util.Args;
import gov.fnal.srm.util.Option;
import gov.fnal.srm.util.OptionParser;
import gov.fnal.srm.util.Version;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dcache.srm.client.Transport;
import org.slf4j.Logger;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EMI_Configuration {
    public static final String SRMCPCONFIGNAMESPACE = "srmcp.srm.fnal.gov";
    private static final String webservice_pathv1 = "srm/managerv1";
    private static final String webservice_pathv2 = "srm/managerv2";
    private static final String HOME_DIRECTORY = System.getProperty("user.home");
    private static final String PATH_SEPARATOR = System.getProperty("file.separator");
    private static final String CONFIGURATION_DIRECTORY = ".srmconfig";
    private String DEFAULT_CONFIG_FILE = String.valueOf(HOME_DIRECTORY) + PATH_SEPARATOR + ".srmconfig" + PATH_SEPARATOR + "config.xml";
    @Option(name="default_port", description="default SRM port number", defaultValue="8443", required=false, log=true, save=true)
    private int srmDefaultPortNumber;
    @Option(name="debug", description="enable debug output (including stack traces)", defaultValue="false", required=false, log=true, save=true)
    private boolean debug;
    @Option(name="srmcphome", description="path to srmcp product directory", defaultValue="..", required=false, log=true, save=true)
    private String srmcphome;
    @Option(name="urlcopy", description="path to the urlcopy script", defaultValue="sbin/urlcopy.sh", required=false, log=true, save=true)
    private String urlcopy;
    @Option(name="gsiftpclient", description="name of ftp client \"globus-url-copy\" or \"kftp\"", defaultValue="globus-url-copy", required=false, log=true, save=true)
    private String gsiftpclinet;
    @Option(name="help", description="displays usage", defaultValue="false", required=false, log=true)
    private boolean help;
    @Option(name="h", description="displays usage", defaultValue="false", required=false, log=true)
    private boolean is_help;
    @Option(name="mapfile", description="path to the \"glue\" mapfile", defaultValue="conf/SRMServerV1.map", required=false, log=true, save=true)
    private String glue_mapfile;
    @Option(name="webservice_path", description="path to wsdl in web service url", required=false, log=true, save=true)
    private String webservice_path;
    @Option(name="use_proxy", description="use user proxy(true) or use certificates directly(false)", defaultValue="true", required=false, log=true, save=true)
    private boolean useproxy;
    @Option(name="x509_user_proxy", description="absolute path to user proxy", required=false, log=true, save=true)
    private String x509_user_proxy;
    @Option(name="x509_user_cert", description="absolute path to user (or host) certificate", required=false, log=true, save=true)
    private String x509_user_cert;
    @Option(name="x509_user_key", description="absolute path to user (or host) private key", required=false, log=true, save=true)
    private String x509_user_key;
    @Option(name="x509_user_trusted_certificates", description="absolute path to the trusted certificates directory", defaultValue="/etc/grid-security/certificates", required=false, log=true, save=true)
    private String x509_user_trusted_certificates;
    @Option(name="globus_tcp_port_range", description="comma separated globus tcp port range, like MIN,MAX", required=false, log=true, save=true)
    private String globus_tcp_port_range;
    @Option(name="gss_expected_name", description="gss expected name", required=false, log=true, save=true)
    private String gss_expected_name;
    @Option(name="protocols", description="comma separated list of protocol names", defaultValue="gsiftp,dcap,http", required=false, log=true, save=true)
    private String protocols_list;
    private String[] protocols = new String[]{"gsiftp", "dcap", "http"};
    @Option(name="pushmode", description="true for pushmode and false for pullmode", defaultValue="false", required=false, log=true, save=true)
    private boolean pushmode;
    @Option(name="buffer_size", description="buffer size, nonnegative integer", defaultValue="131072", unit="bytes", required=false, log=true, save=true)
    private int buffer_size;
    @Option(name="tcp_buffer_size", description="tcp buffer size, nonnegative integer, (0 means do not set tcp_buffer_size at all)", defaultValue="0", unit="bytes", required=false, log=true, save=true)
    private int tcp_buffer_size;
    @Option(name="streams_num", description="number of streams, nonnegative integer. Multi-stream extended block transfer require writes to be performed in server-passive and reads in server active mode. If client specified server_mode option conflicts with the multi-stream required mode, the transfer will be performed in a single stream mode, regardless of value specified for the streams_num option", defaultValue="10", required=false, log=true, save=true)
    private int streams_num;
    @Option(name="conf", description="name of the configuration file", defaultValue="config.xml", required=false, log=true)
    private String config_file;
    @Option(name="save_conf", description="path to the file where new configuration will be saved", required=false, log=true)
    private String save_config_file;
    private Logger logger;
    @Option(name="do_remove", description="remove files when executing srm-release-files", defaultValue="false", required=false, log=true, save=true)
    private boolean doRemove;
    @Option(name="copy", description=" performs srm \"get\", \"put\", or \"copy\" depending on arguments", defaultValue="false", required=false, log=true)
    private boolean copy;
    @Option(name="bringOnline", description="performs srmBringOnline", defaultValue="false", required=false, log=true)
    private boolean bringOnline;
    @Option(name="ping", description="performs srm ping command (useful for diagnostics and version info)", defaultValue="false", required=false, log=true)
    private boolean ping;
    @Option(name="reserveSpace", description="performs explicit space reservation", defaultValue="false", required=false, log=true)
    private boolean reserveSpace;
    @Option(name="array_of_client_networks", description="comma separated array of client networks", required=false, log=true, save=true)
    private String array_of_client_networks;
    private String[] arrayOfClientNetworks;
    @Option(name="retention_policy", description="retention policy", required=false, log=true, save=true)
    private String retentionPolicy;
    @Option(name="space_desc", description="space reservation description", required=false, log=true)
    private String spaceTokenDescription;
    @Option(name="access_latency", description="access latency", required=false, log=true, save=true)
    private String accessLatency;
    @Option(name="access_pattern", description="access pattern (\"TRANSFER_MODE\"|\"PROCESSING_MODE\")", defaultValue="null", required=false, log=true, save=true)
    private String accessPattern;
    @Option(name="connection_type", description="connection type, (\"WAN\"|\"LAN\")", defaultValue="null", required=false, log=true, save=true)
    private String connectionType;
    @Option(name="desired_size", description="desired space reservation size", defaultValue="null", unit="bytes", required=false, log=true)
    private Long desiredReserveSpaceSize;
    @Option(name="guaranteed_size", description="guaranteed space reservation size", defaultValue="null", unit="bytes", required=false, log=true)
    private Long guaranteedReserveSpaceSize;
    @Option(name="lifetime", description="desired lifetime in seconds", defaultValue="null", unit="seconds", required=false, log=true)
    private Long desiredLifetime;
    @Option(name="releaseSpace", description="performs release of explicit  space reservation", defaultValue="false", required=false, log=true)
    private boolean releaseSpace;
    @Option(name="space_token", description="space reservation token", required=false, log=true)
    private String spaceToken;
    @Option(name="force", description="force space reservation release", defaultValue="false", required=false, log=true, save=true)
    private boolean forceFileRelease;
    @Option(name="getSpaceMetaData", description="retrieves and prints metadata for given space tokens", defaultValue="false", required=false, log=true)
    private boolean getSpaceMetaData;
    private String[] spaceTokensList;
    private String[] from;
    private String to;
    @Option(name="space_tokens", description="comma separated list of space reservation tokens", required=false, log=true)
    private String space_tokens_list;
    @Option(name="copyjobfile", description="is the path to the text file containing list of sources and destination", required=false, log=true, save=true)
    private String copyjobfile;
    @Option(name="wsdl_url", description="full URL to web service WSDL, overrides \"-webservice_path\" and \"-webservice_protocol\" options", required=false, log=true, save=true)
    private String wsdl_url;
    @Option(name="use_urlcopy_script", description="if true, use urlcopy script, otherwise use java native copiers", defaultValue="false", required=false, log=true, save=true)
    private boolean use_urlcopy_script;
    @Option(name="getFileMetaData", description="gets srm meta data for specified surls", defaultValue="false", required=false, log=true)
    private boolean getFileMetaData;
    @Option(name="ls", description="list content of directory", defaultValue="false", required=false, log=true)
    private boolean ls;
    @Option(name="getSpaceTokens", description="gets space tokens belonging to this user", defaultValue="false", required=false, log=true)
    private boolean getSpaceTokens;
    @Option(name="rm", description="remove file(s)", defaultValue="false", required=false, log=true)
    private boolean is_rm;
    @Option(name="rmdir", description="remove empty directory tree", defaultValue="false", required=false, log=true)
    private boolean is_rmdir;
    @Option(name="mv", description="performs srm \"mv\" of files and directories ", defaultValue="false", required=false, log=true)
    private boolean is_mv;
    @Option(name="mkdir", description="create directory ", defaultValue="false", required=false, log=true)
    private boolean is_mkdir;
    @Option(name="getPermissions", description="get permission of files", defaultValue="false", required=false, log=true)
    private boolean getPermission;
    @Option(name="checkPermissions", description="check permission of files", defaultValue="false", required=false, log=true)
    private boolean checkPermission;
    @Option(name="setPermissions", description="set permissions of files", defaultValue="false", required=false, log=true)
    private boolean setPermission;
    @Option(name="getRequestSummary", description="is to retrieve a summary of the submitted request", defaultValue="false", required=false, log=true)
    private boolean is_getRequestSummary;
    @Option(name="getRequestTokens", description="retrieves request tokens for the clients requests, given client provided request description", defaultValue="false", required=false, log=true)
    private boolean is_getRequestTokens;
    @Option(name="abortFiles", description="to abort files", defaultValue="false", required=false, log=true)
    private boolean is_AbortFiles;
    @Option(name="releaseFiles", description=" to unpin files", defaultValue="false", required=false, log=true)
    private boolean is_ReleaseFiles;
    @Option(name="request_desc", description="request token description", required=false, log=true)
    private String userRequestDescription;
    @Option(name="type", description="permission type <ADD|REMOVE|CHANGE>", required=false, log=true)
    private String setPermissionType;
    @Option(name="owner", description="owner permission mode <NONE,X,W,WR,R,RX,RW,RWX>", required=false, log=true)
    private String setOwnerPermissionMode;
    @Option(name="group", description="group permission mode <NONE,X,W,WR,R,RX,RW,RWX>", required=false, log=true)
    private String setGroupPermissionMode;
    @Option(name="other", description="world permission mode <NONE,X,W,WR,R,RX,RW,RWX>", required=false, log=true)
    private String setOtherPermissionMode;
    private String setPermissionSurl;
    @Option(name="request_tokens", description="<id>,<id1>,<id2>... (comma separated list of Request Token(s))", required=false, log=true)
    private String requestTokens;
    @Option(name="request_token", description="request token", required=false, log=true)
    private String srmExtendFileLifetimeRequestToken;
    @Option(name="file_lifetime", description="number of seconds to add to current time to extend file lifetime of SURL(s)", required=false, log=true, save=true)
    private Integer newFileLifetime;
    @Option(name="pin_lifetime", description="number of seconds to add to current time to extend pin lifetime of SURL(s)", required=false, log=true, save=true)
    private Integer newPinLifetime;
    @Option(name="extendFileLifetime", description="exend file(s) lifetimes", defaultValue="false", required=false, log=true)
    private boolean extendFileLifetime;
    @Option(name="advisoryDelete", description="performs AdvisoryDelete", defaultValue="false", required=false, log=true)
    private boolean advisoryDelete;
    @Option(name="getRequestStatus", description="gets Request Status", defaultValue="false", required=false, log=true)
    private boolean getRequestStatus;
    private String getRequestStatusSurl;
    @Option(name="request_id", description="request token", defaultValue="0", required=false, log=true)
    private int getRequestStatusId;
    @Option(name="retry_timeout", description="number of miliseconds to sleep after a failure", defaultValue="10000", unit="milliseconds", required=false, log=true, save=true)
    private long retry_timeout;
    @Option(name="retry_num", description="number of retries before client gives up", defaultValue="20", required=false, log=true, save=true)
    private int retry_num;
    @Option(name="connect_to_wsdl", description="connect to WSDL instead of connecting to the server directly", defaultValue="false", required=false, log=true, save=true)
    private boolean connect_to_wsdl;
    @Option(name="transport", description="the transport to use when connecting to server.", defaultValue="GSI", required=false, log=true, save=true)
    private String transport;
    @Option(name="delegate", description="enables delegation of user credenital to the server", defaultValue="true", required=false, log=true, save=true)
    private boolean delegate;
    @Option(name="full_delegation", description="specifies type (full or limited) of delegation", defaultValue="true", required=false, log=true, save=true)
    private boolean full_delegation;
    @Option(name="version", description="print SRM version information", defaultValue="false", required=false, log=true)
    private boolean version;
    @Option(name="report", description="the path to the report file", required=false, log=true, save=true)
    private String report;
    @Option(name="server_mode", description="gridftp server mode for data transfer (\"passive\" or \"active\"). Needs to be explicitly specified to appropriate value if client or ftp server is behind a firewall", defaultValue="null", required=false, log=true, save=true)
    private String server_mode;
    @Option(name="storagetype", description="<permanent|volatile|durable> to specify type of storage to use", defaultValue="null", required=false, log=true, save=true)
    private String storagetype;
    @Option(name="stage", description="performs srm \"get\", without actual copy of the files with the hope that this will trigger staging in srm managed", defaultValue="false", required=false, log=true)
    private boolean stage;
    @Option(name="l", description="long format mode", defaultValue="false", required=false, log=true, save=true)
    private boolean longLsFormat;
    @Option(name="recursion_depth", description="directory tree depth level", defaultValue="1", required=false, log=false)
    private int recursionDepth;
    @Option(name="recursive", description="enables recursive empty directory deletion", defaultValue="false", required=false, log=true)
    private boolean recursive;
    @Option(name="offset", description="offset the number of elements to report", defaultValue="0", required=false, log=true, save=true)
    private int lsOffset;
    @Option(name="count", description="number of elements to report", defaultValue="null", required=false, log=true, save=true)
    private Integer lsCount;
    @Option(name="srm_protocol_version", description="srm protocol version", defaultValue="0", required=false, log=true, save=true)
    private int srm_protocol_version;
    @Option(name="1", description="srm protocol version 1", defaultValue="false", required=false, log=false)
    private boolean isSrmv1;
    @Option(name="2", description="srm protocol version 2", defaultValue="false", required=false, log=false)
    private boolean isSrmv2;
    @Option(name="request_lifetime", description="<num of seconds> request lifetime", defaultValue="86400", unit="seconds", required=false, log=true, save=true)
    private long request_lifetime;
    @Option(name="priority", description="specify request priority, 0 is lowest", defaultValue="0", required=false, log=true, save=true)
    private Integer priority;
    private Map<String, String> extraParameters = new HashMap<String, String>();
    @Option(name="overwrite_mode", description="<ALWAYS|NEVER|WHEN_FILES_ARE_DIFFERENT>", required=false, log=true, save=true)
    private String overwriteMode;
    @Option(name="send_cksm", description="send check sum to gridftp server", required=false, log=true, defaultValue="true", save=true)
    private boolean doSendCheckSum;
    @Option(name="cksm_type", description="<type|negotiate> calculate and verify server and client checksum values using this type (adler32|MD4|MD5|....). If checksum value has been omitted, missing value will be computed over the local file. If negotiate is set - client will attempt to negotiate cksm type for the file checksum value avilable at the server. For gridftp transfers to/from servers that support checksumming features", required=false, log=true, save=true)
    private String cksm_type;
    @Option(name="cksm_value", description="<checksum HEX value> override dynamic calucation of the local checksum with this value. If cksm_type option has not been set, adler32 will be assumed. For gridftp transfers to/from servers that support checksumming features", required=false, log=true)
    private String cksm_value;
    private String[] arrayOfRequestTokens = null;
    @Option(name="abortRequest", description="to abort request", defaultValue="false", required=false, log=true)
    private boolean is_AbortRequest;
    @Option(name="print_performance", description="if print_performance is set to a true, print start and end time of each client run, followed by the number of the specific run, followed by the value of the perf string, ", defaultValue="false", required=false, log=true)
    private boolean printPerformance;
    @Option(name="performance_test_name", description="if performance_test_name is set to a true, and performance_test_name is specified, this name will be printed in each line with performance info ", defaultValue="null", required=false, log=true)
    private String performanceTestName;
    @Option(name="repeat", description="number of times to repeat a client run", defaultValue="1", required=false, log=true, save=true)
    private int repeatCount;
    @Option(name="dryrun", description="performs srm \"get/put\", without actual data transfer for use as a diagnostics tool", defaultValue="false", required=false, log=true)
    private boolean dryRun;
    private String srmUrl;
    private String[] surls;
    private String mkdir_options = " srmmkdir options : None\nExamples: \n\t\t srm -mkmdir srm://fledgling06.fnal.gov:8443/srm/managerv2?SFN=/dir/path/ \n";
    private String rm_options = " srmrm options : None \n\t\t Applies to files only.\n";
    private String stage_options = " stage options: None \n";
    private String getPermission_options = " srm-get-permissions options: None \n";
    private String checkPermission_options = " srm-check-permissions options : None \n";

    public int getDefaultSrmPortNumber() {
        return this.srmDefaultPortNumber;
    }

    public void setDefaultSrmPortNumber(int port) {
        this.srmDefaultPortNumber = port;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getSrmcphome() {
        return this.srmcphome;
    }

    public void setSrmcphome(String srmcphome) {
        this.srmcphome = srmcphome;
    }

    public String getUrlcopy() {
        return this.urlcopy;
    }

    public void setUrlcopy(String urlcopy) {
        this.urlcopy = urlcopy;
    }

    public String getGsiftpclinet() {
        return this.gsiftpclinet;
    }

    public void setGsiftpclinet(String gsiftpclinet) {
        this.gsiftpclinet = gsiftpclinet;
    }

    public boolean isHelp() {
        return this.help;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public String getGlue_mapfile() {
        return this.glue_mapfile;
    }

    public void setGlue_mapfile(String glue_mapfile) {
        this.glue_mapfile = glue_mapfile;
    }

    public String getWebservice_path() {
        String ws_path = this.webservice_path;
        if (ws_path == null) {
            ws_path = this.srm_protocol_version == 2 ? webservice_pathv2 : webservice_pathv1;
        }
        return ws_path;
    }

    public void setWebservice_path(String webservice_path) {
        this.webservice_path = webservice_path;
    }

    public boolean isUseproxy() {
        return this.useproxy;
    }

    public void setUseproxy(boolean useproxy) {
        this.useproxy = useproxy;
    }

    public String getX509_user_proxy() {
        return this.x509_user_proxy;
    }

    public void setX509_user_proxy(String x509_user_proxy) {
        this.x509_user_proxy = x509_user_proxy;
    }

    public String getX509_user_cert() {
        return this.x509_user_cert;
    }

    public void setX509_user_cert(String x509_user_cert) {
        this.x509_user_cert = x509_user_cert;
    }

    public String getX509_user_key() {
        return this.x509_user_key;
    }

    public void setX509_user_key(String x509_user_key) {
        this.x509_user_key = x509_user_key;
    }

    public String getX509_user_trusted_certificates() {
        return this.x509_user_trusted_certificates;
    }

    public void setX509_user_trusted_certificates(String x509_user_trusted_certificates) {
        this.x509_user_trusted_certificates = x509_user_trusted_certificates;
    }

    public String getGlobus_tcp_port_range() {
        return this.globus_tcp_port_range;
    }

    public void setGlobus_tcp_port_range(String globus_tcp_port_range) {
        this.globus_tcp_port_range = globus_tcp_port_range;
    }

    public String getGss_expected_name() {
        if (this.gss_expected_name == null) {
            this.gss_expected_name = "host";
        }
        return this.gss_expected_name;
    }

    public void setGss_expected_name(String gss_expected_name) {
        this.gss_expected_name = gss_expected_name;
    }

    public String getProtocolsList() {
        return this.protocols_list;
    }

    public void setProtocolsList(String protocols_list) {
        this.protocols_list = protocols_list;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    public boolean isPushmode() {
        return this.pushmode;
    }

    public void setPushmode(boolean pushmode) {
        this.pushmode = pushmode;
    }

    public int getBuffer_size() {
        return this.buffer_size;
    }

    public void setBuffer_size(int buffer_size) {
        this.buffer_size = buffer_size;
    }

    public int getTcp_buffer_size() {
        return this.tcp_buffer_size;
    }

    public void setTcp_buffer_size(int tcp_buffer_size) {
        this.tcp_buffer_size = tcp_buffer_size;
    }

    public int getStreams_num() {
        return this.streams_num;
    }

    public void setStreams_num(int streams_num) {
        this.streams_num = streams_num;
    }

    public String getSave_config_file() {
        return this.save_config_file;
    }

    public void setSave_config_file(String save_config_file) {
        this.save_config_file = save_config_file;
    }

    public boolean getDoRemove() {
        return this.doRemove;
    }

    public void setDoRemove(boolean yes) {
        this.doRemove = yes;
    }

    public boolean isCopy() {
        return this.copy;
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    public boolean isBringOnline() {
        return this.bringOnline;
    }

    public void setBringOnline(boolean bringOnline) {
        this.bringOnline = bringOnline;
    }

    public boolean isPing() {
        return this.ping;
    }

    public void setPing(boolean ping) {
        this.ping = ping;
    }

    public boolean isReserveSpace() {
        return this.reserveSpace;
    }

    public void setReserveSpace(boolean reserveSpace) {
        this.reserveSpace = reserveSpace;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public void setRetentionPolicy(String s) {
        this.retentionPolicy = s;
    }

    public String getSpaceTokenDescription() {
        return this.spaceTokenDescription;
    }

    public void setSpaceTokenDescription(String s) {
        this.spaceTokenDescription = s;
    }

    public String getAccessLatency() {
        return this.accessLatency;
    }

    public void setAccessLatency(String s) {
        this.accessLatency = s;
    }

    public String getAccessPattern() {
        return this.accessPattern;
    }

    public void setAccessPattern(String s) {
        this.accessPattern = s;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(String s) {
        this.connectionType = s;
    }

    public Long getDesiredReserveSpaceSize() {
        return this.desiredReserveSpaceSize;
    }

    public void setDesiredReserveSpaceSize(Long size) {
        this.desiredReserveSpaceSize = size;
    }

    public Long getGuaranteedReserveSpaceSize() {
        return this.guaranteedReserveSpaceSize;
    }

    public void setGuaranteedReserveSpaceSize(Long size) {
        this.guaranteedReserveSpaceSize = size;
    }

    public Long getDesiredLifetime() {
        return this.desiredLifetime;
    }

    public boolean isReleaseSpace() {
        return this.releaseSpace;
    }

    public String getSpaceToken() {
        return this.spaceToken;
    }

    public void setSpaceToken(String s) {
        this.spaceToken = s;
    }

    public boolean getForceFileRelease() {
        return this.forceFileRelease;
    }

    public void setForceFileRelease(boolean yes) {
        this.forceFileRelease = yes;
    }

    public boolean isGetSpaceMetaData() {
        return this.getSpaceMetaData;
    }

    public void setGetSpaceMetaData(boolean getSpaceMetaData) {
        this.getSpaceMetaData = getSpaceMetaData;
    }

    public String getCopyjobfile() {
        return this.copyjobfile;
    }

    public void setCopyjobfile(String copyjobfile) {
        this.copyjobfile = copyjobfile;
    }

    public String getWsdl_url() {
        return this.wsdl_url;
    }

    public void setWsdl_url(String wsdl_url) {
        this.wsdl_url = wsdl_url;
    }

    public boolean isUse_urlcopy_script() {
        return this.use_urlcopy_script;
    }

    public void setUse_urlcopy_script(boolean use_urlcopy_script) {
        this.use_urlcopy_script = use_urlcopy_script;
    }

    public boolean isGetFileMetaData() {
        return this.getFileMetaData;
    }

    public void setGetFileMetaData(boolean getFileMetaData) {
        this.getFileMetaData = getFileMetaData;
    }

    public boolean isls() {
        return this.ls;
    }

    public void setLs(boolean l) {
        this.ls = l;
    }

    public boolean isGetSpaceTokens() {
        return this.getSpaceTokens;
    }

    public void setGetSpaceTokens(boolean getSpaceTokens) {
        this.getSpaceTokens = getSpaceTokens;
    }

    public boolean isRm() {
        return this.is_rm;
    }

    public void setRm(boolean r) {
        this.is_rm = r;
    }

    public boolean isRmdir() {
        return this.is_rmdir;
    }

    public void setRmdir(boolean r) {
        this.is_rmdir = r;
    }

    public boolean isMove() {
        return this.is_mv;
    }

    public void setMove(boolean r) {
        this.is_mv = r;
    }

    public boolean isMkdir() {
        return this.is_mkdir;
    }

    public void setMkdir(boolean r) {
        this.is_mkdir = r;
    }

    public boolean isGetPermission() {
        return this.getPermission;
    }

    public void setGetPermission(boolean r) {
        this.getPermission = r;
    }

    public boolean isCheckPermission() {
        return this.checkPermission;
    }

    public void setCheckPermission(boolean r) {
        this.checkPermission = r;
    }

    public boolean isSetPermission() {
        return this.setPermission;
    }

    public void setSetPermission(boolean r) {
        this.setPermission = r;
    }

    public boolean isGetRequestSummary() {
        return this.is_getRequestSummary;
    }

    public void setGetRequestSummary(boolean r) {
        this.is_getRequestSummary = r;
    }

    public boolean isGetRequestTokens() {
        return this.is_getRequestTokens;
    }

    public void setGetRequestTokens(boolean getRequestTokens) {
        this.is_getRequestTokens = getRequestTokens;
    }

    public boolean isAbortFiles() {
        return this.is_AbortFiles;
    }

    public void setAbortFiles(boolean yes) {
        this.is_AbortFiles = yes;
    }

    public boolean isReleaseFiles() {
        return this.is_ReleaseFiles;
    }

    public void setReleaseFiles(boolean yes) {
        this.is_ReleaseFiles = yes;
    }

    public String getUserRequestDescription() {
        return this.userRequestDescription;
    }

    public void setUserRequestDescription(String desc) {
        this.userRequestDescription = desc;
    }

    public String getSetPermissionType() {
        return this.setPermissionType;
    }

    public void setSetPermissionType(String x) {
        this.setPermissionType = x;
    }

    public String getSetOwnerPermissionMode() {
        return this.setOwnerPermissionMode;
    }

    public void setSetOwnerPermissionMode(String x) {
        this.setOwnerPermissionMode = x;
    }

    public String getSetGroupPermissionMode() {
        return this.setGroupPermissionMode;
    }

    public void setSetGroupPermissionMode(String x) {
        this.setGroupPermissionMode = x;
    }

    public String getSetOtherPermissionMode() {
        return this.setOtherPermissionMode;
    }

    public void setSetOtherPermissionMode(String x) {
        this.setOtherPermissionMode = x;
    }

    public String getExtendFileLifetimeRequestToken() {
        return this.srmExtendFileLifetimeRequestToken;
    }

    public void setExtendFileLifetimeRequestToken(String token) {
        this.srmExtendFileLifetimeRequestToken = token;
    }

    public Integer getNewFileLifetime() {
        return this.newFileLifetime;
    }

    public void setNewFileLifetime(Integer lt) {
        this.newFileLifetime = lt;
    }

    public Integer getNewPinLifetime() {
        return this.newPinLifetime;
    }

    public void setNewPinLifetime(Integer lt) {
        this.newPinLifetime = lt;
    }

    public boolean isExtendFileLifetime() {
        return this.extendFileLifetime;
    }

    public void setExtendFileLifetime(boolean x) {
        this.extendFileLifetime = x;
    }

    public boolean isAdvisoryDelete() {
        return this.advisoryDelete;
    }

    public void setAdvisoryDelete(boolean x) {
        this.advisoryDelete = x;
    }

    public boolean isGetRequestStatus() {
        return this.getRequestStatus;
    }

    public void setGetRequestStatus(boolean x) {
        this.getRequestStatus = x;
    }

    public int getGetRequestStatusId() {
        return this.getRequestStatusId;
    }

    public void setGetRequestStatusId(int getRequestStatusId) {
        this.getRequestStatusId = getRequestStatusId;
    }

    public long getRetry_timeout() {
        return this.retry_timeout;
    }

    public void setRetry_timeout(long retry_timeout) {
        this.retry_timeout = retry_timeout;
    }

    public int getRetry_num() {
        return this.retry_num;
    }

    public void setRetry_num(int retry_num) {
        this.retry_num = retry_num;
    }

    public boolean isConnect_to_wsdl() {
        return this.connect_to_wsdl;
    }

    public void setConnect_to_wsdl(boolean connect_to_wsdl) {
        this.connect_to_wsdl = connect_to_wsdl;
    }

    public Transport getTransport() {
        return Transport.transportFor((String)this.transport);
    }

    public void setTransport(String transport) {
        this.transport = Transport.transportFor((String)transport).name();
    }

    public boolean isDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public boolean isFull_delegation() {
        return this.full_delegation;
    }

    public void setFull_delegation(boolean full_delegation) {
        this.full_delegation = full_delegation;
    }

    public String getReport() {
        return this.report;
    }

    public void setReport(String report) {
        this.report = report;
    }

    public String getServerMode() {
        return this.server_mode;
    }

    public synchronized void setServerMode(String x) {
        this.server_mode = x;
    }

    public String getStorageType() {
        return this.storagetype;
    }

    public void setStorageType(String storage_type) {
        this.storagetype = storage_type;
    }

    public boolean isStage() {
        return this.stage;
    }

    public void setStage(boolean stage) {
        this.stage = stage;
    }

    public boolean isLongLsFormat() {
        return this.longLsFormat;
    }

    public void setLongLsFormat(boolean x) {
        this.longLsFormat = x;
    }

    public int getRecursionDepth() {
        return this.recursionDepth;
    }

    public void setRecursionDepth(int x) {
        this.recursionDepth = x;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public int getLsOffset() {
        return this.lsOffset;
    }

    public void setLsOffset(int x) {
        this.lsOffset = x;
    }

    public Integer getLsCount() {
        return this.lsCount;
    }

    public void setLsCount(Integer count) {
        this.lsCount = count;
    }

    public int getSrmProtocolVersion() {
        return this.srm_protocol_version;
    }

    public void setSrmProtocolVersion(int srmProtocolVersion) {
        this.srm_protocol_version = srmProtocolVersion;
    }

    public long getRequestLifetime() {
        return this.request_lifetime;
    }

    public void setRequestLifetime(long requestLifetime) {
        this.request_lifetime = requestLifetime;
    }

    public Integer getRequestPriority() {
        return this.priority;
    }

    public void setRequestPriority(int p) {
        this.priority = p;
    }

    public String getOverwriteMode() {
        return this.overwriteMode;
    }

    public void setOverwriteMode(String overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public boolean getDoSendCheckSum() {
        return this.doSendCheckSum;
    }

    public void setDoSendCheckSum(boolean sendCheckSum) {
        this.doSendCheckSum = sendCheckSum;
    }

    public String getCksmType() {
        return this.cksm_type;
    }

    public void setCksmType(String type) {
        this.cksm_type = type;
    }

    public String getCksmValue() {
        return this.cksm_value;
    }

    public void setCksmValue(String value) {
        this.cksm_value = value;
    }

    public boolean isAbortRequest() {
        return this.is_AbortRequest;
    }

    public void setAbortRequest(boolean yes) {
        this.is_AbortRequest = yes;
    }

    public boolean isPrintPerfomance() {
        return this.printPerformance;
    }

    public void setPrintPerfomance(boolean printPerformance) {
        this.printPerformance = printPerformance;
    }

    public String getPerformanceTestName() {
        return this.performanceTestName;
    }

    public void setPerformanceTestName(String performanceTestName) {
        this.performanceTestName = performanceTestName;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int count) {
        this.repeatCount = count;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryrun(boolean dryrun) {
        this.dryRun = dryrun;
    }

    public final String usage() {
        String general_options = " General Options :\n" + OptionParser.printOptions((Object)this, (String[])new String[]{"version", "debug", "srmcphome", "gsissl", "mapfile", "wsdl_url", "webservice_path", "webservice_protocol", "use_proxy", "x509_user_proxy", "x509_user_cert", "x509_user_key", "x509_user_trusted_certificates", "globus_tcp_port_range", "gss_expected_name", "srm_protocol_version", "1", "2", "conf", "save_conf", "retry_timeout", "retry_num", "connect_to_wsdl", "delegate", "full_delegation", "transport", "h", "help"});
        if (this.getFileMetaData) {
            return "\nUsage:get-file-metadata [command line options]  srmurl\n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + general_options;
        }
        if (this.getSpaceTokens) {
            String getSpaceTokensOptions = "get-space-tokens options :\n" + OptionParser.printOptions((Object)this, (String[])new String[]{"space_desc"});
            return "\nUsage:get-space-tokens [command line options]  srmurl\n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + getSpaceTokensOptions : getSpaceTokensOptions);
        }
        if (this.advisoryDelete) {
            return "Usage:advisory-delete [command line options]  srmurl(s)\n     default options can be set in configuration file \n     or overriden by the command line options\n\n" + general_options;
        }
        if (this.getRequestStatus) {
            String getRequestStatusOptions = " get-request-status options :\n" + OptionParser.printOptions((Object)this, (String[])new String[]{"request_id"});
            return "\nUsage:get-request-status  [command line options]  srmurl \n\n       where srmurl is one of the surl specified in the original request\n       and is used for determening the srm endpoint location\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + getRequestStatusOptions : getRequestStatusOptions);
        }
        if (this.copy) {
            String copy_options = " srmcp options :\n" + OptionParser.printOptions((Object)this, (String[])new String[]{"urlopy", "buffer_size", "tcp_buffer_size", "streams_num", "send_cksm", "server_mode", "storagetype", "array_of_client_networks", "protocols", "space_token", "retention_policy", "access_latency", "access_pattern", "connection_type", "overwrite_mode", "pushmode", "srmstage", "use_urlcopy_script", "srm_protocol_version", "2", "1", "priority", "request_lifetime", "copyjobfile", "report", "cksm_type", "cksm_value"}) + "the following return codes are supported:\n" + "\t\t 0 - success\n" + "\t\t 1 - general error\n" + "\t\t 2 - file exists, can not overwrite\n" + "\t\t 3 - user permission error\n" + "Example of srm put:\n" + "\t\t srmcp file:////bin/sh srm://myhost.mydomain.edu:8443//dir1/dir2/sh-copy\n" + "Example of srm get:\n" + "\t\t srmcp srm://myhost.mydomain.edu:8443//dir1/dir2/sh-copy file:///localdir/sh\n" + "Example of srm copy (srm to srm):\n" + "\t\t srmcp srm://myhost.mydomain.edu:8443//dir1/dir2/sh-copy srm://anotherhost.org:8443/newdir/sh-copy\n" + "Example of srm copy (gsiftp to srm):\n" + "\t\t srmcp gsiftp://ftphost.org//path/file srm://myhost.mydomain.edu:8443//dir1/dir2/file\n" + "port number is optional\n";
            return "\nUsage: srmcp [command line options] source(s) destination\n\n or  : srmcp [command line options] -copyjobfile=<file>\n       either source(s) or destination or both should be (an) srm url\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + copy_options : copy_options);
        }
        if (this.bringOnline) {
            String bring_online_options = " srm-bring-online options: \n" + OptionParser.printOptions((Object)this, (String[])new String[]{"storagetype", "protocols", "space_token", "access_pattern", "connection_type", "array_of_client_networks", "retention_policy", "access_latency", "srm_protocol_version", "2", "1", "request_lifetime", "lifetime", "priority", "report"});
            return "\nUsage: srm-bring-online [command line options] srmUrl(s)\n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + bring_online_options : bring_online_options);
        }
        if (this.reserveSpace) {
            String reserveSpace_options = " srm-reserve-space options : \n" + OptionParser.printOptions((Object)this, (String[])new String[]{"space_desc", "retention_policy", "access_latency", "access_pattern", "array_of_client_networks", "protocols", "connection_type", "desired_size", "guaranteed_size", "lifetime"}) + this.printMandatoryOptions("retention_policy", "guaranteed_size");
            return "\nUsage: srm-reserve-space [command line options]  srmUrl\n\n       default options are read from configuration file\n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + reserveSpace_options : reserveSpace_options);
        }
        if (this.getSpaceMetaData) {
            String getSpaceMetaData_options = " srm-get-space-metadata options:\n" + OptionParser.printOptions((Object)this, (String[])new String[]{"space_tokens"}) + this.printMandatoryOptions("space_tokens");
            return "\nUsage: srm-get-space-metadata [commnad line options] srmUrl\n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + getSpaceMetaData_options : getSpaceMetaData_options);
        }
        if (this.releaseSpace) {
            String releaseSpace_options = " srm-release-space options :\n" + OptionParser.printOptions((Object)this, (String[])new String[]{"space_token", "force"}) + this.printMandatoryOptions("space_token");
            return "\nUsage: srm-release-space [command line options]  srmUrl\n\n     default options can be set in configuration file \n     or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + releaseSpace_options : releaseSpace_options);
        }
        if (this.ls) {
            String ls_options = "srmls options :\n" + OptionParser.printOptions((Object)this, (String[])new String[]{"l", "recursion_depth", "count", "offset"});
            return "\nUsage: srmls [command line options] srmUrl [[srmUrl]...]\n\n" + (this.isHelp() ? String.valueOf(general_options) + ls_options : ls_options);
        }
        if (this.is_rm) {
            return "\nUsage: srmrm [command line options] srmUrl [[srmUrl]...]\n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + this.rm_options : this.rm_options);
        }
        if (this.is_mv) {
            String move_options = "srmmv options :\nOnly moves within single storage system are allowed \n(you can't mv from one SRM to another SRM \n(or from/to remote/local filesystem, use copy and delete)).\n";
            return "\nUsage: srmmv [command line options] sourceSrmUrl destinationSrmUrl \n\n" + (this.isHelp() ? String.valueOf(general_options) + move_options : move_options);
        }
        if (this.is_getRequestSummary) {
            String getRequestSummary_options = " srm-get-request-summary options:\n" + OptionParser.printOptions((Object)this, (String[])new String[]{"request_tokens"});
            return "\nUsage: srm-get-request-summary [command line options] srmUrl \n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + getRequestSummary_options : getRequestSummary_options);
        }
        if (this.is_AbortRequest) {
            String abortRequest_options = " srm-abort-request options: \n" + OptionParser.printOptions((Object)this, (String[])new String[]{"request_tokens"});
            return "\nUsage: srm-abort-request [command line options] srmUrl \n\n       default options can be set in configuration file \n       or overriden by the command line options\n       the command line options are one or more of the following:\n" + (this.isHelp() ? String.valueOf(general_options) + abortRequest_options : abortRequest_options);
        }
        if (this.is_AbortFiles) {
            String abortFiles_options = " srm-abort-files options : \n" + OptionParser.printOptions((Object)"request_tokens", (String[])new String[0]);
            return "\nUsage: srm-abort-files [command line options] srmUrl [[srmUrl]...] \n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + abortFiles_options : abortFiles_options);
        }
        if (this.is_ReleaseFiles) {
            String releaseFiles_options = " srm-release-files options : \n" + OptionParser.printOptions((Object)this, (String[])new String[]{"request_tokens", "do_remove"});
            return "\nUsage: srm-relese-files [command line options] srmUrl [[srmUrl]...] \n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + releaseFiles_options : releaseFiles_options);
        }
        if (this.is_getRequestTokens) {
            String getRequestTokens_options = " srm-get-request-tokens options :\n" + OptionParser.printOptions((Object)this, (String[])new String[]{"request_desc"});
            return "\nUsage: srm-get-request-tokens [command line options] srmUrl  \n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + getRequestTokens_options : getRequestTokens_options);
        }
        if (this.is_rmdir) {
            String rmdir_options = " srmrmdir options :\n" + OptionParser.printOptions((Object)this, (String[])new String[]{"recursive"}) + "\t\t -rmdir is defined in SRM specification as :\n" + "\t\t \"applies to dir doRecursiveRemove is false by edefault. To distinguish from \n" + "\t\t srmRm(), this function is for directories only. \"\n" + "\t\t so it is unclear id the directories must be empty. \n" + "\t\t We interpret \"rmdir\" as Unix \"rmdir\" which allows to remove only empty directories \n" + "\t\t extending it to have an ability to remove trees of empty directories. \n" + "\t\t Removal of multiple directories is not supported \n" + "\t\t Removal of files is not supported (use srmrm).\n";
            return "\nUsage: srmrmdir [command line options] srmUrl \n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + rmdir_options : rmdir_options);
        }
        if (this.is_mkdir) {
            return "\nUsage: srmmkdir [command line options] srmUrl \n\n       default options can be set in configuration file \n       or overriden by the command line options\n       the command line options are one or more of the following:\n" + (this.isHelp() ? String.valueOf(general_options) + this.mkdir_options : this.mkdir_options);
        }
        if (this.stage) {
            return "\nUsage: srmstage [command line options] srmUrl [[srmUrl]...] \n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + this.stage_options : this.stage_options);
        }
        if (this.getPermission) {
            return "\nUsage: srmgetpermission [command line options] srmUrl [[srmUrl]...] \n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + this.getPermission_options : this.getPermission_options);
        }
        if (this.checkPermission) {
            return "\nUsage: srmcheckpermission [command line options] srmUrl [[srmUrl]...] \n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + this.checkPermission_options : this.checkPermission_options);
        }
        if (this.setPermission) {
            String setPermission_options = " srm-set-permissions options : \n" + OptionParser.printOptions((Object)this, (String[])new String[]{"type", "owner", "other", "group"}) + this.printMandatoryOptions("type");
            return "\nUsage: srm-set-permissions [command line options] srmUrl [[srmUrl]...] \n\n       default options can be set in configuration file \n       or overriden by the command line options \n\n" + (this.isHelp() ? String.valueOf(general_options) + setPermission_options : setPermission_options);
        }
        if (this.extendFileLifetime) {
            String extendFileLifetime_options_string = " srm-extend-file-lifetime options :\n" + OptionParser.printOptions((Object)this, (String[])new String[]{"request_token", "file_lifetime", "pin_lifetime"});
            return "\nUsage: srm-extend-file-lifetime [command line options] srmUrl [[srmUrl]...] \n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + (this.isHelp() ? String.valueOf(general_options) + extendFileLifetime_options_string : extendFileLifetime_options_string);
        }
        if (this.ping) {
            return "\nUsage: srmping  [command line options] srmUrl \n\n       default options can be set in configuration file \n       or overriden by the command line options\n\n" + general_options;
        }
        return "Usage: srm [command option] [command line options] arguments\nwhere command option is one of the following :\n -copy                   performs srm \"get\", \"put\", or \"copy\" depending \n                         on arguments \n -bringOnline            performs srmBringOnline \n -stage                  performs srm \"get\", without actual copy of the files \n                         with the hope that this will trigger staging in srm managed\n                         hierarchical storage system\n -mv                     performs srm \"mv\" of files and directories \n -ls                     list content of directory \n -rm                     remove file(s) \n -mkdir                  create directory \n -rmdir                  remove empty directory tree \n -getPermissions\t      get file(s) permissions \n -checkPermissions\t      check file permissions \n -setPermissions\t      set file permissions \n -extendFileLietime      extend lifetime of existing SURL(s) pf volatile and durable files \n                         or pinned lifetime of TURL(s)\n -advisoryDelete         performs srm advisory delete \n -abortRequest           to abort request.  \n -abortFiles             to abort files.  \n -releaseFiles           to unpin files.  \n -getRequestStatus       obtains and prints srm request status \n -getRequestSummary      is to retrieve a summary of the previously submitted request.  \n -getGetRequestTokens    retrieves request tokens for the clients requests, given client provided request description.\n                         This is to accommodate lost request tokens. This can also be used for getting all request tokens.\n -getFileMetaData        gets srm meta data for specified surls\n -getSpaceTokens         gets space tokens belonging to this user\n                         which have a corresponding description (if provided)\n -getStorageElementInfo  prints storage element info, in particular\n                         it prints total, availabale and used space amount\n -reserveSpace           performs explicit space reservation \n -releaseSpace           performs release of explicit  space reservation \n -getSpaceMetaData       retrieves and prints metadata for given space tokens\n -ping                   performs srm ping command (useful for diagnostics and version info) \n -h,-help                prints this help\n type srm [command option] -h for more info about a particular option";
    }

    /*
     * Unable to fully structure code
     */
    public void parseArguments(String[] args) throws Exception {
        optionMap = OptionParser.getOptions((Object)this);
        sb = new StringBuilder();
        i = 0;
        while (i < args.length) {
            name = args[i];
            while (name.startsWith("-")) {
                name = name.substring(1);
            }
            if (optionMap.contains(name)) {
                sb.append(args[i]);
                if (++i >= args.length) break;
                value = args[i];
                if (value.startsWith("-")) {
                    if (value.equals("-1") || value.equals("-2")) {
                        sb.append(" ");
                        continue;
                    }
                    try {
                        Integer.parseInt(value);
                        sb.append("=").append(value).append(" ");
                        ++i;
                    }
                    catch (NumberFormatException nfe) {
                        sb.append(" ");
                    }
                    continue;
                }
                if (value.startsWith("=")) continue;
                if (!(value.startsWith("file:") || value.startsWith("srm:") || value.startsWith("gsiftp:") || value.startsWith("http"))) {
                    sb.append("=").append(value).append(" ");
                    ++i;
                    continue;
                }
                sb.append(" ");
                continue;
            }
            if (!args[i].endsWith("=")) {
                sb.append(args[i]).append(" ");
            } else {
                sb.append(args[i]);
            }
            ++i;
        }
        _args = new Args(sb.toString());
        OptionParser.setDefaults((Object)this);
        if (_args.getOpt("conf") != null) {
            OptionParser.parseOption((Object)this, (String)"conf", (Args)_args);
        } else {
            this.config_file = this.DEFAULT_CONFIG_FILE;
        }
        f = new File(this.config_file);
        if (f.exists() && f.canRead()) {
            this.read(this.config_file);
        } else if (_args.getOpt("conf") != null) {
            throw new IOException("specified configuratioin file \"" + this.config_file + "\" does not exist or can not be read");
        }
        OptionParser.parseSpecifiedOptions((Object)this, (Args)_args);
        this.extraParameters.put("priority", this.priority.toString());
        if (this.globus_tcp_port_range != null) {
            this.globus_tcp_port_range = this.globus_tcp_port_range.replace(':', ',');
        }
        if (this.is_help) {
            this.help = true;
        }
        if (this.retry_timeout <= 0L) {
            throw new IllegalArgumentException("illegal retry timeout : " + this.retry_timeout);
        }
        if (this.retry_num < 0) {
            throw new IllegalArgumentException("illegal number of retries : " + this.retry_num);
        }
        if (this.isSrmv1 && this.isSrmv2) {
            throw new IllegalArgumentException("only one option of -srm_protocol_version, -1 or -2 should be specified");
        }
        if ((this.isSrmv1 || this.isSrmv2) && _args.getOpt("srm_protocol_version") != null) {
            throw new IllegalArgumentException("only one option of -srm_protocol_version, -1 or -2 should be specified");
        }
        if (this.isSrmv1) {
            this.srm_protocol_version = 1;
        } else if (this.isSrmv2) {
            this.srm_protocol_version = 2;
        } else if (this.srm_protocol_version == 0) {
            this.srm_protocol_version = 2;
        }
        if (this.srm_protocol_version != 1 && this.srm_protocol_version != 2) {
            throw new IllegalArgumentException("illegal srm protocol version " + this.srm_protocol_version);
        }
        if (this.request_lifetime <= 0L && this.request_lifetime != -1L) {
            throw new IllegalArgumentException("illegal value for request lifetime" + this.request_lifetime);
        }
        if (this.version || this.debug) {
            this.logger.error(new Version().toString());
        }
        if (this.isHelp()) {
            return;
        }
        if (!(this.is_mv ^ this.is_mkdir ^ this.is_rmdir ^ this.is_rm ^ this.ls ^ this.copy ^ this.bringOnline ^ this.ping ^ this.getFileMetaData ^ this.advisoryDelete ^ this.getRequestStatus ^ this.stage ^ this.getPermission ^ this.checkPermission ^ this.setPermission ^ this.extendFileLifetime ^ this.releaseSpace ^ this.reserveSpace ^ this.getSpaceMetaData ^ this.getSpaceTokens ^ this.is_getRequestSummary ^ this.is_getRequestTokens ^ this.is_AbortRequest ^ this.is_AbortFiles ^ this.is_ReleaseFiles)) {
            throw new IllegalArgumentException("\n only one of the following options must be specified:\n\n" + this.usage());
        }
        numberOfArguments = _args.argc();
        if (numberOfArguments == 0 && this.copyjobfile == null) {
            throw new IllegalArgumentException("Please specify command line arguments\n" + this.usage());
        }
        this.surls = new String[numberOfArguments];
        i = 0;
        while (i < numberOfArguments) {
            this.surls[i] = _args.argv(i);
            ++i;
        }
        this.srmUrl = _args.argv(0);
        if (this.is_AbortRequest || this.reserveSpace || this.checkPermission || this.is_AbortFiles || this.is_rm || this.is_mv || this.setPermission || this.getSpaceTokens || this.is_ReleaseFiles || this.is_mkdir || this.getSpaceMetaData || this.ls || this.bringOnline || this.releaseSpace || this.extendFileLifetime || this.is_getRequestTokens || this.getPermission || this.is_getRequestSummary || this.is_rmdir) {
            this.srm_protocol_version = 2;
        }
        if (!this.getRequestStatus) ** GOTO lbl109
        if (numberOfArguments == 1) {
            this.getRequestStatusSurl = _args.argv(0);
        } else {
            throw new IllegalArgumentException("one and only one storage element info server wsdl url should be specified");
lbl109:
            // 1 sources

            if (this.is_getRequestTokens) {
                this.getRequestStatusSurl = _args.argv(0);
            } else if (this.is_getRequestSummary) {
                this.getRequestStatusSurl = _args.argv(0);
                this.arrayOfRequestTokens = this.readListOfOptions(this.requestTokens, ",");
            } else if (this.is_AbortRequest) {
                this.arrayOfRequestTokens = this.readListOfOptions(this.requestTokens, ",");
            } else if (this.is_AbortFiles || this.is_ReleaseFiles) {
                this.arrayOfRequestTokens = this.readListOfOptions(this.requestTokens, ",");
            } else if (this.releaseSpace) {
                OptionParser.checkNullOptions((Object)this, (String[])new String[]{"space_token"});
            } else if (this.reserveSpace) {
                this.protocols = this.readListOfOptions(this.protocols_list, ",");
                this.arrayOfClientNetworks = this.readListOfOptions(this.array_of_client_networks, ",");
                OptionParser.checkNullOptions((Object)this, (String[])new String[]{"retention_policy", "guaranteed_size"});
            } else if (this.getSpaceMetaData) {
                this.spaceTokensList = this.readListOfOptions(this.space_tokens_list, ",");
                OptionParser.checkNullOptions((Object)this, (String[])new String[]{"space_tokens"});
            } else if (this.copy || this.is_mv) {
                if (this.copy) {
                    this.readCopyOptions();
                }
                if (this.copyjobfile == null) {
                    if (numberOfArguments >= 2) {
                        if (this.is_mv && numberOfArguments > 2) {
                            throw new IllegalArgumentException("one source and one destination should be specified");
                        }
                        number_of_sources = numberOfArguments - 1;
                        this.from = new String[number_of_sources];
                        i = 0;
                        while (i < number_of_sources) {
                            this.from[i] = _args.argv(i);
                            ++i;
                        }
                        this.to = _args.argv(number_of_sources);
                    } else {
                        if (this.is_mv) {
                            throw new IllegalArgumentException("one source and one destination should be specified");
                        }
                        if (this.copy) {
                            throw new IllegalArgumentException("at least one source and one destination should be specified");
                        }
                    }
                } else if (numberOfArguments > 0) {
                    throw new IllegalArgumentException("no source or destination should be specified when using copyjobfile");
                }
            } else if (this.bringOnline) {
                this.protocols = this.readListOfOptions(this.protocols_list, ",");
            } else if (this.ping) {
                this.srmUrl = _args.argv(0);
            } else if (this.setPermission) {
                this.setPermissionSurl = _args.argv(0);
                OptionParser.checkNullOptions((Object)this, (String[])new String[]{"type"});
            }
        }
    }

    private void readCopyOptions() throws Exception {
        this.protocols = this.readListOfOptions(this.protocols_list, ",");
        this.arrayOfClientNetworks = this.readListOfOptions(this.array_of_client_networks, ",");
        if (this.spaceToken != null) {
            this.srm_protocol_version = 2;
        }
        this.readCksmOptions();
    }

    private String[] readListOfOptions(String option, String separator) throws Exception {
        String[] listOfOptions = null;
        if (option != null) {
            listOfOptions = option.split(separator);
        }
        return listOfOptions;
    }

    private void readCksmOptions() throws Exception {
        if (this.cksm_type == null && this.cksm_value != null) {
            this.cksm_type = "adler32";
        }
    }

    public void read(String file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(file);
        Node root = document.getFirstChild();
        while (root != null && !"srm-configuration".equals(root.getNodeName())) {
            root = document.getNextSibling();
        }
        if (root == null) {
            this.logger.error(" error, root element \"srm-configuration\" is not found");
            throw new IOException();
        }
        if (root != null && root.getNodeName().equals("srm-configuration")) {
            Node node = root.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    Node child = node.getFirstChild();
                    while (child != null) {
                        if (child.getNodeType() == 3) break;
                        child = node.getNextSibling();
                    }
                    if (child != null) {
                        Text t = (Text)child;
                        String node_name = node.getNodeName();
                        String text_value = t.getData().trim();
                        Class<?> c = this.getClass();
                        while (c != null) {
                            Field[] fieldArray = c.getDeclaredFields();
                            int n = fieldArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                block15: {
                                    Field field = fieldArray[n2];
                                    Option option = field.getAnnotation(Option.class);
                                    try {
                                        if (option == null || !option.name().equals(node_name) || !option.save()) break block15;
                                        field.setAccessible(true);
                                        try {
                                            Object value = OptionParser.toType((Object)text_value, field.getType());
                                            field.set(this, value);
                                        }
                                        catch (ClassCastException e) {
                                            throw new IllegalArgumentException("Cannot convert '" + text_value + "' to " + field.getType(), e);
                                        }
                                    }
                                    catch (SecurityException e) {
                                        throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                                    }
                                    catch (IllegalAccessException e) {
                                        throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                ++n2;
                            }
                            c = c.getSuperclass();
                        }
                    }
                }
                node = node.getNextSibling();
            }
        }
    }

    private static void put(Document document, Node root, String elem_name, String value, String comment_str) {
        Text t = document.createTextNode("\n\n\t");
        root.appendChild(t);
        Comment comment = document.createComment(comment_str);
        root.appendChild(comment);
        t = document.createTextNode("\n\t");
        root.appendChild(t);
        Element element = document.createElement(elem_name);
        t = document.createTextNode(" " + value + " ");
        element.appendChild(t);
        root.appendChild(element);
    }

    private String printMandatoryOptions(String ... names) {
        StringBuilder sb = new StringBuilder();
        sb.append("\nmandatory options : ");
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append("\"" + s + "\" ");
            ++n2;
        }
        return sb.toString();
    }

    public void write(String file) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        Element root = document.createElement("srm-configuration");
        Class<?> c = this.getClass();
        while (c != null) {
            Field[] fieldArray = c.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Option option = field.getAnnotation(Option.class);
                try {
                    if (option != null && option.save()) {
                        field.setAccessible(true);
                        Object value = field.get(this);
                        String svalue = "null";
                        if (value != null) {
                            svalue = value.toString();
                        }
                        String description = option.description();
                        String unit = option.unit();
                        if (description.length() == 0) {
                            description = option.name();
                        }
                        StringBuilder sb = new StringBuilder();
                        sb.append(description.replaceAll("\n", " "));
                        if (option.defaultValue().length() > 0) {
                            sb.append(", default is " + option.defaultValue());
                        }
                        if (unit.length() > 0) {
                            sb.append(" (" + unit + ")");
                        }
                        EMI_Configuration.put(document, root, option.name(), svalue, sb.toString());
                    }
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
        Text t = document.createTextNode("\n");
        root.appendChild(t);
        document.appendChild(root);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(new FileWriter(file));
        transformer.transform(source, result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SRM Configuration:");
        Class<?> c = this.getClass();
        while (c != null) {
            Field[] fieldArray = c.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Option option = field.getAnnotation(Option.class);
                try {
                    if (option != null && option.log()) {
                        field.setAccessible(true);
                        Object value = field.get(this);
                        sb.append("\n\t" + option.name() + "=" + value);
                    }
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
        if (this.getFileMetaData && this.surls != null) {
            sb.append("\n\taction is getFileMetaData");
            int i = 0;
            while (i < this.surls.length) {
                sb.append("\n\tsurl[" + i + "]=").append(this.surls[i]);
                ++i;
            }
        }
        if (this.getSpaceTokens && this.srmUrl != null) {
            sb.append("\n\taction is getSpacetokens");
            sb.append("\n\tsurl=").append(this.srmUrl);
        }
        if (this.getPermission && this.surls != null) {
            sb.append("\n\taction is getPermissions");
            int i = 0;
            while (i < this.surls.length) {
                sb.append("\n\tsurl[" + i + "]=").append(this.surls[i]);
                ++i;
            }
        }
        if (this.checkPermission && this.surls != null) {
            sb.append("\n\taction is checkPermissions");
            int i = 0;
            while (i < this.surls.length) {
                sb.append("\n\tsurl[" + i + "]=").append(this.surls[i]);
                ++i;
            }
        }
        if (this.setPermission && this.setPermissionSurl != null) {
            sb.append("\n\taction is setPermissions");
            sb.append("\n\tsur=").append(this.setPermissionSurl);
        }
        if (this.extendFileLifetime && this.surls != null) {
            sb.append("\n\taction is extendFileLifetime");
            int i = 0;
            while (i < this.surls.length) {
                sb.append("\n\tsurl[" + i + "]=").append(this.surls[i]);
                ++i;
            }
        }
        if (this.ls && this.surls != null) {
            sb.append("\n\taction is ls");
            int i = 0;
            while (i < this.surls.length) {
                sb.append("\n\tsurl[" + i + "]=").append(this.surls[i]);
                ++i;
            }
        }
        if (this.is_rm && this.surls != null) {
            sb.append("\n\taction is rm");
            int i = 0;
            while (i < this.surls.length) {
                sb.append("\n\tsurl[" + i + "]=").append(this.surls[i]);
                ++i;
            }
        }
        if (this.is_rmdir && this.surls != null) {
            sb.append("\n\taction is rmdir");
            int i = 0;
            while (i < this.surls.length) {
                sb.append("\n\tsurl[" + i + "]=").append(this.surls[i]);
                ++i;
            }
        }
        if (this.is_mkdir && this.surls != null) {
            sb.append("\n\taction is mkdir");
            int i = 0;
            while (i < this.surls.length) {
                sb.append("\n\tsurl[" + i + "]=").append(this.surls[i]);
                ++i;
            }
        }
        if (this.reserveSpace) {
            sb.append("\n\taction is reserveSpace");
            if (this.surls != null) {
                int i = 0;
                while (i < this.surls.length) {
                    sb.append("\n\tsrm url=").append(this.surls[i]);
                    ++i;
                }
            }
            sb.append("\n\tprotocols");
            int i = 0;
            while (i < this.protocols.length) {
                sb.append("\n\tprotocol[" + i + "]=").append(this.protocols[i]);
                ++i;
            }
            sb.append("\n\tarray of client networks:");
            if (this.arrayOfClientNetworks == null) {
                sb.append("\n\tnull");
            } else {
                i = 0;
                while (i < this.arrayOfClientNetworks.length) {
                    sb.append("\n\tnetwork[" + i + "]=").append(this.arrayOfClientNetworks[i]);
                    ++i;
                }
            }
        }
        if (this.releaseSpace) {
            sb.append("\n\taction is releaseSpace");
            if (this.surls != null) {
                int i = 0;
                while (i < this.surls.length) {
                    sb.append("\n\tsrm url=").append(this.surls[i]);
                    ++i;
                }
            }
        }
        if (this.getSpaceMetaData) {
            sb.append("\n\taction is getSpaceMetaData");
            if (this.getSpaceTokensList() != null) {
                int i = 0;
                while (i < this.getSpaceTokensList().length) {
                    sb.append("\n\tgetSpaceMetaDataToken =").append(this.getSpaceTokensList()[i]);
                    ++i;
                }
            }
        }
        if (this.from != null) {
            int i = 0;
            while (i < this.from.length) {
                sb.append("\n\tfrom[" + i + "]=").append(this.from[i]);
                ++i;
            }
        }
        if (this.to != null) {
            sb.append("\n\tto=").append(this.to).append('\n');
        }
        return sb.toString();
    }

    public String[] getFrom() {
        return this.from;
    }

    public void setFrom(String[] from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String[] getLsURLs() {
        return this.surls;
    }

    public void setLsURLs(String[] inURLs) {
        this.surls = inURLs;
    }

    public String[] getSurls() {
        return this.surls;
    }

    public void setSurls(String[] inURLs) {
        this.surls = inURLs;
    }

    public String[] getArrayOfRequestTokens() {
        return this.arrayOfRequestTokens;
    }

    public void setArrayOfRequestTokens(String[] tokens) {
        this.arrayOfRequestTokens = tokens;
    }

    public String[] getReserveSpaceURLs() {
        return this.surls;
    }

    public void setReserveSpaceURLs(String[] inURLs) {
        this.surls = inURLs;
    }

    public String[] getReleaseSpaceURLs() {
        return this.surls;
    }

    public void setReleaseSpaceURLs(String[] inURLs) {
        this.surls = inURLs;
    }

    public String[] getRmURLs() {
        return this.surls;
    }

    public String[] getRmdirURLs() {
        return this.surls;
    }

    public void setRmURLs(String[] inURLs) {
        this.surls = inURLs;
    }

    public String[] getMkDirURLs() {
        return this.surls;
    }

    public void setMkDirURLs(String[] inURLs) {
        this.surls = inURLs;
    }

    public void setRmdirURLs(String[] inURLs) {
        this.surls = inURLs;
    }

    public String[] getGetFileMetaDataSurls() {
        return this.surls;
    }

    public void setGetFileMetaDataSurls(String[] getFileMetaDataSurls) {
        this.surls = getFileMetaDataSurls;
    }

    public String[] getGetPermissionSurls() {
        return this.surls;
    }

    public String[] getCheckPermissionSurls() {
        return this.surls;
    }

    public String[] getExtendFileLifetimeSurls() {
        return this.surls;
    }

    public String getSetPermissionSurl() {
        return this.setPermissionSurl;
    }

    public void setGetPermissionSurls(String[] getPermissionSurls) {
        this.surls = getPermissionSurls;
    }

    public void setCheckPermissionSurls(String[] checkPermissionSurls) {
        this.surls = checkPermissionSurls;
    }

    public void setSetPermissionSurl(String setPermissionSurls) {
        this.setPermissionSurl = setPermissionSurls;
    }

    public void setExtendFileLifetimeSurls(String[] surls) {
        this.surls = surls;
    }

    public String[] getArrayOfClientNetworks() {
        return this.arrayOfClientNetworks;
    }

    public void setArrayOfClientNetworks(String[] a) {
        this.arrayOfClientNetworks = a;
    }

    public String[] getAdvisoryDeleteSurls() {
        return this.surls;
    }

    public void setAdvisoryDeleteSurls(String[] advisoryDeleteSurls) {
        this.surls = advisoryDeleteSurls;
    }

    public String getGetRequestStatusSurl() {
        return this.getRequestStatusSurl;
    }

    public void setGetRequestStatusSurl(String getRequestStatusSurl) {
        this.getRequestStatusSurl = getRequestStatusSurl;
    }

    public String[] getBringOnlineSurls() {
        return this.surls;
    }

    public void setBringOnlineSurls(String[] bringOnlineSurls) {
        this.surls = bringOnlineSurls;
    }

    public void setJobPriority(int p) {
        this.extraParameters.put("priority", Integer.toString(p));
    }

    public int getJobPriority() {
        return Integer.parseInt(this.extraParameters.get("priority"));
    }

    public Map<String, String> getExtraParameters() {
        return this.extraParameters;
    }

    public String[] getSpaceTokensList() {
        return this.spaceTokensList;
    }

    public void setSpaceTokensList(String[] spaceTokensList) {
        this.spaceTokensList = spaceTokensList;
    }

    public String getSrmUrl() {
        return this.srmUrl;
    }

    public void setSrmUrl(String srmUrl) {
        this.srmUrl = srmUrl;
    }
}

