/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.accounting.commons.utils;

import java.math.BigInteger;
import java.util.Date;
import java.util.HashSet;
import org.apache.xmlbeans.GDuration;
import org.gridforum.x2003.urWg.CpuDurationDocument;
import org.gridforum.x2003.urWg.HostDocument;
import org.gridforum.x2003.urWg.JobIdentityDocument;
import org.gridforum.x2003.urWg.MachineNameDocument;
import org.gridforum.x2003.urWg.MemoryDocument;
import org.gridforum.x2003.urWg.NodeCountDocument;
import org.gridforum.x2003.urWg.ProcessorsDocument;
import org.gridforum.x2003.urWg.ProjectNameDocument;
import org.gridforum.x2003.urWg.QueueDocument;
import org.gridforum.x2003.urWg.ResourceType;
import org.gridforum.x2003.urWg.StatusDocument;
import org.gridforum.x2003.urWg.StorageUnitAttribute;
import org.gridforum.x2003.urWg.SubmitHostDocument;
import org.gridforum.x2003.urWg.UsageRecordType;
import org.gridforum.x2003.urWg.UserIdentityDocument;
import org.gridforum.x2003.urWg.WallDurationDocument;
import pl.edu.icm.unicore.accounting.commons.utils.StringUtils;

public class UsageRecordExtractor {
    public static Long gDurationToSeconds(GDuration duration) {
        if (duration == null) {
            return null;
        }
        long time = 0L;
        time += (long)(duration.getYear() * 365 * 24 * 3600);
        time += (long)(duration.getMonth() * 30 * 24 * 3600);
        time += (long)(duration.getDay() * 24 * 3600);
        time += (long)(duration.getHour() * 3600);
        time += (long)(duration.getMinute() * 60);
        return time += (long)duration.getSecond();
    }

    public static Long getCpuTime(UsageRecordType ur) {
        CpuDurationDocument.CpuDuration[] cpuDurationArray = ur.getCpuDurationArray();
        if (cpuDurationArray != null && cpuDurationArray.length > 0) {
            CpuDurationDocument.CpuDuration cpuDuration = cpuDurationArray[0];
            return UsageRecordExtractor.gDurationToSeconds(cpuDuration.getGDurationValue());
        }
        return null;
    }

    public static String getGlobalJobId(UsageRecordType ur) {
        JobIdentityDocument.JobIdentity jobIdentity = ur.getJobIdentity();
        if (jobIdentity != null) {
            return jobIdentity.getGlobalJobId();
        }
        return null;
    }

    public static String getGlobalUserId(UsageRecordType ur) {
        UserIdentityDocument.UserIdentity[] userIdentityArray = ur.getUserIdentityArray();
        if (userIdentityArray.length > 0) {
            UserIdentityDocument.UserIdentity userIdentity = userIdentityArray[0];
            return userIdentity.getGlobalUserName();
        }
        return null;
    }

    public static String[] getHosts(UsageRecordType ur) {
        HostDocument.Host[] hostArray;
        HashSet<String> hosts = new HashSet<String>();
        for (HostDocument.Host host : hostArray = ur.getHostArray()) {
            hosts.add(host.getStringValue());
        }
        return hosts.toArray(new String[0]);
    }

    public static String getSubmitHost(UsageRecordType ur) {
        SubmitHostDocument.SubmitHost[] hostArray = ur.getSubmitHostArray();
        if (hostArray != null && hostArray.length > 0) {
            return hostArray[0].getStringValue();
        }
        return null;
    }

    public static String getLocalJobId(UsageRecordType ur) {
        JobIdentityDocument.JobIdentity jobIdentity = ur.getJobIdentity();
        if (jobIdentity != null) {
            return jobIdentity.getLocalJobId();
        }
        return null;
    }

    public static String getLocalUserId(UsageRecordType ur) {
        UserIdentityDocument.UserIdentity[] userIdentityArray = ur.getUserIdentityArray();
        if (userIdentityArray.length > 0) {
            UserIdentityDocument.UserIdentity userIdentity = userIdentityArray[0];
            return userIdentity.getLocalUserId();
        }
        return null;
    }

    public static String getMachineName(UsageRecordType ur) {
        MachineNameDocument.MachineName[] machineNameArray = ur.getMachineNameArray();
        if (machineNameArray.length > 0) {
            MachineNameDocument.MachineName machineName = machineNameArray[0];
            return machineName.getStringValue();
        }
        return null;
    }

    public static Long getMem(UsageRecordType ur) {
        MemoryDocument.Memory[] memoryArray;
        for (MemoryDocument.Memory memory : memoryArray = ur.getMemoryArray()) {
            if (!"physical".equals(memory.getType())) continue;
            return UsageRecordExtractor.getMemoryCommon(memory);
        }
        return 0L;
    }

    public static Date getStartTime(UsageRecordType ur) {
        if (ur.getStartTimeArray() != null && ur.getStartTimeArray().length > 0) {
            return ur.getStartTimeArray(0).getDateValue();
        }
        return null;
    }

    public static Date getEndTime(UsageRecordType ur) {
        if (ur.getEndTimeArray() != null && ur.getEndTimeArray().length > 0) {
            return ur.getStartTimeArray(0).getDateValue();
        }
        return null;
    }

    public static Long getNodeCont(UsageRecordType ur) {
        NodeCountDocument.NodeCount nodeCount;
        BigInteger bigIntegerValue;
        NodeCountDocument.NodeCount[] nodeCountArray = ur.getNodeCountArray();
        if (nodeCountArray.length > 0 && (bigIntegerValue = (nodeCount = nodeCountArray[0]).getBigIntegerValue()) != null) {
            return bigIntegerValue.longValue();
        }
        return 0L;
    }

    public static Long getProcessors(UsageRecordType ur) {
        ProcessorsDocument.Processors processors2;
        BigInteger bigIntegerValue;
        ProcessorsDocument.Processors[] processorsArray = ur.getProcessorsArray();
        if (processorsArray.length > 0 && (bigIntegerValue = (processors2 = processorsArray[0]).getBigIntegerValue()) != null) {
            return bigIntegerValue.longValue();
        }
        return 0L;
    }

    public static String getQueue(UsageRecordType ur) {
        QueueDocument.Queue[] queueArray = ur.getQueueArray();
        if (queueArray.length > 0) {
            QueueDocument.Queue queue = queueArray[0];
            return queue.getStringValue();
        }
        return null;
    }

    public static String getProject(UsageRecordType ur) {
        ProjectNameDocument.ProjectName[] projectArray = ur.getProjectNameArray();
        if (projectArray.length > 0) {
            ProjectNameDocument.ProjectName project = projectArray[0];
            return project.getStringValue();
        }
        return null;
    }

    public static String getStatus(UsageRecordType ur) {
        StatusDocument.Status status = ur.getStatus();
        if (status != null) {
            return status.getStringValue();
        }
        return null;
    }

    public static Long getVmem(UsageRecordType ur) {
        MemoryDocument.Memory[] memoryArray;
        for (MemoryDocument.Memory memory : memoryArray = ur.getMemoryArray()) {
            if (!"shared".equals(memory.getType())) continue;
            return UsageRecordExtractor.getMemoryCommon(memory);
        }
        return 0L;
    }

    public static Long getMemoryCommon(MemoryDocument.Memory memory) {
        BigInteger bigIntegerValue = memory.getBigIntegerValue();
        if (bigIntegerValue != null) {
            long longValue = bigIntegerValue.longValue();
            long multiply = UsageRecordExtractor.getSizeMultiplicator(memory.getStorageUnit());
            return longValue * multiply;
        }
        return 0L;
    }

    private static long getSizeMultiplicator(StorageUnitAttribute.StorageUnit.Enum storageUnit) {
        if (((Object)((Object)StorageUnitAttribute.StorageUnit.KB)).equals((Object)storageUnit)) {
            return 1L;
        }
        if (((Object)((Object)StorageUnitAttribute.StorageUnit.MB)).equals((Object)storageUnit)) {
            return 1024L;
        }
        if (((Object)((Object)StorageUnitAttribute.StorageUnit.GB)).equals((Object)storageUnit)) {
            return 0x100000L;
        }
        return 1L;
    }

    public static String getResourceByDesc(UsageRecordType ur, String description) {
        ResourceType[] resourceArray;
        for (ResourceType resource : resourceArray = ur.getResourceArray()) {
            if (!description.equals(resource.getDescription())) continue;
            return resource.getStringValue();
        }
        return null;
    }

    public static String getVo(UsageRecordType ur) {
        String voString = UsageRecordExtractor.getResourceByDesc(ur, "vo");
        if (voString != null && !StringUtils.isEmpty(voString)) {
            return voString;
        }
        return null;
    }

    public static String getSite(UsageRecordType ur) {
        String siteString = UsageRecordExtractor.getResourceByDesc(ur, "sitename");
        if (siteString != null && !StringUtils.isEmpty(siteString)) {
            return siteString;
        }
        return null;
    }

    public static Long getWallTime(UsageRecordType ur) {
        WallDurationDocument.WallDuration[] wallDurationArray = ur.getWallDurationArray();
        if (wallDurationArray.length > 0) {
            WallDurationDocument.WallDuration wallDuration = wallDurationArray[0];
            return UsageRecordExtractor.gDurationToSeconds(wallDuration.getGDurationValue());
        }
        return null;
    }

    public static String getRecordDesc(UsageRecordType ur) {
        String globalId = UsageRecordExtractor.getGlobalJobId(ur);
        String localId = UsageRecordExtractor.getLocalJobId(ur);
        String machineName = UsageRecordExtractor.getMachineName(ur);
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        if (globalId != null) {
            ret.append("GlobalJobId: ").append(globalId).append(" ");
        }
        if (localId != null) {
            ret.append("LocalJobId: ").append(localId).append(" ");
        }
        if (machineName != null) {
            ret.append("MachineName: ").append(machineName);
        }
        ret.append("]");
        return ret.toString();
    }
}

