/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.bencode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BEncoder {
    public static String bencode(Object o) throws IllegalArgumentException {
        try {
            StringBuilder sb = new StringBuilder();
            BEncoder.bencode(o, sb);
            return sb.toString();
        }
        catch (IOException ioe) {
            throw new InternalError(ioe.toString());
        }
    }

    public static void bencode(Object o, StringBuilder sb) throws IOException, IllegalArgumentException {
        if (o instanceof String) {
            BEncoder.bencode((String)o, sb);
        } else if (o instanceof Number) {
            BEncoder.bencode((Number)o, sb);
        } else if (o instanceof List) {
            BEncoder.bencode((List)o, sb);
        } else if (o instanceof Map) {
            BEncoder.bencode((Map)o, sb);
        } else {
            throw new IllegalArgumentException("Cannot bencode: " + o.getClass());
        }
    }

    public static String bencode(String s) {
        try {
            StringBuilder sb = new StringBuilder();
            BEncoder.bencode(s, sb);
            return sb.toString();
        }
        catch (IOException ioe) {
            throw new InternalError(ioe.toString());
        }
    }

    public static void bencode(String s, StringBuilder sb) throws IOException {
        sb.append(s.length());
        sb.append(":");
        sb.append(s);
    }

    public static String bencode(Number n) {
        try {
            StringBuilder sb = new StringBuilder();
            BEncoder.bencode(n, sb);
            return sb.toString();
        }
        catch (IOException ioe) {
            throw new InternalError(ioe.toString());
        }
    }

    public static void bencode(Number n, StringBuilder sb) throws IOException {
        sb.append('i');
        sb.append(n.toString());
        sb.append('e');
    }

    public static String bencode(List l) {
        try {
            StringBuilder sb = new StringBuilder();
            BEncoder.bencode(l, sb);
            return sb.toString();
        }
        catch (IOException ioe) {
            throw new InternalError(ioe.toString());
        }
    }

    public static void bencode(List l, StringBuilder sb) throws IOException {
        sb.append('l');
        Iterator it = l.iterator();
        while (it.hasNext()) {
            BEncoder.bencode(it.next(), sb);
        }
        sb.append('e');
    }

    public static String bencode(Map m) {
        try {
            StringBuilder sb = new StringBuilder();
            BEncoder.bencode(m, sb);
            return sb.toString();
        }
        catch (IOException ioe) {
            throw new InternalError(ioe.toString());
        }
    }

    public static void bencode(Map m, StringBuilder sb) throws IOException {
        sb.append('d');
        Set s = m.keySet();
        ArrayList l = new ArrayList(s);
        Collections.sort(l);
        for (String key : l) {
            Object value = m.get(key);
            BEncoder.bencode(key, sb);
            BEncoder.bencode(value, sb);
        }
        sb.append('e');
    }
}

