/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsapi.xmlbeans;

import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.exceptions.SAMLParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLAttributeProfile;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLDefaultAttributeProfile;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLEMIVOAttributeProfile;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLUVOSAttributeProfile;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UnsupportedSAMLException;
import xmlbeans.org.oasis.saml2.assertion.AttributeStatementType;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;

public class SAMLXMLBeansMapper {
    private static final SAMLAttributeProfile[] profileHandlers = new SAMLAttributeProfile[]{new SAMLUVOSAttributeProfile(), new SAMLEMIVOAttributeProfile(), new SAMLDefaultAttributeProfile()};

    public static List<Attribute> map2APIAttributes(AttributeType xmlAttr) throws UnsupportedSAMLException, SAMLParseException {
        SAMLAttributeProfile chosenHandler = null;
        int bestMatch = -1;
        for (SAMLAttributeProfile handler : profileHandlers) {
            int match = handler.isSupported(xmlAttr);
            if (match <= bestMatch) continue;
            bestMatch = match;
            chosenHandler = handler;
        }
        if (bestMatch > -1) {
            return chosenHandler.map(xmlAttr);
        }
        XmlObject[] xmlVals = xmlAttr.getAttributeValueArray();
        if (xmlVals != null && xmlVals.length > 0) {
            throw new UnsupportedSAMLException("Unknown type of attribute received " + xmlAttr.getName() + ", first value " + xmlVals[0].xmlText());
        }
        throw new UnsupportedSAMLException("Unknown type of attribute received " + xmlAttr.getName());
    }

    public static List<Attribute> convertSAMLAttributes2API(Assertion assertion) throws UnsupportedSAMLException, SAMLParseException {
        AttributeStatementType[] xmlAttrStatements;
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        if (assertion == null) {
            return ret;
        }
        for (AttributeStatementType xmlAttrStatement : xmlAttrStatements = assertion.getAttributes()) {
            AttributeType[] xmlAttrs;
            for (AttributeType xmlAttr : xmlAttrs = xmlAttrStatement.getAttributeArray()) {
                List<Attribute> attr = SAMLXMLBeansMapper.map2APIAttributes(xmlAttr);
                ret.addAll(attr);
            }
        }
        return ret;
    }

    public static Identity map2APIIdentity(NameIDType nameID) {
        IdentityType idT = new IdentityType(nameID.getFormat());
        Identity ret = new Identity(idT, nameID.getStringValue());
        return ret;
    }
}

