/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.idhelpers;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.exceptions.AuthenticationException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.idhelpers.GenericIdentityHelper;

public class EmailIdentityHelper
extends GenericIdentityHelper {
    public EmailIdentityHelper(Identity id) throws InvalidValueException {
        super(id);
        this.validate();
    }

    public void validate() throws InvalidValueException {
        if (this.identity == null || this.identity.getValue() == null) {
            throw new InvalidValueException("Null value.");
        }
        if (!this.identity.getType().equals(IdentityType.EMAIL)) {
            throw new InvalidValueException("Wrong type.");
        }
        String[] tokens = this.identity.getValue().split("@");
        if (tokens.length != 2) {
            throw new InvalidValueException("'@' must appear exactely once.");
        }
        if (tokens[0].equals("") || tokens[1].equals("")) {
            throw new InvalidValueException("Login and host can't be empty.");
        }
    }

    @Override
    public String getComparableValue() {
        return this.identity.getValue().toLowerCase();
    }

    @Override
    public String generateAuthNToken() throws AuthenticationException {
        if (!(this.identity.getAuthnData() instanceof String)) {
            throw new AuthenticationException();
        }
        if (this.getAuthNTokenEncode()) {
            return this.oneWay((String)this.identity.getAuthnData());
        }
        return (String)this.identity.getAuthnData();
    }

    @Override
    public void validateAuthNToken(String genuineToken) throws AuthenticationException {
        if (genuineToken == null) {
            if (this.identity.getAuthnData() != null) {
                throw new AuthenticationException();
            }
            return;
        }
        if (!(this.identity.getAuthnData() instanceof String)) {
            throw new AuthenticationException();
        }
        String h = this.oneWay((String)this.identity.getAuthnData());
        if (!h.equals(genuineToken)) {
            throw new AuthenticationException();
        }
    }

    private String oneWay(String arg) throws AuthenticationException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] protectedP = digest.digest(arg.getBytes("UTF8"));
            return new String(Base64.encodeBase64((byte[])protectedP));
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).fatal((Object)"Can't encrypt password!", (Throwable)e);
            throw new AuthenticationException();
        }
    }

    @Override
    public String toPrettyString() {
        return "[email] " + this.identity.getValue();
    }

    @Override
    public String toPrettyStringNoPrefix() {
        return this.identity.getValue();
    }

    @Override
    public List<Attribute> generateAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        AttributeType type = new AttributeType("mail");
        ArrayList<String> value = new ArrayList<String>();
        value.add(this.identity.getValue());
        attributes.add(new Attribute(type, value, null));
        return attributes;
    }
}

