/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.xuudb;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.ThreadingServices;
import de.fzj.unicore.wsrflite.utils.TimeoutRunner;
import eu.unicore.security.canl.IAuthnAndTrustConfiguration;
import eu.unicore.uas.security.xuudb.CredentialCache;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.ConnectionUtil;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class XUUDBAuthoriserBase {
    private static final Logger logger = Log.getLogger((String)"unicore.security", XUUDBAuthoriserBase.class);
    public static final int DEFAULT_PORT = 34463;
    public static final String DEFAULT_HOST = "https://localhost";
    protected String name;
    protected boolean isEnabled = false;
    protected Integer port;
    protected String host;
    protected Boolean cacheCredentials = Boolean.TRUE;
    protected Kernel kernel;
    protected String xuudbURL = null;
    protected String gcID;
    protected CredentialCache cache;
    protected int total_auth = 0;
    protected int cache_hits = 0;
    protected float mean_access_time = 0.0f;
    private Set<String> accessorNames = new HashSet<String>();

    public Integer getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getGcID() {
        return this.gcID;
    }

    protected void configure(String name) {
        this.name = name;
        if (this.port == null) {
            this.port = 34463;
        }
        if (this.host == null) {
            this.host = DEFAULT_HOST;
        }
        this.xuudbURL = this.host + ":" + this.port + "/";
        logger.info((Object)(this.getServiceName() + " attribute source '" + name + "': connecting to " + this.getServiceName() + " at <" + this.xuudbURL + ">"));
        if (this.cacheCredentials.booleanValue()) {
            logger.debug((Object)(this.getServiceName() + " " + name + " will cache credentials."));
        }
        this.initCache();
    }

    public void setXuudbPort(int port) {
        this.port = port;
    }

    public void setXuudbHost(String host) {
        this.host = host;
    }

    public void setXuudbGCID(String gcID) {
        this.gcID = gcID;
    }

    public void setXuudbCache(boolean cache) {
        this.cacheCredentials = cache;
    }

    protected String getXUUDBUrl() {
        return this.xuudbURL;
    }

    protected void initCache() {
        this.cache = new CredentialCache();
    }

    protected boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public int getTotalAuthorisationRequests() {
        return this.total_auth;
    }

    public int getCacheHits() {
        return this.cache_hits;
    }

    public String[] getRequestorNames() {
        return this.accessorNames.toArray(new String[this.accessorNames.size()]);
    }

    public void clearRequestorNames() {
        this.accessorNames.clear();
    }

    public void addAccessorName(String name) {
        boolean newEntry = this.accessorNames.add(name);
        if (newEntry) {
            logger.info((Object)("New client: " + name));
        }
    }

    public void clearCache() {
        this.cache.removeAll();
    }

    public void publishTime(long time) {
        this.mean_access_time = (this.mean_access_time * (float)(this.total_auth - 1) + (float)time) / (float)this.total_auth;
    }

    public float getMeanAccessTime() {
        return this.mean_access_time;
    }

    public boolean getCachingCredentials() {
        return this.cacheCredentials;
    }

    public void toggleCachingCredentials() {
        this.cacheCredentials = this.cacheCredentials == false;
    }

    public String getXUUDBConnectionStatus() {
        if (!this.isEnabled) {
            return "No " + this.getServiceName() + " configured";
        }
        Callable<X509Certificate[]> getCert = new Callable<X509Certificate[]>(){

            @Override
            public X509Certificate[] call() throws Exception {
                return ConnectionUtil.getPeerCertificate((IAuthnAndTrustConfiguration)XUUDBAuthoriserBase.this.kernel.getClientConfiguration(), (String)XUUDBAuthoriserBase.this.getXUUDBUrl(), (int)5000, (Logger)logger);
            }
        };
        ThreadingServices ts = this.kernel.getContainerProperties().getThreadingServices();
        if (TimeoutRunner.compute((Callable)getCert, (ThreadingServices)ts, (int)2000) != null) {
            return this.getServiceName() + " Attribute Source OK [" + this.name + " connected to " + this.getXUUDBUrl() + "]";
        }
        return "CAN'T CONNECT TO XUUDB";
    }

    public String getStatusDescription() {
        return this.getXUUDBConnectionStatus();
    }

    public void clearStatistics() {
        this.total_auth = 0;
        this.mean_access_time = 0.0f;
        this.cache_hits = 0;
        this.accessorNames.clear();
    }

    public String getName() {
        return this.name;
    }

    public String getServiceName() {
        return "XUUDB";
    }

    public int getCacheSize() {
        return this.cache.getCache().getSize();
    }
}

