/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.vo.conf;

import eu.unicore.uas.security.vo.conf.BaseConfigurationHelper;
import eu.unicore.uas.security.vo.conf.IPullConfiguration;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOQueryClient;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SecuritySetupException;

public class PullConfigurationHelper
extends BaseConfigurationHelper {
    private static final Logger log = Log.getLogger((String)"unicore.security.vo.pull", PullConfigurationHelper.class);
    private boolean isPullEnabled = false;
    private boolean isTDEnabled;
    private boolean isPullDisabledUponPush;
    private IPullConfiguration conf;
    private String addr;
    private URI serverId;
    private IClientConfiguration clientCfg;
    private boolean checkSignatures;

    public PullConfigurationHelper(IPullConfiguration config, IClientConfiguration clientCfg) throws Exception {
        super(config);
        this.conf = config;
        this.clientCfg = clientCfg;
        this.initializePull();
    }

    private void initializePull() throws Exception {
        this.addr = this.getVOServiceAddress();
        try {
            boolean enable = this.conf.isPullEnabled();
            if (!enable) {
                this.isPullEnabled = false;
                log.info((Object)"VO PULL authorization is disabled.");
                return;
            }
            this.serverId = this.getServerURI();
            new SAMLVOQueryClient(this.addr, this.clientCfg, this.serverId);
            this.checkSignatureVerificationConfig();
            this.initPullVars();
            this.isPullEnabled = true;
            log.info((Object)("VO PULL authorization is enabled. Will use VO service with address: " + this.addr));
        }
        catch (Exception e) {
            this.isPullEnabled = false;
            log.error((Object)(e.getMessage() + "\nPULL mode authorization will be disabled"));
            throw e;
        }
    }

    private URI getServerURI() throws Exception {
        String serverURIS = this.conf.getServerURI();
        if (serverURIS == null) {
            this.isPullEnabled = false;
            throw new Exception("Local server URI is undefined.");
        }
        try {
            return new URI(serverURIS);
        }
        catch (URISyntaxException e) {
            this.isPullEnabled = false;
            throw new Exception("Value of server URI (" + serverURIS + ") is not a valid URI.");
        }
    }

    private void initPullVars() {
        this.isTDEnabled = this.conf.enableTD();
        this.isPullDisabledUponPush = this.conf.disableIfAttributesWerePushed();
    }

    public String getVOServiceAddress() {
        return PullConfigurationHelper.getVOServiceAddress(this.conf.getVOServiceHost(), this.conf.getVOServicePort(), this.conf.getVOServicePath());
    }

    public static String getVOServiceAddress(String host, int port, String path) {
        return "https://" + host + ":" + port + path;
    }

    private void checkSignatureVerificationConfig() throws Exception {
        this.checkSignatures = this.conf.isPulledSignatureVerficationEnabled();
        if (!this.checkSignatures) {
            log.info((Object)"Signature of assertions received from VO server won't be checked.");
            return;
        }
        log.info((Object)"Will do signature verification of assertions received from VO server.");
    }

    public boolean isPullEnabled() {
        return this.isPullEnabled;
    }

    public SAMLVOQueryClient createClient() throws MalformedURLException, SecuritySetupException {
        SAMLVOQueryClient client = new SAMLVOQueryClient(this.addr, this.clientCfg, this.serverId);
        client.setDSigPolicy(false, this.checkSignatures, this.clientCfg.getCredential(), this.conf.getAssertionIssuerValidator());
        return client;
    }

    public boolean isPulledTDEnabled() {
        return this.isTDEnabled;
    }

    public boolean isUseGenericAttributes() {
        return this.conf.isPulledGenericAttributesEnabled();
    }

    public int getChacheTtl() {
        return this.conf.getChacheTtl();
    }

    public boolean isPullDisabledWhenAssertionPushed() {
        return this.isPullDisabledUponPush;
    }

    public IClientConfiguration getClientConfiguration() {
        return this.clientCfg;
    }
}

