/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.vo;

import eu.unicore.uas.security.vo.UnicoreAttributeMappingDef;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Group;

public class VOCommonUtils {
    public static final UnicoreAttributeMappingDef[] mappings = new UnicoreAttributeMappingDef[]{new UnicoreAttributeMappingDef("xlogin", false, true), new UnicoreAttributeMappingDef("role", false, true), new UnicoreAttributeMappingDef("group", false, false), new UnicoreAttributeMappingDef("supplementaryGroups", true, false), new UnicoreAttributeMappingDef("addDefaultGroups", false, false), new UnicoreAttributeMappingDef("queue", false, true), new UnicoreAttributeMappingDef("virtualOrganisations", true, true)};
    public static final String PREFIX = "vo.unicoreAttribute.";

    public static String handlePreferredVo(String[] preferredVos, String ourScope, String previouslySetVo) {
        Group our = new Group(ourScope);
        if (preferredVos == null) {
            return null;
        }
        for (int i = 0; i < preferredVos.length; ++i) {
            Group preferred = new Group(preferredVos[i]);
            if (preferred.isChild(our)) {
                return preferredVos[i];
            }
            if (previouslySetVo == null || !previouslySetVo.equals(preferredVos[i])) continue;
            return null;
        }
        return null;
    }

    public static UnicoreAttributeMappingDef[] fillMappings(Properties conf, UnicoreAttributeMappingDef[] rawList, Logger log) {
        StringBuilder allKnown = new StringBuilder();
        for (UnicoreAttributeMappingDef mapp : rawList) {
            allKnown.append(mapp.getUnicoreName() + " ");
        }
        HashMap<String, UnicoreAttributeMappingDef> result = new HashMap<String, UnicoreAttributeMappingDef>();
        for (Map.Entry<Object, Object> e : conf.entrySet()) {
            int i;
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            if (!key.startsWith(PREFIX)) continue;
            String key2 = key.substring(PREFIX.length());
            if (key2.length() == 0) {
                log.warn((Object)("Invalid configuration option: " + key));
                continue;
            }
            String[] elems = key2.split("\\.");
            for (i = 0; i < rawList.length && !rawList[i].getUnicoreName().equalsIgnoreCase(elems[0]); ++i) {
            }
            if (i == rawList.length) {
                log.warn((Object)("Unknown UNICORE attribute '" + elems[0] + "' was used. Known are: " + allKnown));
                continue;
            }
            if (elems.length == 1) {
                if (val.isEmpty()) {
                    log.warn((Object)("Definition of UNICORE attribute '" + elems[0] + "' must have a value (SAML name)."));
                    continue;
                }
                VOCommonUtils.addMapping(result, rawList[i]).setSamlName(val);
                continue;
            }
            if (elems.length > 2) {
                log.warn((Object)("Invalid configuration entry: " + key));
                continue;
            }
            if (elems[1].equals("default")) {
                if (val.isEmpty()) {
                    log.warn((Object)("Definition of a default for UNICORE attribute '" + elems[0] + "' must have a value (SAML name)."));
                    continue;
                }
                VOCommonUtils.addMapping(result, rawList[i]).setDefSamlName(val);
                continue;
            }
            if (elems[1].equals("disabled")) {
                log.info((Object)("Attribute " + elems[0] + " won't be used in incarnation."));
                UnicoreAttributeMappingDef mapping = VOCommonUtils.addMapping(result, rawList[i]);
                mapping.setDisabledInPull(true);
                mapping.setDisabledInPush(true);
                continue;
            }
            if (elems[1].equals("pullDisabled")) {
                log.info((Object)("Pulled attribute " + elems[0] + " won't be used in incarnation."));
                VOCommonUtils.addMapping(result, rawList[i]).setDisabledInPull(true);
                continue;
            }
            if (!elems[1].equals("pushDisabled")) continue;
            log.info((Object)("Pushed attribute " + elems[0] + " won't be used in incarnation."));
            VOCommonUtils.addMapping(result, rawList[i]).setDisabledInPush(true);
        }
        return result.values().toArray(new UnicoreAttributeMappingDef[result.size()]);
    }

    private static UnicoreAttributeMappingDef addMapping(Map<String, UnicoreAttributeMappingDef> result, UnicoreAttributeMappingDef raw) {
        UnicoreAttributeMappingDef r = result.get(raw.getUnicoreName());
        if (r == null) {
            r = new UnicoreAttributeMappingDef(raw.getUnicoreName(), raw.isMultiVal(), raw.isNonZeroVal());
            result.put(raw.getUnicoreName(), r);
        }
        return r;
    }

    public static String createMappingsDesc(UnicoreAttributeMappingDef[] mappings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mappings.length; ++i) {
            sb.append(VOCommonUtils.createMappingDesc(mappings[i]));
            if (i >= mappings.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String createMappingDesc(UnicoreAttributeMappingDef mapping) {
        StringBuilder sb = new StringBuilder();
        sb.append("UNICORE attribute mapping: ");
        sb.append(mapping.getUnicoreName());
        sb.append(" <- (");
        if (mapping.getSamlName() != null) {
            sb.append("saml valid: ");
            sb.append(mapping.getSamlName());
            sb.append(" ");
        }
        if (mapping.getDefSamlName() != null) {
            sb.append("saml default: ");
            sb.append(mapping.getDefSamlName());
        }
        sb.append(")");
        if (mapping.isDisabledInPull()) {
            sb.append(" [disabled when pulling]");
        }
        if (mapping.isDisabledInPush()) {
            sb.append(" [disabled for pushed]");
        }
        return sb.toString();
    }
}

