/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.vo;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.unicore.samly2.exceptions.SAMLParseException;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.UnicoreSecurityFactory;
import eu.unicore.security.etd.ETDApi;
import eu.unicore.security.etd.TrustDelegation;
import eu.unicore.security.xfireutil.client.ClientTrustDelegationUtil;
import eu.unicore.uas.security.vo.conf.IPullConfiguration;
import eu.unicore.uas.security.vo.conf.PullConfigurationHelper;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityHelperFactory;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityTypeHelper;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UnsupportedSAMLException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.InvalidSignatureException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.InvocationException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLErrorResponseException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOQueryClient;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SecuritySetupException;

public class VOAttributeFetcher {
    public static final String ALL_PULLED_ATTRS_KEY = "SAMLPullAuthoriser_ALLpulledattrs";
    private static final Logger log = Log.getLogger((String)"unicore.security.vo.pull", VOAttributeFetcher.class);
    private boolean isEnabled;
    private PullConfigurationHelper pullConfigurationHelper;
    private boolean tdEnabled;
    private boolean disableIfPushed;
    private int cacheTtl;
    private String myDN;
    private CacheManager cacheMan;
    private static int counterForEhCache = 0;
    private static final String UNSCOPED_CACHE = VOAttributeFetcher.class.getName() + ".unscoped";
    public static final int MAX_ELEMS = 128;

    public VOAttributeFetcher(IPullConfiguration cc, IClientConfiguration secProv) throws Exception {
        this.pullConfigurationHelper = new PullConfigurationHelper(cc, secProv);
        this.isEnabled = this.pullConfigurationHelper.isPullEnabled();
        if (!this.isEnabled) {
            return;
        }
        this.cacheTtl = this.pullConfigurationHelper.getChacheTtl();
        this.tdEnabled = this.pullConfigurationHelper.isPulledTDEnabled();
        this.disableIfPushed = this.pullConfigurationHelper.isPullDisabledWhenAssertionPushed();
        this.initCache();
        this.myDN = secProv.getCredential().getCertificate().getSubjectX500Principal().getName();
    }

    private void initCache() {
        if (this.cacheTtl > 0) {
            Configuration cmCfg = new Configuration();
            CacheConfiguration def = new CacheConfiguration();
            def.setDiskPersistent(false);
            def.setEternal(false);
            def.setOverflowToDisk(false);
            def.setMaxElementsInMemory(128);
            def.setMemoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.LFU.toString());
            def.setTimeToIdleSeconds((long)this.cacheTtl);
            def.setTimeToIdleSeconds((long)this.cacheTtl);
            def.setDiskExpiryThreadIntervalSeconds(240L);
            cmCfg.addDefaultCache(def);
            DiskStoreConfiguration dsCfg = new DiskStoreConfiguration();
            dsCfg.setPath(System.getProperty("java.io.tmpdir") + File.separator + counterForEhCache++ + "-" + new Random().nextLong());
            cmCfg.addDiskStore(dsCfg);
            this.cacheMan = new CacheManager(cmCfg);
            Cache unscopedCache = new Cache(UNSCOPED_CACHE, 128, MemoryStoreEvictionPolicy.LFU, false, null, false, (long)this.cacheTtl, (long)this.cacheTtl, false, 240L, null);
            this.cacheMan.addCache(unscopedCache);
        }
    }

    public void authorise(SecurityTokens tokens) throws IOException {
        List pushedAssertions;
        if (!this.isEnabled) {
            return;
        }
        Map context = tokens.getContext();
        if (this.disableIfPushed && (pushedAssertions = (List)context.get("SAMLPushedassertions")) != null && pushedAssertions.size() > 0) {
            log.debug((Object)"Skipping fetching of attributes as client pushed some.");
            return;
        }
        if (tokens.getEffectiveUserName() == null) {
            throw new IllegalStateException("Can't authorize unknown user!");
        }
        String dn = tokens.getEffectiveUserName().getName();
        Identity subject = new Identity(IdentityType.DN, dn);
        try {
            this.getAttributes(subject, tokens);
        }
        catch (Exception e) {
            throw new IOException("Unable to retrieve attributes from remote SAML service: " + e.toString(), e);
        }
    }

    private void getAttributes(Identity subject, SecurityTokens tokens) throws Exception {
        List<Attribute> attrs;
        String voServerAddress = this.pullConfigurationHelper.getVOServiceAddress();
        HashMap<String, List<Attribute>> allAttributes = (HashMap<String, List<Attribute>>)tokens.getContext().get(ALL_PULLED_ATTRS_KEY);
        if (allAttributes == null) {
            allAttributes = new HashMap<String, List<Attribute>>();
            tokens.getContext().put(ALL_PULLED_ATTRS_KEY, allAttributes);
        }
        if (allAttributes.get(voServerAddress) != null) {
            return;
        }
        try {
            if (this.cacheTtl > 0) {
                IdentityTypeHelper subjectHelper;
                Cache c = this.cacheMan.getCache(UNSCOPED_CACHE);
                Element e = c.get((Serializable)((Object)(subjectHelper = IdentityHelperFactory.getHelper((Identity)subject)).getComparableValue()));
                if (e != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Returning cached attributes for " + subject));
                    }
                    List cachedA = (List)((Object)e.getValue());
                    attrs = new ArrayList<Attribute>(cachedA.size());
                    attrs.addAll(cachedA);
                } else {
                    attrs = this.doRealReceive(subject, tokens);
                    ArrayList<Attribute> cachedAttrs = new ArrayList<Attribute>(attrs.size());
                    cachedAttrs.addAll(attrs);
                    c.put(new Element((Object)subjectHelper.getComparableValue(), cachedAttrs));
                }
            } else {
                attrs = this.doRealReceive(subject, tokens);
            }
        }
        catch (SAMLParseException e) {
            log.error((Object)("Attributes were pulled from the VO server but are unparseable: " + (Object)((Object)e)));
            throw e;
        }
        catch (UnsupportedSAMLException e) {
            log.error((Object)("Attributes were pulled from the VO server but SAML version/profile used by the server is unsupported: " + (Object)((Object)e)));
            throw e;
        }
        catch (InvalidSignatureException e) {
            log.error((Object)("Signature verification failed of attributes received from the VO server: " + (Object)((Object)e)));
            throw e;
        }
        catch (InvocationException e) {
            log.error((Object)("Couldn't perform server query: " + (Object)((Object)e)));
            throw e;
        }
        catch (SAMLErrorResponseException e) {
            if ("urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipial".equals(e.getSubStatus())) {
                log.debug((Object)("The user " + subject.prettyStringNoPrefix() + " is not recognized by the VO server"));
            } else if ("urn:oasis:names:tc:SAML:2.0:status:AuthnFailed".equals(e.getSubStatus())) {
                if (this.tdEnabled) {
                    log.debug((Object)"Can't authenticate to the VO server as the user - it is not recognized by the VO server.");
                } else {
                    log.error((Object)"Can't authenticate to the VO server as the local server - probably the local server doesn't have the read access to the VO server.");
                }
            } else {
                log.error((Object)("SAML error occured during VO server query: " + (Object)((Object)e)));
            }
            throw e;
        }
        if (attrs.size() == 0) {
            log.debug((Object)"Got empty list of attributes from the VO service");
            throw new Exception();
        }
        allAttributes.put(voServerAddress, attrs);
    }

    protected List<Attribute> doRealReceive(Identity subject, SecurityTokens tokens) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException, MalformedURLException, SecuritySetupException {
        SAMLVOQueryClient client = this.pullConfigurationHelper.createClient();
        List td = tokens.getTrustDelegationTokens();
        if (this.tdEnabled && td != null && td.size() > 0 && this.isTDForMe(td)) {
            log.debug((Object)"Adding TD tokens for call to VO service");
            Object proxy = client.getProxy();
            ClientTrustDelegationUtil.addTrustDelegation((Object)proxy, (List)td);
        }
        log.debug((Object)("Performing SAML query for attributes of " + subject.getValue()));
        return client.getAttributes(subject);
    }

    protected boolean isTDForMe(List<TrustDelegation> td) {
        ETDApi etdEngine = UnicoreSecurityFactory.getETDEngine();
        TrustDelegation first = td.get(0);
        if (first == null) {
            return false;
        }
        return etdEngine.isTrustDelegated(td, this.myDN, first.getCustodianDN(), (X509CertChainValidator)this.pullConfigurationHelper.getClientConfiguration().getValidator()).isValid();
    }
}

