/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.vo;

import eu.unicore.uas.security.vo.UnicoreAttributeMappingDef;
import eu.unicore.uas.security.vo.UnicoreIncarnationAttributes;
import eu.unicore.uas.security.vo.conf.IBaseVOConfiguration;
import eu.unicore.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Attribute;

public class UnicoreAttributesHandler {
    private static final Logger log = Log.getLogger((String)"unicore.security.vocommon", UnicoreAttributesHandler.class);
    protected final Map<String, UnicoreAttributeMappingDef> mappings;
    protected final Map<String, UnicoreAttributeMappingDef> mappingsUnicore;
    protected final String uudbScope;

    public UnicoreAttributesHandler(IBaseVOConfiguration c, UnicoreAttributeMappingDef[] mappings, boolean pushMode) {
        this.uudbScope = c.getScope();
        this.mappings = new HashMap<String, UnicoreAttributeMappingDef>();
        this.mappingsUnicore = new HashMap<String, UnicoreAttributeMappingDef>();
        for (UnicoreAttributeMappingDef mapping : mappings) {
            if (mapping.getSamlName() == null && mapping.getDefSamlName() == null || pushMode && mapping.isDisabledInPush() || !pushMode && mapping.isDisabledInPull()) continue;
            if (mapping.getSamlName() != null) {
                this.mappings.put(mapping.getSamlName(), mapping);
            }
            if (mapping.getDefSamlName() != null) {
                this.mappings.put(mapping.getDefSamlName(), mapping);
            }
            this.mappingsUnicore.put(mapping.getUnicoreName(), mapping);
        }
    }

    public UnicoreIncarnationAttributes extractUnicoreAttributes(List<Attribute> from, String selectedVo, boolean remove) {
        HashMap<String, List<String>> retValid = new HashMap<String, List<String>>();
        HashMap<String, List<String>> retDefault = new HashMap<String, List<String>>();
        HashMap<String, List<String>> retVoValid = new HashMap<String, List<String>>();
        HashMap<String, List<String>> retVoDefault = new HashMap<String, List<String>>();
        for (int i = from.size() - 1; i >= 0; --i) {
            boolean isDefault;
            Attribute a = from.get(i);
            UnicoreAttributeMappingDef mapping = this.mappings.get(a.getName());
            if (mapping == null) continue;
            if (remove) {
                from.remove(i);
            }
            if (!(a.getScope() == null || a.equalScope(this.uudbScope) || selectedVo != null && a.equalScope(selectedVo))) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(a.getName() + " attribute (used for UNICORE " + mapping.getUnicoreName() + ") received but in " + "unwanted scope, ignoring. The scope is: " + a.getScope() + " and 1st value is: " + (a.getValues().size() > 0 ? (String)a.getValues().get(0) : "<NONE>")));
                continue;
            }
            if (mapping.isNonZeroVal() && a.getValues().size() == 0) {
                log.debug((Object)(a.getName() + " attribute (used for UNICORE " + mapping.getUnicoreName() + ") received but without a value, ignoring."));
                continue;
            }
            boolean isVo = selectedVo != null && a.equalScope(selectedVo);
            boolean bl = isDefault = mapping.getDefSamlName() != null && mapping.getDefSamlName().equals(a.getName());
            if (a.getValues().size() > 1 && isDefault && !mapping.isMultiVal()) {
                log.warn((Object)(a.getName() + " default attribute (used for UNICORE " + mapping.getUnicoreName() + ") received with multiple values (it should have one, will use a random one!)."));
            }
            if (mapping.getSamlName() != null && mapping.getSamlName().equals(a.getName())) {
                if (a.getScope() == null || a.equalScope(this.uudbScope)) {
                    this.addValid(a, mapping, retValid, false);
                }
                if (!isVo) continue;
                this.addValid(a, mapping, retVoValid, true);
                continue;
            }
            if (mapping.getDefSamlName() == null || !mapping.getDefSamlName().equals(a.getName())) continue;
            if (a.getScope() == null || a.equalScope(this.uudbScope)) {
                this.addDefault(a, mapping, retDefault, false);
            }
            if (!isVo) continue;
            this.addDefault(a, mapping, retVoDefault, true);
        }
        this.updateValid(retValid, retDefault);
        this.updateDefault(retValid, retDefault);
        this.updateDefault(retVoValid, retVoDefault);
        UnicoreIncarnationAttributes ret = new UnicoreIncarnationAttributes();
        ret.setFromLists(retValid, retDefault, retVoDefault);
        return ret;
    }

    private void addValid(Attribute a, UnicoreAttributeMappingDef mapping, Map<String, List<String>> ret, boolean isVo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + a.getName() + " attribute (used as a valid definition for UNICORE " + mapping.getUnicoreName() + (isVo ? " in preferred VO" : "") + "). The 1st value is: " + (a.getValues().size() > 0 ? (String)a.getValues().get(0) : "<NONE>")));
        }
        ret.put(mapping.getUnicoreName(), a.getValues());
    }

    private void addDefault(Attribute a, UnicoreAttributeMappingDef mapping, Map<String, List<String>> ret, boolean isVo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + a.getName() + " attribute (used as default for UNICORE " + mapping.getUnicoreName() + (isVo ? " in preferred VO" : "") + "). The 1st value is: " + (a.getValues().size() > 0 ? (String)a.getValues().get(0) : "<NONE>")));
        }
        if (mapping.isMultiVal()) {
            ret.put(mapping.getUnicoreName(), a.getValues());
        } else {
            ArrayList toAdd = new ArrayList();
            if (a.getValues().size() > 0) {
                toAdd.add(a.getValues().get(0));
            }
            ret.put(mapping.getUnicoreName(), toAdd);
        }
    }

    private void updateValid(Map<String, List<String>> retValid, Map<String, List<String>> retDefault) {
        for (String defAttr : retDefault.keySet()) {
            List<String> currentDef = retDefault.get(defAttr);
            List<String> currentValid = retValid.get(defAttr);
            if (currentValid == null) {
                retValid.put(defAttr, currentDef);
                continue;
            }
            for (String defA : currentDef) {
                if (currentValid.contains(defA)) continue;
                currentValid.add(defA);
            }
        }
    }

    private void updateDefault(Map<String, List<String>> retValid, Map<String, List<String>> retDefault) {
        for (String validAttr : retValid.keySet()) {
            List<String> currentDef = retDefault.get(validAttr);
            List<String> currentValid = retValid.get(validAttr);
            if (currentDef != null || currentValid.size() <= 0) continue;
            currentDef = new ArrayList<String>();
            UnicoreAttributeMappingDef mapping = this.mappingsUnicore.get(validAttr);
            if (mapping.isMultiVal()) {
                currentDef.addAll(currentValid);
                log.debug((Object)("Using all valid values as default values for attribute " + validAttr));
            } else if (mapping.isNonZeroVal()) {
                String first = currentValid.get(0);
                currentDef.add(first);
                boolean different = false;
                for (int i = 1; i < currentValid.size(); ++i) {
                    if (first.equals(currentValid.get(i))) continue;
                    different = true;
                    break;
                }
                if (different) {
                    log.info((Object)("Using the first valid attribute value as a default value for attribute " + validAttr + ", all values are: " + currentValid.toString()));
                } else {
                    log.debug((Object)("Using the only one valid attribute value as a default value for attribute " + validAttr + ", value is: " + first));
                }
            }
            retDefault.put(validAttr, currentDef);
        }
    }
}

