/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.vo;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.USEClientProperties;
import de.fzj.unicore.wsrflite.xfire.XFireKernel;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.uas.security.vo.SAMLAssertionForwadingHandler;
import eu.unicore.uas.security.vo.SAMLAttributePushInHandler;
import eu.unicore.uas.security.vo.SAMLAttributeSourceBase;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.xfire.handler.Handler;
import pl.edu.icm.unicore.uvos.api.Attribute;

public class SAMLPushAuthoriser
extends SAMLAttributeSourceBase {
    private static final Logger log = Log.getLogger((String)"unicore.security.vo.push", SAMLPushAuthoriser.class);

    public void configure(String name) throws ConfigurationException {
        super.initConfig(log, name, true);
    }

    public void start(Kernel kernel) throws Exception {
        SAMLAttributePushInHandler handler;
        this.kernel = kernel;
        if (!this.isEnabled) {
            return;
        }
        try {
            handler = new SAMLAttributePushInHandler(this.conf);
        }
        catch (Exception e) {
            log.error((Object)("Error in VO subsystem configuration (PUSH mode): " + e.toString() + "\n PUSH MODE WILL BE DISABLED"));
            this.isEnabled = false;
            return;
        }
        log.info((Object)"Adding handler which parses incoming VO attribute assertions (in PUSH mode).");
        XFireKernel.get((Kernel)kernel).addGlobalInHandler((Handler)handler, true);
        log.info((Object)"Adding handler which forwards received VO attribute assertions (in PUSH mode).");
        USEClientProperties clientSettings = kernel.getClientConfiguration();
        String[] outHandlers = clientSettings.getOutHandlerClassNames();
        boolean isRegistered = false;
        if (outHandlers != null) {
            for (String h : outHandlers) {
                if (!h.equalsIgnoreCase(SAMLAssertionForwadingHandler.class.getName())) continue;
                isRegistered = true;
                break;
            }
        }
        if (!isRegistered) {
            String[] newOutHandlers;
            if (outHandlers == null) {
                newOutHandlers = new String[]{SAMLAssertionForwadingHandler.class.getName()};
            } else {
                newOutHandlers = Arrays.copyOf(outHandlers, outHandlers.length + 1);
                newOutHandlers[newOutHandlers.length - 1] = SAMLAssertionForwadingHandler.class.getName();
            }
            clientSettings.setOutHandlerClassNames(newOutHandlers);
        }
        super.initFinal(log, "SAMLPushedattrs", true);
    }

    public SubjectAttributesHolder getAttributes(SecurityTokens tokens, SubjectAttributesHolder otherAuthoriserInfo) throws IOException {
        SubjectAttributesHolder ret = new SubjectAttributesHolder();
        if (!this.isEnabled) {
            return ret;
        }
        Map ctx = tokens.getContext();
        if (ctx == null) {
            log.debug((Object)"No context in security tokens");
            return ret;
        }
        Map allAttribsByIssuer = (Map)ctx.get("SAMLPushedattrs");
        if (allAttribsByIssuer == null) {
            log.debug((Object)"No pushed attributes were found");
            return ret;
        }
        if (allAttribsByIssuer.size() > 1) {
            log.warn((Object)("Received a request with multiple pushed SAML assertions. This is currently unsupported. Issuer DNs in assertions are: " + allAttribsByIssuer.keySet()));
            return ret;
        }
        if (allAttribsByIssuer.size() == 0) {
            log.debug((Object)"No pushed (valid) attributes were found");
            return ret;
        }
        ArrayList<Attribute> attributesCopy = new ArrayList<Attribute>((Collection)allAttribsByIssuer.values().iterator().next());
        return this.assembleAttributesHolder(attributesCopy, otherAuthoriserInfo, true);
    }

    public String getStatusDescription() {
        return "SAML Push Attribute source [" + this.name + "]: " + (this.isEnabled ? "OK" : "DISABLED (browse previous log entries for the reason)");
    }
}

