/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.vo;

import eu.unicore.security.SecurityTokens;
import eu.unicore.security.xfireutil.AuthInHandler;
import eu.unicore.security.xfireutil.ETDInHandler;
import eu.unicore.uas.security.vo.VOAttributeFetcher;
import eu.unicore.uas.security.vo.conf.IPullConfiguration;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.AbstractHandler;

public class SAMLAttributePullInHandler
extends AbstractHandler {
    private static final Logger log = Log.getLogger((String)"unicore.security.vo.pull", SAMLAttributePullInHandler.class);
    private VOAttributeFetcher fetcher;

    public SAMLAttributePullInHandler(IPullConfiguration cc, IClientConfiguration clientSettings) throws Exception {
        this.setPhase("policy");
        this.after(AuthInHandler.class.getName());
        this.after(ETDInHandler.class.getName());
        this.fetcher = new VOAttributeFetcher(cc, clientSettings);
    }

    public void invoke(MessageContext context) throws Exception {
        SecurityTokens tokens = (SecurityTokens)context.getProperty(SecurityTokens.KEY);
        if (tokens == null) {
            log.error((Object)("Handlers are badly configured. " + SAMLAttributePullInHandler.class.getName() + " must be invoked AFTER " + AuthInHandler.class.getName()));
            return;
        }
        this.fetcher.authorise(tokens);
    }
}

