/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.ldap;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.IAttributeSource;
import de.fzj.unicore.wsrflite.security.VODescription;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.security.canl.SSLContextCreator;
import eu.unicore.uas.security.ldap.CanlJndiSocketFactory;
import eu.unicore.uas.security.ldap.JMXStats;
import eu.unicore.uas.security.ldap.LDAPAttributeSourceMBean;
import eu.unicore.uas.security.xuudb.CredentialCache;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.log4j.Logger;

public class LDAPAttributeSource
implements IAttributeSource,
LDAPAttributeSourceMBean {
    private static final Logger logger = Log.getLogger((String)"unicore.security", LDAPAttributeSource.class);
    public static final int DEFAULT_PORT = 389;
    public static final String DEFAULT_HOST = "ldap://localhost";
    public static final String DEFAULT_ROOTDN = "";
    public static final String DEFAULT_LDAPFILTER = "";
    public static final String DEFAULT_AUTHENTICATION = "none";
    public static final String DEFAULT_PRINCIPAL = "";
    public static final String DEFAULT_CREDENTIAL = "";
    public static final String DEFAULT_DNATTRNAME = "";
    public static final String DEFAULT_LOGINATTRNAME = "";
    public static final String DEFAULT_ROLEATTRNAME = "";
    public static final String DEFAULT_ROLEDEFAULTVALUE = "";
    public static final String DEFAULT_PROJECTATTRNAME = "";
    public static final String DEFAULT_PROJECTDEFAULTVALUE = "";
    public static final int DEFAULT_LDAP_MAX_CONNECT_RETRY = 3;
    private String name;
    private Kernel kernel;
    private boolean isEnabled = false;
    private Integer port;
    private String host;
    private String rootdn;
    private String ldapfilter;
    private String authentication;
    private String principal;
    private String credentials;
    private String DNAttrName;
    private String loginAttrName;
    private String roleAttrName;
    private String roleDefaultValue;
    private String groupAttrName;
    private String groupDefaultValue;
    private boolean cacheCredentials = true;
    private Integer maxConnectionRetry;
    private String ldapURL = null;
    private DirContext ldap;
    private CredentialCache cache;
    private JMXStats jmxStats = new JMXStats();

    public void configure(String name) throws ConfigurationException {
        this.name = name;
        if (this.port == null) {
            this.port = 389;
        }
        if (this.host == null) {
            this.host = DEFAULT_HOST;
        }
        if (this.rootdn == null) {
            this.rootdn = "";
        }
        if (this.ldapfilter == null) {
            this.ldapfilter = "";
        }
        if (this.authentication == null) {
            this.authentication = DEFAULT_AUTHENTICATION;
        }
        if (this.principal == null) {
            this.principal = "";
        }
        if (this.credentials == null) {
            this.credentials = "";
        }
        if (this.DNAttrName == null) {
            this.DNAttrName = "";
        }
        if (this.loginAttrName == null) {
            this.loginAttrName = "";
        }
        if (this.roleAttrName == null) {
            this.roleAttrName = "";
        }
        if (this.roleDefaultValue == null) {
            this.roleDefaultValue = "";
        }
        if (this.groupDefaultValue == null) {
            this.groupDefaultValue = "";
        }
        if (this.maxConnectionRetry == null) {
            this.maxConnectionRetry = 3;
        }
    }

    public void start(Kernel kernel) {
        this.kernel = kernel;
        this.ldapURL = this.host + ":" + this.port + "/";
        logger.info((Object)("LDAP attribute source '" + this.name + "': connecting to LDAP at <" + this.ldapURL + ">"));
        if (this.cacheCredentials) {
            logger.debug((Object)("LDAP " + this.name + " will cache credentials."));
        }
        this.isEnabled = true;
        try {
            this.ldap = this.makeEndpoint();
        }
        catch (NamingException e) {
            Log.logException((String)"Error in LDAP connection.", (Throwable)e, (Logger)logger);
        }
        this.cache = new CredentialCache();
        Kernel.addMBean((Object)this, (String)("LDAP attribute source - " + this.name));
    }

    public void setEndpoint(DirContext ldap) {
        this.ldap = ldap;
    }

    public void setLdapPort(int port) {
        this.port = port;
    }

    public void setLdapHost(String host) {
        this.host = host;
    }

    public void setLdapRootDn(String rootdn) {
        this.rootdn = rootdn;
    }

    public void setLdapFilter(String filter) {
        this.ldapfilter = filter;
    }

    public void setLdapAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public void setLdapPrincipal(String principal) {
        this.principal = principal;
    }

    public void setLdapCredential(String credentials) {
        this.credentials = credentials;
    }

    public void setLdapDNAttrName(String name) {
        this.DNAttrName = name;
    }

    public void setLdapLoginAttrName(String name) {
        this.loginAttrName = name;
    }

    public void setLdapRoleAttrName(String name) {
        this.roleAttrName = name;
    }

    public void setLdapRoleDefaultValue(String value) {
        this.roleDefaultValue = value;
    }

    public void setLdapGroupAttrName(String name) {
        this.groupAttrName = name;
    }

    public void setLdapGroupDefaultValue(String value) {
        this.groupDefaultValue = value;
    }

    public void setLdapCache(boolean cache) {
        this.cacheCredentials = cache;
    }

    public void setLdapMaxConnectionsRetry(int retry) {
        this.maxConnectionRetry = retry;
    }

    public SubjectAttributesHolder getAttributes(SecurityTokens tokens, SubjectAttributesHolder otherAuthoriserInfo) throws IOException {
        SubjectAttributesHolder map;
        long begin = System.currentTimeMillis();
        this.jmxStats.incTotalAuth();
        String cacheKey = X500NameUtils.getComparableForm((String)tokens.getEffectiveUserName().getName());
        SubjectAttributesHolder subjectAttributesHolder = map = this.getCachingCredentials() ? this.cache.read(cacheKey) : null;
        if (map == null) {
            map = this.checkDN(tokens);
            if (this.getCachingCredentials()) {
                this.cache.put(tokens.toString(), map);
            }
        } else if (this.getCachingCredentials()) {
            this.jmxStats.incCacheHits();
        }
        this.jmxStats.publishTime(System.currentTimeMillis() - begin);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubjectAttributesHolder checkDN(SecurityTokens tokens) throws IOException {
        SubjectAttributesHolder map = null;
        String dn = tokens.getEffectiveUserName().getName();
        this.jmxStats.addAccessor(dn);
        String filter = "(" + this.DNAttrName + "=" + dn + ")";
        if (this.ldapfilter != "") {
            filter = "(&" + filter + this.ldapfilter + ")";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("LDAP request: " + filter));
        }
        String[] returnAttrs = new String[]{this.loginAttrName, this.roleAttrName, this.groupAttrName};
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(returnAttrs);
        ctls.setReturningObjFlag(true);
        NamingEnumeration<SearchResult> enm = null;
        int retryNb = 0;
        while (true) {
            LDAPAttributeSource lDAPAttributeSource = this;
            synchronized (lDAPAttributeSource) {
                block12: {
                    try {
                        if (this.ldap != null) {
                            enm = this.ldap.search(this.rootdn, filter, ctls);
                            map = this.makeAuthInfo(enm);
                            break;
                        }
                    }
                    catch (NamingException e) {
                        Log.logException((String)"Error in LDAP request.", (Throwable)e, (Logger)logger);
                        if (++retryNb < this.maxConnectionRetry) break block12;
                        IOException ioe = new IOException("Error contacting LDAP: " + e.getMessage());
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
                while (true) {
                    try {
                        this.ldap = this.makeEndpoint();
                    }
                    catch (NamingException e) {
                        Log.logException((String)"Error in LDAP connection.", (Throwable)e, (Logger)logger);
                        if (++retryNb < this.maxConnectionRetry) continue;
                        IOException ioe = new IOException("Error contacting LDAP: " + e.getMessage());
                        ioe.initCause(e);
                        throw ioe;
                    }
                    break;
                }
            }
        }
        return map;
    }

    public SubjectAttributesHolder makeAuthInfo(NamingEnumeration<SearchResult> enm) throws NamingException {
        ArrayList<String> role = new ArrayList<String>();
        ArrayList<String> xlogin = new ArrayList<String>();
        ArrayList<String> group = new ArrayList<String>();
        if (enm == null) {
            return new SubjectAttributesHolder(new HashMap(), new HashMap());
        }
        while (enm.hasMore()) {
            try {
                int i;
                SearchResult res = enm.next();
                Attributes resAttrs = res.getAttributes();
                if (resAttrs.get(this.loginAttrName) != null) {
                    for (i = 0; i < resAttrs.get(this.loginAttrName).size(); ++i) {
                        xlogin.add(resAttrs.get(this.loginAttrName).get(i).toString());
                    }
                }
                if (resAttrs.get(this.roleAttrName) != null) {
                    for (i = 0; i < resAttrs.get(this.roleAttrName).size(); ++i) {
                        role.add(resAttrs.get(this.roleAttrName).get(i).toString());
                    }
                } else {
                    role.add(this.roleDefaultValue);
                }
                if (resAttrs.get(this.groupAttrName) != null) {
                    for (i = 0; i < resAttrs.get(this.groupAttrName).size(); ++i) {
                        group.add(resAttrs.get(this.groupAttrName).get(i).toString());
                    }
                    continue;
                }
                group.add(this.groupDefaultValue);
            }
            catch (PartialResultException e) {
                Log.logException((String)"LDAP Referral available", (Throwable)e, (Logger)logger);
            }
        }
        if (logger.isDebugEnabled()) {
            String reply = "[xlogin=" + xlogin + ", role=" + role + ", groups=" + group + "]";
            logger.debug((Object)("LDAP reply: " + reply));
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        HashMap<String, String[]> mapDef = new HashMap<String, String[]>();
        if (xlogin.size() > 0) {
            map.put("xlogin", xlogin.toArray(new String[xlogin.size()]));
            mapDef.put("xlogin", new String[]{(String)xlogin.get(0)});
        }
        if (role.size() > 0) {
            map.put("role", role.toArray(new String[role.size()]));
            mapDef.put("role", new String[]{(String)role.get(0)});
        }
        if (group.size() > 0) {
            map.put("group", group.toArray(new String[group.size()]));
            mapDef.put("group", new String[]{(String)group.get(0)});
        }
        return new SubjectAttributesHolder(mapDef, map);
    }

    @Override
    public String getLDAPPort() {
        return this.port + "";
    }

    @Override
    public String getLDAPHost() {
        return this.host;
    }

    @Override
    public String getRootDN() {
        return this.rootdn;
    }

    @Override
    public int getTotalRequests() {
        return this.jmxStats.getTotalRequests();
    }

    @Override
    public int getCacheHits() {
        return this.jmxStats.getCacheHits();
    }

    @Override
    public String[] getRequestorNames() {
        return this.jmxStats.getRequestorNames();
    }

    @Override
    public void clearRequestorNames() {
        this.jmxStats.clearRequestorNames();
    }

    @Override
    public void clearCache() {
        this.cache.removeAll();
    }

    @Override
    public float getMeanProcessingTime() {
        return this.jmxStats.getMeanProcessingTime();
    }

    @Override
    public synchronized boolean getCachingCredentials() {
        return this.cacheCredentials;
    }

    @Override
    public synchronized void toggleCachingCredentials() {
        boolean bl = this.cacheCredentials = !this.cacheCredentials;
        if (!this.cacheCredentials) {
            this.clearCache();
            logger.info((Object)"Caching of credentials was turned OFF");
        } else {
            logger.info((Object)"Caching of credentials was turned ON");
        }
    }

    @Override
    public void clearStatistics() {
        this.jmxStats.clearStatistics();
    }

    @Override
    public String getLDAPConnectionStatus() {
        if (!this.isEnabled) {
            return "No LDAP configured";
        }
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(1);
        try {
            DirContext testCnx = this.makeEndpoint();
            testCnx.search(this.rootdn, "objectClass=*", ctls);
        }
        catch (NamingException e) {
            return "LDAP Attribute Source ERROR [" + this.name + " connected to " + this.ldapURL + "]";
        }
        return "LDAP Attribute Source OK [" + this.name + " connected to " + this.ldapURL + "]";
    }

    public String getStatusDescription() {
        return this.getLDAPConnectionStatus();
    }

    public String getName() {
        return this.name;
    }

    public VODescription[] getAcceptedVOs() {
        return null;
    }

    private DirContext makeEndpoint() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.host + ":" + this.port);
        env.put("java.naming.security.authentication", this.authentication);
        if (this.isUsingSSL()) {
            SocketFactory sFactory;
            X509CertChainValidatorExt validator = this.kernel.getClientConfiguration().getValidator();
            if ("simple".equals(this.authentication) || DEFAULT_AUTHENTICATION.equals(this.authentication)) {
                sFactory = this.getCanlSocketFactory(null, (X509CertChainValidator)validator);
            } else {
                X509Credential credential = this.kernel.getClientConfiguration().getCredential();
                sFactory = this.getCanlSocketFactory(credential, (X509CertChainValidator)validator);
            }
            CanlJndiSocketFactory.setImplementation(sFactory);
            env.put("java.naming.security.protocol", "ssl");
            env.put("java.naming.ldap.factory.socket", CanlJndiSocketFactory.class.getName());
        }
        if ("simple".equals(this.authentication)) {
            env.put("java.naming.security.principal", this.principal);
            env.put("java.naming.security.credentials", this.credentials);
        }
        env.put("java.naming.referral", "ignore");
        return new InitialDirContext(env);
    }

    private boolean isUsingSSL() {
        return this.getLDAPHost().startsWith("ldaps");
    }

    private SocketFactory getCanlSocketFactory(X509Credential credential, X509CertChainValidator validator) throws NamingException {
        SSLContext ctx;
        try {
            ctx = SSLContextCreator.createSSLContext((X509Credential)credential, (X509CertChainValidator)validator, (String)"TLS", (String)"LDAP Client", (Logger)logger);
        }
        catch (Exception e) {
            logger.debug((Object)("Problem with TLS setup" + e.toString()), (Throwable)e);
            throw new NamingException("Problem setting up TLS infrastructure: " + e.toString());
        }
        return ctx.getSocketFactory();
    }
}

