/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.gridmapfile;

import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import eu.unicore.uas.security.gridmapfile.GridMapFileAuthoriser;
import eu.unicore.uas.security.gridmapfile.Pair;
import eu.unicore.uas.security.gridmapfile.QuotedStringTokenizer;
import eu.unicore.util.Log;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class GridMapFileParser {
    private static final Logger logger = Log.getLogger((String)"unicore.security", GridMapFileAuthoriser.class);
    private final File gridMapFile;
    private static final String COMMENT_CHARS = "#";
    private int numDuplicates;
    private int numEmpty;
    private int numError;

    public GridMapFileParser(File gridMapFile) {
        this.gridMapFile = gridMapFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> parse() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        FilterInputStream in = null;
        try {
            String line;
            in = new DataInputStream(new FileInputStream(this.gridMapFile));
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                try {
                    line = line.trim();
                    if (line.length() == 0 || COMMENT_CHARS.indexOf(line.charAt(0)) != -1) {
                        ++this.numEmpty;
                        continue;
                    }
                    Pair<String, String[]> mapping = GridMapFileParser.parseLine(line);
                    if (mapping != null) {
                        String[] ids;
                        String key = mapping.getM1();
                        ArrayList<String> logins = (ArrayList<String>)result.get(key);
                        if (logins == null) {
                            logins = new ArrayList<String>();
                            result.put(key, logins);
                        }
                        for (String id : ids = mapping.getM2()) {
                            if (logins.contains(id)) {
                                ++this.numDuplicates;
                                continue;
                            }
                            logins.add(id);
                        }
                        continue;
                    }
                    ++this.numError;
                }
                catch (Exception e) {
                    logger.warn((Object)("Problem while parsing line " + line + " from grid-mapfile " + this.gridMapFile.getAbsolutePath() + ": " + e.getMessage()), (Throwable)e);
                    ++this.numError;
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Problem while parsing grid-mapfile " + this.gridMapFile.getAbsolutePath() + ": " + e.getMessage()), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                logger.debug((Object)e2);
            }
        }
        return result;
    }

    public static Pair<String, String[]> parseLine(String line) throws IOException {
        QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(line);
        String dn = null;
        if (!tokenizer.hasMoreTokens()) {
            throw new IOException("Line does not contain user DN!");
        }
        dn = tokenizer.nextToken();
        String xlogins = null;
        if (!tokenizer.hasMoreTokens()) {
            throw new IOException("Line does not contain xlogin!");
        }
        xlogins = tokenizer.nextToken();
        StringTokenizer idTokenizer = new StringTokenizer(xlogins, ",");
        String[] ids = new String[idTokenizer.countTokens()];
        int i = 0;
        while (idTokenizer.hasMoreTokens()) {
            ids[i++] = idTokenizer.nextToken();
        }
        String normalizedDN = OpensslNameUtils.normalize((String)dn);
        if (normalizedDN == null) {
            throw new IOException("Invalid distinguished name: " + dn);
        }
        return new Pair<String, String[]>(normalizedDN, ids);
    }

    public int getNumDuplicates() {
        return this.numDuplicates;
    }

    public int getNumEmpty() {
        return this.numEmpty;
    }

    public int getNumError() {
        return this.numError;
    }
}

