/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.gridmapfile;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.ThreadingServices;
import de.fzj.unicore.wsrflite.security.IAttributeSource;
import de.fzj.unicore.wsrflite.security.VODescription;
import de.fzj.unicore.wsrflite.utils.FileWatcher;
import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.uas.security.gridmapfile.GridMapFileParser;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class GridMapFileAuthoriser
implements IAttributeSource {
    private static final Logger logger = Log.getLogger((String)"unicore.security", GridMapFileAuthoriser.class);
    private File mapFile;
    private String name;
    private String status = "OK";
    private Map<String, List<String>> map;

    public void configure(String name) throws ConfigurationException {
        this.name = name;
        this.parse();
    }

    public void start(Kernel kernel) throws FileNotFoundException {
        FileWatcher modifiedWatcher = new FileWatcher(this.mapFile, new Runnable(){

            @Override
            public void run() {
                GridMapFileAuthoriser.this.parse();
            }
        });
        ThreadingServices ts = kernel.getContainerProperties().getThreadingServices();
        ts.getScheduledExecutorService().scheduleWithFixedDelay((Runnable)modifiedWatcher, 2L, 2L, TimeUnit.MINUTES);
    }

    public SubjectAttributesHolder getAttributes(SecurityTokens tokens, SubjectAttributesHolder otherAuthoriserInfo) throws IOException {
        String subject = OpensslNameUtils.convertFromRfc2253((String)tokens.getEffectiveUserName().getName(), (boolean)true);
        HashMap<String, String[]> retAll = new HashMap<String, String[]>();
        HashMap<String, String[]> retFirst = new HashMap<String, String[]>();
        ArrayList retXACML = new ArrayList();
        List<String> xlogins = this.map.get(subject);
        if (xlogins != null) {
            String[] loginArray = xlogins.toArray(new String[xlogins.size()]);
            retFirst.put("xlogin", loginArray);
            retAll.put("xlogin", loginArray);
            retFirst.put("role", new String[]{"user"});
            retAll.put("role", new String[]{"user"});
        }
        return new SubjectAttributesHolder(retXACML, retFirst, retAll);
    }

    private void parse() throws ConfigurationException {
        if (this.mapFile == null) {
            this.status = "FAILED";
            throw new ConfigurationException("Config error for gridmap attribute source <" + this.name + ">: property 'file' must be set.");
        }
        if (!this.mapFile.exists()) {
            this.status = "FAILED";
            throw new ConfigurationException("Could not parse grid-mapfile as it does not exist. Please change it in your attribute source configuration (look for properties named uas.security.attributes.*");
        }
        if (this.mapFile.isDirectory()) {
            this.status = "FAILED";
            throw new ConfigurationException("Could not parse grid-mapfile as it is a directory. Please change it in your attribute source configuration (look for properties named uas.security.attributes.*");
        }
        if (!this.mapFile.canRead()) {
            this.status = "FAILED";
            throw new ConfigurationException("Could not parse grid-mapfile as it cannot be read. Please check permissions of the file " + this.mapFile.getAbsolutePath());
        }
        GridMapFileParser parser = new GridMapFileParser(this.mapFile);
        this.map = parser.parse();
        logger.info((Object)("User attributes were loaded from the file " + this.mapFile));
    }

    public String getStatusDescription() {
        return "File Attribute Source [" + this.name + "]: " + this.status + ", using map file " + this.mapFile.getAbsolutePath();
    }

    public String getName() {
        return this.name;
    }

    public void setFile(String mapFile) {
        this.mapFile = new File(mapFile);
    }

    public VODescription[] getAcceptedVOs() {
        return null;
    }
}

