/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.file;

import de.fzj.unicore.wsrflite.security.IAttributeSource;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.security.XACMLAttribute;
import eu.unicore.uas.security.file.Attribute;
import eu.unicore.uas.security.file.FileAttributeSourceBase;
import eu.unicore.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FileAttributeSource
extends FileAttributeSourceBase
implements IAttributeSource {
    private static final Logger logger = Log.getLogger((String)"unicore.security", FileAttributeSource.class);
    private boolean strictMatching = true;
    private Map<String, List<Attribute>> map;

    public FileAttributeSource() {
        super(logger);
    }

    public SubjectAttributesHolder getAttributes(SecurityTokens tokens, SubjectAttributesHolder otherAuthoriserInfo) throws IOException {
        this.parseIfNeeded();
        String subject = X500NameUtils.getComparableForm((String)tokens.getEffectiveUserName().getName());
        List<Attribute> attrs = this.searchFor(subject);
        HashMap<String, String[]> retAll = new HashMap<String, String[]>();
        HashMap<String, String[]> retFirst = new HashMap<String, String[]>();
        ArrayList<XACMLAttribute> retXACML = new ArrayList<XACMLAttribute>();
        if (attrs != null) {
            this.putAttributes(attrs, retAll, retFirst, retXACML);
        }
        return new SubjectAttributesHolder(retXACML, retFirst, retAll);
    }

    private List<Attribute> searchFor(String name) {
        if (this.strictMatching) {
            return this.map.get(name);
        }
        for (String pattern : this.map.keySet()) {
            Pattern p = Pattern.compile(pattern, 2);
            Matcher m = p.matcher(name);
            if (!m.matches()) continue;
            return this.map.get(pattern);
        }
        return null;
    }

    @Override
    protected void installNewMappings(Map<String, List<Attribute>> newData) {
        this.map = newData;
        if (this.strictMatching) {
            this.canonMap();
        }
    }

    private void canonMap() {
        HashMap<String, List<Attribute>> map2 = new HashMap<String, List<Attribute>>();
        for (Map.Entry<String, List<Attribute>> e : this.map.entrySet()) {
            String key = e.getKey();
            map2.put(X500NameUtils.getComparableForm((String)key), e.getValue());
        }
        this.map = map2;
    }

    public String getStatusDescription() {
        return "File Attribute Source [" + this.getName() + "]: " + this.status + ", using map file " + this.uudbFile.getAbsolutePath();
    }

    public void setMatching(String val) {
        if (val.equalsIgnoreCase(MatchingTypes.STRICT.name())) {
            this.strictMatching = true;
        } else if (val.equalsIgnoreCase(MatchingTypes.REGEXP.name())) {
            this.strictMatching = false;
        } else {
            logger.error((Object)("Invalid value of the 'matching' configuration option: " + val + ", using default: " + (Object)((Object)MatchingTypes.STRICT)));
        }
    }

    private static enum MatchingTypes {
        STRICT,
        REGEXP;

    }
}

