/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.util;

import de.fzj.unicore.bes.impl.management.BESFactoryAdmin;
import de.fzj.unicore.bes.util.BESProperties;
import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.impl.LockSupport;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.exceptions.ResourceNotCreatedException;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import eu.unicore.util.configuration.UpdateableConfiguration;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class BESOnStartup
implements Runnable,
KernelInjectable {
    private static final Logger logger = LogUtil.getLogger((String)"unicore", BESOnStartup.class);
    public static final String INSTANCE_ID = "default_bes_factory";
    public static final String INIT_ACTIVITY_FLAG = BESOnStartup.class.getName() + "_activity_key";
    public static final String INIT_NAMING_PROFILE = BESOnStartup.class.getName() + "_naming_key";
    public static final String INIT_LOCAL_RESOURCE_MANAGER_TYPE = BESOnStartup.class.getName() + "_resource_manager_key";
    public static final String INIT_COMMON_NAME = BESOnStartup.class.getName() + "_common_name_key";
    public static final String INIT_LONG_DESCRIPTION = BESOnStartup.class.getName() + "_long_description_key";
    public static final String INIT_BES_EXTENSION = BESOnStartup.class.getName() + "_bes_extension";
    public static final String INIT_BES_GLUE_PATH = BESOnStartup.class.getName() + "_bes_glue_path";
    private static BESFactoryAdmin besAdminBean;
    private Kernel kernel;

    public BESOnStartup() {
    }

    public BESOnStartup(Kernel kernel) {
        this.kernel = kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        LockSupport ls;
        Lock lock;
        BESProperties cfg = new BESProperties(this.kernel.getContainerProperties().getRawProperties());
        this.kernel.addConfigurationHandler(BESProperties.class, (UpdateableConfiguration)cfg);
        try {
            logger.info((Object)"Initialising backend");
            XNJSFacade.get(null, (Kernel)this.kernel);
        }
        catch (Exception e) {
            logger.error((Object)"Error initialising backend", (Throwable)e);
            return;
        }
        Home bfHome = this.kernel.getHome("BESFactory");
        if (bfHome == null) {
            logger.info((Object)"BES factory service not deployed at this site.!");
            return;
        }
        if (besAdminBean == null) {
            besAdminBean = new BESFactoryAdmin(this.kernel);
            Kernel.addMBean((Object)besAdminBean, (String)"UNICORE/X-BESFactory");
        }
        if ((lock = (ls = this.kernel.getPersistenceManager().getLockSupport()).getOrCreateLock(BESOnStartup.class.getName())).tryLock()) {
            try {
                UASWSResourceImpl bf = (UASWSResourceImpl)bfHome.get(INSTANCE_ID);
                bf.publish();
                return;
            }
            catch (ResourceUnknownException e) {
                try {
                    this.createInstance(cfg, bfHome);
                }
                catch (ResourceNotCreatedException nce) {
                    logger.error((Object)"Could not setup BES factory.", (Throwable)nce);
                }
            }
            catch (PersistenceException pe) {
                throw new RuntimeException(pe);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void createInstance(BESProperties cfg, Home bfHome) throws ResourceNotCreatedException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(WSResourceImpl.INIT_UNIQUE_ID, INSTANCE_ID);
        map.put(INIT_ACTIVITY_FLAG, cfg.getValue("isAcceptingNewActivities"));
        map.put(INIT_NAMING_PROFILE, cfg.getValue("namingProfile"));
        map.put(INIT_LOCAL_RESOURCE_MANAGER_TYPE, cfg.getValue("localResourceManagerType"));
        map.put(INIT_COMMON_NAME, cfg.getValue("commonName"));
        map.put(INIT_LONG_DESCRIPTION, cfg.getValue("longDescription"));
        map.put(INIT_BES_EXTENSION, cfg.getValue("extension"));
        String glue = cfg.getValue("gluePropertyFile");
        if (glue == null) {
            logger.info((Object)"BES GLUE file not configured.");
        } else {
            logger.info((Object)("Initializing BES GLUE Properties from: " + glue));
            map.put(INIT_BES_GLUE_PATH, glue);
        }
        GregorianCalendar c1 = new GregorianCalendar();
        ((Calendar)c1).add(2, 36);
        map.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", c1);
        bfHome.createWSRFServiceInstance(map);
        logger.info((Object)"Added default_bes_factory resource to service BESFactory");
        logger.info((Object)"Initialized BES factory.");
    }
}

