/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.impl.management;

import de.fzj.unicore.bes.impl.management.BESFactoryAdmin;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.admin.AdminAction;
import de.fzj.unicore.wsrflite.admin.AdminActionResult;
import eu.unicore.util.Log;
import java.util.Map;

public class ToggleBESJobSubmissionStatus
implements AdminAction {
    public String getName() {
        return "ToggleBESJobSubmission";
    }

    public String getDescription() {
        return "";
    }

    public AdminActionResult invoke(Map<String, String> params, Kernel kernel) {
        boolean success = true;
        String message = null;
        try {
            BESFactoryAdmin admin = (BESFactoryAdmin)kernel.load(BESFactoryAdmin.class);
            String submissionStatus = admin.isJobSubmissionEnabled();
            if (submissionStatus == null) {
                success = false;
                message = "No BESFactory service available at this site!";
            } else {
                boolean enabled = Boolean.parseBoolean(submissionStatus);
                admin.toggleJobSubmissionEnabled();
                enabled = Boolean.parseBoolean(admin.isJobSubmissionEnabled());
                message = enabled ? "OK - BES job submission is now enabled" : "OK - BES job submission is disabled";
            }
            return new AdminActionResult(success, message);
        }
        catch (Exception e) {
            return new AdminActionResult(false, Log.createFaultMessage((String)"Can't run action", (Throwable)e));
        }
    }
}

