/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.impl.management;

import de.fzj.unicore.bes.BESFactory;
import de.fzj.unicore.bes.BESManagement;
import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.codehaus.xfire.fault.XFireFault;
import org.ggf.schemas.bes.x2006.x08.besManagement.StartAcceptingNewActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besManagement.StartAcceptingNewActivitiesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besManagement.StopAcceptingNewActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besManagement.StopAcceptingNewActivitiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class BESManagementImpl
implements BESManagement,
KernelInjectable {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", BESManagementImpl.class);
    private Kernel kernel;

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public StartAcceptingNewActivitiesResponseDocument StartAcceptingNewActivities(StartAcceptingNewActivitiesDocument startRequestDoc) throws XFireFault {
        logger.info((Object)"Start Accepting New Activities. ");
        StartAcceptingNewActivitiesResponseDocument startResDoc = StartAcceptingNewActivitiesResponseDocument.Factory.newInstance();
        startResDoc.addNewStartAcceptingNewActivitiesResponse();
        try {
            this.updateActivityFlag(true);
            logger.info((Object)"BES is accepting new activities");
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't enforce BES to start accepting new activities.", (Throwable)e);
        }
        return startResDoc;
    }

    public StopAcceptingNewActivitiesResponseDocument StopAcceptingNewActivities(StopAcceptingNewActivitiesDocument stopRequestDoc) throws XFireFault {
        logger.info((Object)"Stop Accepting New Acivities");
        StopAcceptingNewActivitiesResponseDocument stopResDoc = StopAcceptingNewActivitiesResponseDocument.Factory.newInstance();
        stopResDoc.addNewStopAcceptingNewActivitiesResponse();
        try {
            this.updateActivityFlag(false);
            logger.info((Object)"BES is not accepting any new activities.");
        }
        catch (Exception e) {
            logger.error((Object)"Not possible to stop accepting new activities. ", (Throwable)e);
        }
        return stopResDoc;
    }

    protected BESFactory getBESInstance() {
        EndpointReferenceType eprt = EndpointReferenceType.Factory.newInstance();
        String baseUrl = this.kernel.getContainerProperties().getBaseUrl();
        String factoryUrl = baseUrl + "/" + "BESFactory" + "?res=" + "default_bes_factory";
        eprt.addNewAddress().setStringValue(factoryUrl);
        Home h = this.kernel.getHome("BESFactory");
        try {
            return (BESFactory)h.getForUpdate("default_bes_factory");
        }
        catch (ResourceUnknownException e1) {
            logger.fatal((Object)"Resource unknown: ", (Throwable)e1);
            return null;
        }
    }

    protected void releaseBESInstance(BESFactory f) throws PersistenceException {
        Resource r = (Resource)f;
        Home h = this.kernel.getHome("BESFactory");
        if (r.hasChanged()) {
            h.getStore().persist(r);
        }
        h.getStore().unlock(r);
    }

    private String getActivityProperty() throws Exception {
        BESFactory bfObj = this.getBESInstance();
        GetResourcePropertyDocument gReqDoc = GetResourcePropertyDocument.Factory.newInstance();
        gReqDoc.setGetResourceProperty(BESFactory.RPIsAcceptingNewActivities);
        GetResourcePropertyResponseDocument gResDoc = bfObj.GetResourceProperty(gReqDoc);
        return gResDoc.getGetResourcePropertyResponse().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActivityFlag(boolean flag) {
        XmlObject acObj = null;
        XmlCursor acCursor = null;
        try {
            String propertyXml = this.getActivityProperty();
            logger.debug((Object)("IsAcceptingNewActivities resource property: " + propertyXml));
            acObj = XmlObject.Factory.parse((String)propertyXml);
            acCursor = acObj.newCursor();
            UpdateResourcePropertiesDocument updateReqDoc = UpdateResourcePropertiesDocument.Factory.newInstance();
            UpdateType updateType = updateReqDoc.addNewUpdateResourceProperties().addNewUpdate();
            XmlObject newXml = XmlObject.Factory.newInstance();
            XmlCursor cursor = newXml.newCursor();
            cursor.toNextToken();
            cursor.beginElement(BESFactory.RPIsAcceptingNewActivities);
            cursor.insertChars(String.valueOf(flag));
            updateType.set(newXml);
            BESFactory f = this.getBESInstance();
            try {
                f.UpdateResourceProperties(updateReqDoc);
            }
            finally {
                if (f != null) {
                    this.releaseBESInstance(f);
                }
            }
            cursor.dispose();
            acCursor.dispose();
        }
        catch (XmlException e) {
            logger.error((Object)"Couldn't update bes resource property", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

