/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.impl.management;

import de.fzj.unicore.bes.BESFactory;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.client.ManagementClient;
import de.fzj.unicore.bes.impl.management.BESFactoryAdminMBean;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import eu.unicore.util.httpclient.IClientConfiguration;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class BESFactoryAdmin
implements BESFactoryAdminMBean {
    private final Kernel kernel;

    public BESFactoryAdmin(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public String isJobSubmissionEnabled() {
        String factoryUrl = this.kernel.getContainerProperties().getBaseUrl() + "/" + "BESFactory" + "?res=default_bes_factory";
        EndpointReferenceType factoryEpr = WSUtilities.makeServiceEPR((String)factoryUrl);
        XmlCursor cursor = null;
        try {
            FactoryClient factoryCient = new FactoryClient(factoryEpr, (IClientConfiguration)this.kernel.getClientConfiguration());
            String xml = factoryCient.getResourceProperty(BESFactory.RPIsAcceptingNewActivities);
            XmlObject xmlObj = XmlObject.Factory.parse((String)xml);
            cursor = xmlObj.newCursor();
            cursor.toChild(BESFactory.RPIsAcceptingNewActivities);
            String s = cursor.getTextValue();
            cursor.dispose();
            return s;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public synchronized void toggleJobSubmissionEnabled() {
        boolean submissionEnabled = Boolean.parseBoolean(this.isJobSubmissionEnabled());
        String serviceUrl = this.kernel.getContainerProperties().getBaseUrl() + "/" + "BESManagement";
        try {
            ManagementClient bmClient = new ManagementClient(serviceUrl, (IClientConfiguration)this.kernel.getClientConfiguration());
            if (submissionEnabled) {
                bmClient.stopAcceptingNewActivities();
            } else {
                bmClient.startAcceptingNewActivities();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

