/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.impl.factory;

import de.fzj.unicore.bes.BESActivity;
import de.fzj.unicore.bes.BESFactory;
import de.fzj.unicore.bes.factory.rp.ActivityReferenceRP;
import de.fzj.unicore.bes.factory.rp.BESExtensionRP;
import de.fzj.unicore.bes.factory.rp.BasicResourceAttributesDocumentRP;
import de.fzj.unicore.bes.factory.rp.CommonNameRP;
import de.fzj.unicore.bes.factory.rp.FilteredActivityReferenceRP;
import de.fzj.unicore.bes.factory.rp.GlueAttributesRP;
import de.fzj.unicore.bes.factory.rp.IsAcceptingNewActivitiesRP;
import de.fzj.unicore.bes.factory.rp.LocalResourceManagerTypeRP;
import de.fzj.unicore.bes.factory.rp.LongDescriptionRP;
import de.fzj.unicore.bes.factory.rp.NamingProfileRP;
import de.fzj.unicore.bes.factory.rp.TotalNumberOfActivitiesRP;
import de.fzj.unicore.bes.faults.InvalidRequestMessageFault;
import de.fzj.unicore.bes.faults.NotAcceptingNewActivitiesFault;
import de.fzj.unicore.bes.faults.UnknownActivityIdentifierFault;
import de.fzj.unicore.bes.faults.UnsupportedFeatureFault;
import de.fzj.unicore.bes.impl.activity.BESActivityImpl;
import de.fzj.unicore.bes.util.BESOnStartup;
import de.fzj.unicore.bes.util.BESUtils;
import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.impl.bp.BPSupportImpl;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.impl.tss.TargetSystemImpl;
import de.fzj.unicore.uas.impl.tss.rp.StorageReferenceResourceProperty;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.exceptions.UnableToSetTerminationTimeException;
import de.fzj.unicore.wsrflite.messaging.Message;
import de.fzj.unicore.wsrflite.messaging.PullPoint;
import de.fzj.unicore.wsrflite.messaging.ResourceDeletedMessage;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.TerminationTimeChangeRejectedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.UnableToSetTerminationTimeFault;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import de.fzj.unicore.xnjs.ems.Action;
import eu.unicore.security.Client;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.ggf.baseprofile.FinalWSResourceInterfaceDocument;
import org.ggf.baseprofile.ResourcePropertyNamesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.FactoryResourceAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.FactoryResourceAttributesDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivityResponseType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.oasisOpen.docs.wsrf.rl2.CurrentTimeDocument;
import org.oasisOpen.docs.wsrf.rl2.DestroyDocument;
import org.oasisOpen.docs.wsrf.rl2.DestroyResponseDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeResponseDocument;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesResponseDocument;
import org.ogf.schemas.glue.x2009.x03.spec20R1.DomainsDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class BESFactoryImpl
extends UASWSResourceImpl
implements BESFactory {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", BESFactoryImpl.class);
    public static final String JSDL = "http://schemas.ggf.org/jsdl/2005/11/jsdl";
    public static final String JSDL_POSIX = "http://schemas.ggf.org/jsdl/2005/11/jsdl-posix";
    public static final String JSDL_HPCP = "http://schemas.ggf.org/jsdl/2006/07/jsdl-hpcp";
    @Persist
    private Map<String, String> owners = new HashMap<String, String>();
    @Persist
    private boolean useGlue = false;

    protected void addWSResourceInterfaces(BPSupportImpl baseProfile) {
        super.addWSResourceInterfaces(baseProfile);
        baseProfile.addWSResourceInterface(BES_PORT);
    }

    public void customPostActivate() {
        try {
            logger.trace((Object)("Getting messages from queue " + this.getUniqueID()));
            PullPoint p = this.kernel.getMessaging().getPullPoint(this.getUniqueID());
            ActivityReferenceRP acRP = (ActivityReferenceRP)((Object)this.properties.get(RPActivityReference));
            while (p.hasNext()) {
                Message m = p.next();
                logger.trace((Object)("Read: " + m));
                if (!(m instanceof ResourceDeletedMessage)) continue;
                ResourceDeletedMessage rdm = (ResourceDeletedMessage)m;
                String id = rdm.getDeletedResource();
                String service = rdm.getServiceName();
                if (!"BESActivity".equals(service)) continue;
                acRP.remove(id);
                this.owners.remove(id);
                this.setDirty();
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)e.getMessage(), (Throwable)e, (Logger)logger);
        }
    }

    public void initialise(String serviceName, Map<String, Object> initObjs) throws Exception {
        super.initialise(serviceName, initObjs);
        logger.info((Object)("Initializing BESFactory with ID: " + this.getUniqueID()));
        Boolean activityFlag = Boolean.valueOf((String)initObjs.get(BESOnStartup.INIT_ACTIVITY_FLAG));
        String namingProfile = (String)initObjs.get(BESOnStartup.INIT_NAMING_PROFILE);
        String besExtension = (String)initObjs.get(BESOnStartup.INIT_BES_EXTENSION);
        String glueFilePath = (String)initObjs.get(BESOnStartup.INIT_BES_GLUE_PATH);
        String resourceManagerType = (String)initObjs.get(BESOnStartup.INIT_LOCAL_RESOURCE_MANAGER_TYPE);
        String commonName = (String)initObjs.get(BESOnStartup.INIT_COMMON_NAME);
        String longDesc = (String)initObjs.get(BESOnStartup.INIT_LONG_DESCRIPTION);
        this.properties.put(RPIsAcceptingNewActivities, new IsAcceptingNewActivitiesRP(activityFlag));
        this.properties.put(RPNamingProfile, new NamingProfileRP(namingProfile));
        this.properties.put(RPLocalResourceManagerType, new LocalResourceManagerTypeRP(resourceManagerType));
        this.properties.put(RPTotalNumberOfActivities, new TotalNumberOfActivitiesRP((Resource)this, this.xnjsReference));
        this.properties.put(RPCommonName, new CommonNameRP(commonName));
        this.properties.put(RPLongDescription, new LongDescriptionRP(longDesc));
        this.properties.put(RPActivityReference, new ActivityReferenceRP((Resource)this));
        this.properties.put(RPBasicResourceAttributes, new BasicResourceAttributesDocumentRP((Resource)this, this.xnjsReference));
        this.properties.put(RPFilteredActivityReference, new FilteredActivityReferenceRP(this));
        this.properties.put(RPBESExtension, new BESExtensionRP(besExtension));
        if (glueFilePath != null) {
            this.properties.put(RPGlueProperties, new GlueAttributesRP(this, this.getGlueDocument(glueFilePath), this.xnjsReference));
            this.useGlue = true;
        } else {
            this.useGlue = false;
        }
        this.publish();
    }

    protected DomainsDocument getGlueDocument(String filePath) {
        try {
            DomainsDocument d = DomainsDocument.Factory.parse((File)new File(filePath));
            return d;
        }
        catch (XmlException e) {
            logger.error((Object)("Couldn't build glue instance document from file: " + filePath + "\n"), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Couldn't find glue instance file", (Throwable)e);
        }
        return null;
    }

    public String getOwnerForActivity(String activityID) {
        return this.owners.get(activityID);
    }

    public CreateActivityResponseDocument CreateActivity(CreateActivityDocument req) throws NotAcceptingNewActivitiesFault, InvalidRequestMessageFault, UnsupportedFeatureFault {
        if (!this.getIsAcceptingNewActivitiesProperty().getProperty().booleanValue()) {
            throw new NotAcceptingNewActivitiesFault("NotAcceptingNewActvities Error");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)req.toString());
        }
        ActivityDocumentType activityDescription = req.getCreateActivity().getActivityDocument();
        JobDefinitionType jobType = activityDescription.getJobDefinition();
        this.checkJobValidity(jobType);
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        ActivityDocumentDocument1 aDoc = ActivityDocumentDocument1.Factory.newInstance();
        aDoc.setActivityDocument(activityDescription);
        EndpointReferenceDocument factoryEPR = EndpointReferenceDocument.Factory.newInstance();
        factoryEPR.setEndpointReference(this.getEPR());
        initParams.put(BESActivity.ACTIVITY_DOC_KEY, aDoc);
        initParams.put(BESActivity.FACTORY_REF_KEY, factoryEPR);
        JobDefinitionDocument doc = JobDefinitionDocument.Factory.newInstance();
        doc.setJobDefinition(jobType);
        Action action = XNJSFacade.get((String)this.xnjsReference, (Kernel)this.kernel).makeAction(doc);
        initParams.put(BESActivity.INIT_ACTION_KEY, action);
        initParams.put(INITPARAM_XNJS_REFERENCE, this.xnjsReference);
        TerminationTimeDocument.TerminationTime itt = req.getCreateActivity().getActivityDocument().getTerminationTime();
        if (itt != null && itt.getCalendarValue() != null) {
            Calendar jobTT = itt.getCalendarValue();
            initParams.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", jobTT);
            try {
                this.checkAndExtendLT(jobTT);
            }
            catch (UnableToSetTerminationTimeException te) {
                LogUtil.logException((String)"Could not extend termination time of BES factory.", (Throwable)te, (Logger)logger);
            }
        }
        EndpointReferenceType instanceEPR = null;
        try {
            instanceEPR = this.createJobInstance(initParams);
            Client client = this.getClient();
            if (client != null) {
                this.owners.put(WSServerUtilities.extractResourceID((EndpointReferenceType)instanceEPR), client.getDistinguishedName());
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)"Couldn't create BESActivity: ", (Throwable)e, (Logger)logger);
        }
        CreateActivityResponseDocument crResDoc = CreateActivityResponseDocument.Factory.newInstance();
        CreateActivityResponseType crResType = crResDoc.addNewCreateActivityResponse();
        if (instanceEPR != null) {
            crResType.setActivityIdentifier(instanceEPR);
            crResType.setActivityDocument(activityDescription);
            this.getActivityReferenceProperty().add(instanceEPR);
        }
        this.setDirty();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)crResDoc.toString());
        }
        return crResDoc;
    }

    public GetActivityDocumentsResponseDocument GetActivityDocuments(GetActivityDocumentsDocument req) throws UnknownActivityIdentifierFault {
        EndpointReferenceType[] requestedActivities = req.getGetActivityDocuments().getActivityIdentifierArray();
        GetActivityDocumentResponseType[] result = new GetActivityDocumentResponseType[requestedActivities.length];
        Map<String, Boolean> eprMap = this.checkIfAccessible(requestedActivities);
        int counter = 0;
        Home localHome = this.kernel.getHome("BESActivity");
        for (EndpointReferenceType requested : requestedActivities) {
            Boolean accessible = eprMap.get(requested.getAddress().getStringValue());
            result[counter] = GetActivityDocumentResponseType.Factory.newInstance();
            result[counter].setActivityIdentifier(requested);
            BESActivityImpl besActivity = null;
            try {
                besActivity = (BESActivityImpl)localHome.get(WSServerUtilities.extractResourceID((EndpointReferenceType)requested));
            }
            catch (Exception r) {
                Fault soapFault = BESUtils.buildSOAP11Fault((QName)UnknownActivityIdentifierFaultNS, (String)"Given activity doesn't exist");
                result[counter].setFault(soapFault);
                ++counter;
                continue;
            }
            if (Boolean.TRUE.equals(accessible)) {
                JobDefinitionType job = besActivity.getActivityDocumentProperty().getActivityDocument().getJobDefinition();
                result[counter].setJobDefinition(job);
                result[counter].setActivityLog(besActivity.getActivityLog());
            } else {
                Fault soapFault = BESUtils.buildSOAP11Fault((QName)NotAuthorizedFaultNS, (String)"Given activity is not accessible");
                result[counter].setFault(soapFault);
            }
            ++counter;
        }
        GetActivityDocumentsResponseDocument responseDoc = GetActivityDocumentsResponseDocument.Factory.newInstance();
        responseDoc.addNewGetActivityDocumentsResponse().setResponseArray(result);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)responseDoc.toString());
        }
        return responseDoc;
    }

    public GetActivityStatusesResponseDocument GetActivityStatuses(GetActivityStatusesDocument req) throws UnknownActivityIdentifierFault {
        EndpointReferenceType[] requestedActivities = req.getGetActivityStatuses().getActivityIdentifierArray();
        GetActivityStatusResponseType[] result = new GetActivityStatusResponseType[requestedActivities.length];
        Map<String, Boolean> eprMap = this.checkIfAccessible(requestedActivities);
        int counter = 0;
        Home localHome = this.kernel.getHome("BESActivity");
        for (EndpointReferenceType requested : requestedActivities) {
            Boolean accessible = eprMap.get(requested.getAddress().getStringValue());
            result[counter] = GetActivityStatusResponseType.Factory.newInstance();
            result[counter].setActivityIdentifier(requested);
            BESActivityImpl besActivity = null;
            try {
                besActivity = (BESActivityImpl)localHome.get(WSServerUtilities.extractResourceID((EndpointReferenceType)requested));
            }
            catch (Exception r) {
                Fault soapFault = BESUtils.buildSOAP11Fault((QName)UnknownActivityIdentifierFaultNS, (String)"Given activity doesn't exist");
                result[counter].setFault(soapFault);
                ++counter;
                continue;
            }
            if (Boolean.TRUE.equals(accessible)) {
                try {
                    result[counter].setActivityStatus(besActivity.getStatusProperty().getActivityStatus());
                }
                catch (Exception ex) {
                    LogUtil.logException((String)("Can't get state for " + requested), (Throwable)ex, (Logger)logger);
                }
            } else {
                Fault soapFault = BESUtils.buildSOAP11Fault((QName)NotAuthorizedFaultNS, (String)"Given activity is not accessible");
                result[counter].setFault(soapFault);
            }
            ++counter;
        }
        GetActivityStatusesResponseDocument responseDoc = GetActivityStatusesResponseDocument.Factory.newInstance();
        responseDoc.addNewGetActivityStatusesResponse().setResponseArray(result);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)responseDoc.toString());
        }
        return responseDoc;
    }

    public GetFactoryAttributesDocumentResponseDocument GetFactoryAttributesDocument(GetFactoryAttributesDocumentDocument1 req) {
        GetFactoryAttributesDocumentResponseDocument resDoc = GetFactoryAttributesDocumentResponseDocument.Factory.newInstance();
        GetFactoryAttributesDocumentResponseType res = resDoc.addNewGetFactoryAttributesDocumentResponse();
        try {
            res.set(this.getResourcePropertyResponseDocument(req.getGetFactoryAttributesDocument()));
        }
        catch (Exception e) {
            LogUtil.logException((String)"", (Throwable)e, (Logger)logger);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)resDoc.toString());
        }
        return resDoc;
    }

    public TerminateActivitiesResponseDocument TerminateActivities(TerminateActivitiesDocument req) throws UnknownActivityIdentifierFault {
        EndpointReferenceType[] requestedActivities = req.getTerminateActivities().getActivityIdentifierArray();
        TerminateActivityResponseType[] result = new TerminateActivityResponseType[requestedActivities.length];
        Home localHome = this.kernel.getHome("BESActivity");
        Map<String, Boolean> eprMap = this.checkIfAccessible(requestedActivities);
        int counter = 0;
        for (EndpointReferenceType requested : requestedActivities) {
            result[counter] = TerminateActivityResponseType.Factory.newInstance();
            result[counter].setActivityIdentifier(requested);
            BESActivityImpl besActivity = null;
            try {
                besActivity = (BESActivityImpl)localHome.get(WSServerUtilities.extractResourceID((EndpointReferenceType)requested));
            }
            catch (Exception r) {
                Fault soapFault = BESUtils.buildSOAP11Fault((QName)UnknownActivityIdentifierFaultNS, (String)"Given activity doesn't exist");
                result[counter].setFault(soapFault);
                ++counter;
                continue;
            }
            Boolean accessible = eprMap.get(requested.getAddress().getStringValue());
            String activityId = WSUtilities.extractResourceID((EndpointReferenceType)requested);
            if (Boolean.TRUE.equals(accessible)) {
                try {
                    ActivityStatusDocument status = besActivity.getStatusProperty();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)status.toString());
                    }
                    try {
                        XNJSFacade.get((String)this.xnjsReference, (Kernel)this.kernel).getManager().abort(activityId, this.getClient());
                    }
                    catch (Exception e) {
                        String desc = "Activity could not be cancelled";
                        result[counter].setFault(BESUtils.buildSOAP11Fault((QName)new QName("TerminateActivityFault"), (String)desc));
                        ++counter;
                        continue;
                    }
                    result[counter].setTerminated(true);
                }
                catch (Exception ex) {
                    String desc = "Activity could not be cancelled: Error getting activity info.";
                    result[counter].setFault(BESUtils.buildSOAP11Fault((QName)new QName("TerminateActivityFault"), (String)desc));
                }
            } else {
                result[counter].setFault(BESUtils.buildSOAP11Fault((QName)UnknownActivityIdentifierFaultNS, (String)"Activity does not exist."));
            }
            ++counter;
        }
        TerminateActivitiesResponseDocument res = TerminateActivitiesResponseDocument.Factory.newInstance();
        res.addNewTerminateActivitiesResponse().setResponseArray(result);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)res.toString());
        }
        return res;
    }

    public UpdateResourcePropertiesResponseDocument UpdateResourceProperties(UpdateResourcePropertiesDocument in) throws BaseFault {
        logger.debug((Object)"Updating IsAcceptingNewActivitiesProperty resource property");
        XmlCursor updateCursor = in.getUpdateResourceProperties().getUpdate().newCursor();
        updateCursor.toFirstContentToken();
        this.properties.put(RPIsAcceptingNewActivities, new IsAcceptingNewActivitiesRP(Boolean.valueOf(updateCursor.getTextValue())));
        updateCursor.dispose();
        UpdateResourcePropertiesResponseDocument updateResDoc = UpdateResourcePropertiesResponseDocument.Factory.newInstance();
        updateResDoc.addNewUpdateResourcePropertiesResponse();
        this.setDirty();
        return updateResDoc;
    }

    protected void createAdditionalStorages() {
        Collection storages = this.uasProperties.getAddonStorages();
        for (StorageDescription a : storages) {
            this.createStorageResource(a);
            logger.debug((Object)("Added " + a.toString()));
        }
    }

    protected void createStorageResource(StorageDescription sd) {
        logger.debug((Object)"Creating Storage Resource");
        StorageReferenceResourceProperty srp = (StorageReferenceResourceProperty)this.properties.get(TargetSystemImpl.RPStorageReference);
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        initMap.put(SMSBaseImpl.INIT_STORAGE_DESCRIPTION, sd);
        Calendar tt = Calendar.getInstance();
        tt.add(1, 50);
        initMap.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", tt);
        initMap.put(INITPARAM_XNJS_REFERENCE, this.xnjsReference);
        EndpointReferenceType smsEpr = this.createStorageManagement(initMap);
        srp.add(smsEpr);
    }

    protected EndpointReferenceType createStorageManagement(Map<String, Object> initParam) {
        try {
            logger.debug((Object)"Creating Storage Management Resource");
            String id = this.kernel.getHome("StorageManagement").createWSRFServiceInstance(initParam);
            return WSServerUtilities.makeEPR((String)"StorageManagement", (String)id, (QName)StorageManagement.SMS_PORT, (Kernel)this.kernel);
        }
        catch (Exception e) {
            logger.warn((Object)"Could not create storage management service.", (Throwable)e);
            return null;
        }
    }

    protected EndpointReferenceType createJobInstance(Map<String, Object> initParam) throws Exception {
        String id = this.kernel.getHome("BESActivity").createWSRFServiceInstance(initParam);
        return WSServerUtilities.makeEPR((String)"BESActivity", (String)id, (QName)BESActivity.ACTIVITY_PORT, (Kernel)this.kernel);
    }

    protected void checkAndExtendLT(Calendar newTT) throws UnableToSetTerminationTimeException {
        if (this.getTerminationTime().compareTo(newTT) < 0) {
            logger.debug((Object)"Job termination time exceeds BES termination time, extending BES lifetime...");
            Calendar tt = (Calendar)newTT.clone();
            tt.add(5, 1);
            this.setTerminationTime(tt);
        }
    }

    public XmlObject getResourcePropertyResponseDocument() {
        return this.getResourcePropertyResponseDocument(null);
    }

    public XmlObject getResourcePropertyResponseDocument(GetFactoryAttributesDocumentType getFactAttType) {
        Node node;
        FactoryResourceAttributesDocumentDocument1 fDoc = FactoryResourceAttributesDocumentDocument1.Factory.newInstance();
        FactoryResourceAttributesDocumentType factoryAttributesType = fDoc.addNewFactoryResourceAttributesDocument();
        int num = 0;
        try {
            num = ((TotalNumberOfActivitiesRP)((Object)this.properties.get(RPTotalNumberOfActivities))).update().getProperty();
        }
        catch (Exception e1) {
            logger.error((Object)"Couldn't get TotalNumberOfActivities RP: ", (Throwable)e1);
        }
        factoryAttributesType.setTotalNumberOfActivities((long)num);
        factoryAttributesType.setTotalNumberOfContainedResources(0L);
        if (getFactAttType == null) {
            GetFactoryAttributesDocumentDocument1 getFactAttDoc = GetFactoryAttributesDocumentDocument1.Factory.newInstance();
            getFactAttType = getFactAttDoc.addNewGetFactoryAttributesDocument();
        }
        if ((node = getFactAttType.getDomNode()).getFirstChild() != null) {
            logger.debug((Object)"BasicFilter is present.");
            NodeList nList = node.getFirstChild().getChildNodes();
            for (int i = 0; i < nList.getLength(); ++i) {
                Node n = nList.item(i);
                if (!n.getNodeName().contains("ActivityReferences") || !n.getFirstChild().getNodeValue().equals("true") || num <= 0) continue;
                factoryAttributesType.addNewActivityReference();
                factoryAttributesType.setActivityReferenceArray(this.getFilteredActivityReferenceProperty().getProperty());
            }
        } else {
            if (num > 0) {
                factoryAttributesType.addNewActivityReference();
                factoryAttributesType.setActivityReferenceArray(this.getFilteredActivityReferenceProperty().getProperty());
            }
            factoryAttributesType.setIsAcceptingNewActivities(this.getIsAcceptingNewActivitiesProperty().getProperty().booleanValue());
        }
        factoryAttributesType.setLocalResourceManagerType((String)((ResourceProperty)this.properties.get(BESFactory.RPLocalResourceManagerType)).getProperty());
        factoryAttributesType.setCommonName((String)((ResourceProperty)this.properties.get(BESFactory.RPCommonName)).getProperty());
        factoryAttributesType.setLongDescription((String)((ResourceProperty)this.properties.get(BESFactory.RPLongDescription)).getProperty());
        factoryAttributesType.setNamingProfileArray(new String[]{(String)((ResourceProperty)this.properties.get(BESFactory.RPNamingProfile)).getProperty()});
        factoryAttributesType.setBESExtensionArray((String[])((ResourceProperty)this.properties.get(BESFactory.RPBESExtension)).getProperty());
        try {
            BasicResourceAttributesDocumentRP basicResourceRP = ((BasicResourceAttributesDocumentRP)((Object)this.properties.get(BESFactory.RPBasicResourceAttributes))).update();
            logger.debug((Object)basicResourceRP.getProperty().toString());
            factoryAttributesType.setBasicResourceAttributesDocument(basicResourceRP.getProperty());
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't add Basic Resource Attributes Document", (Throwable)e);
        }
        if (this.useGlue) {
            GlueAttributesRP glueRP = (GlueAttributesRP)((Object)this.properties.get(BESFactory.RPGlueProperties));
            factoryAttributesType.setDomains(glueRP.getXml()[0].getDomains());
        }
        factoryAttributesType.setCurrentTime(this.getCurrentTime());
        TerminationTimeDocument.TerminationTime tt = TerminationTimeDocument.TerminationTime.Factory.newInstance();
        tt.setCalendarValue(this.getTerminationTime());
        factoryAttributesType.setTerminationTime(tt);
        factoryAttributesType.setWSResourceInterfaces(this.getWSResourceInterfaces().getWSResourceInterfaces());
        factoryAttributesType.setFinalWSResourceInterface(this.getFinalWSInterface());
        factoryAttributesType.setResourceEndpointReference(this.getEPR());
        factoryAttributesType.setResourcePropertyNames(this.getRPNames().getResourcePropertyNames());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("FactoryAttributesDocument: " + fDoc.toString()));
        }
        return fDoc;
    }

    protected Map<String, Boolean> checkIfAccessible(EndpointReferenceType[] requestedEPRs) {
        FilteredActivityReferenceRP ap = this.getFilteredActivityReferenceProperty();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (EndpointReferenceType epr : requestedEPRs) {
            String url = epr.getAddress().getStringValue();
            boolean canAccess = ap.isAccessible(epr);
            result.put(url, canAccess);
        }
        return result;
    }

    public QName getResourcePropertyDocumentQName() {
        return FactoryResourceAttributesDocumentDocument1.type.getDocumentElementName();
    }

    public QName getPortType() {
        return BES_PORT;
    }

    protected void checkJobValidity(JobDefinitionType jobType) throws InvalidRequestMessageFault {
    }

    public ActivityReferenceRP getActivityReferenceProperty() {
        return (ActivityReferenceRP)((Object)this.properties.get(BESFactory.RPActivityReference));
    }

    public FilteredActivityReferenceRP getFilteredActivityReferenceProperty() {
        return (FilteredActivityReferenceRP)((Object)this.properties.get(BESFactory.RPFilteredActivityReference));
    }

    public IsAcceptingNewActivitiesRP getIsAcceptingNewActivitiesProperty() {
        return (IsAcceptingNewActivitiesRP)((Object)this.properties.get(BESFactory.RPIsAcceptingNewActivities));
    }

    public CurrentTimeDocument.CurrentTime getCurrentTime() {
        CurrentTimeDocument.CurrentTime ct = CurrentTimeDocument.CurrentTime.Factory.newInstance();
        ct.setCalendarValue(Calendar.getInstance());
        return ct;
    }

    public QName getFinalWSInterface() {
        ImmutableResourceProperty imp = (ImmutableResourceProperty)this.properties.get(BPSupportImpl.RPFinalWSResourceInterface);
        return ((FinalWSResourceInterfaceDocument)imp.getXml()[0]).getFinalWSResourceInterface();
    }

    public ResourcePropertyNamesDocument getRPNames() {
        try {
            ImmutableResourceProperty imp = (ImmutableResourceProperty)BPSupportImpl.getRPNamesProperty(this.properties.keySet());
            return (ResourcePropertyNamesDocument)imp.getXml()[0];
        }
        catch (Exception e) {
            LogUtil.logException((String)"Couldn't get resource property names: ", (Throwable)e, (Logger)logger);
            return null;
        }
    }

    public DestroyResponseDocument Destroy(DestroyDocument in) throws ResourceNotDestroyedFault, ResourceUnknownFault, ResourceUnavailableFault {
        throw ResourceNotDestroyedFault.createFault((String)"Not destroyed.");
    }

    public SetTerminationTimeResponseDocument SetTerminationTime(SetTerminationTimeDocument in) throws UnableToSetTerminationTimeFault, TerminationTimeChangeRejectedFault, ResourceUnknownFault, ResourceUnavailableFault {
        throw TerminationTimeChangeRejectedFault.createFault((String)"Not changed.");
    }
}

