/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.impl.activity;

import de.fzj.unicore.bes.BESActivity;
import de.fzj.unicore.bes.activity.rp.ActivityDocumentRP;
import de.fzj.unicore.bes.activity.rp.ActivityFactoryReferenceRP;
import de.fzj.unicore.bes.activity.rp.StatusRP;
import de.fzj.unicore.bes.util.BESProperties;
import de.fzj.unicore.uas.JobManagement;
import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.impl.bp.BPSupportImpl;
import de.fzj.unicore.uas.impl.job.JobManagementImpl;
import de.fzj.unicore.uas.impl.job.StdErrProperty;
import de.fzj.unicore.uas.impl.job.StdOutProperty;
import de.fzj.unicore.uas.impl.job.WorkingDirResourceProperty;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.impl.sms.StorageManagementHomeImpl;
import de.fzj.unicore.uas.impl.tss.rp.StorageReferenceResourceProperty;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.messaging.Message;
import de.fzj.unicore.wsrflite.messaging.ResourceDeletedMessage;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import de.fzj.unicore.xnjs.ems.Action;
import eu.unicore.security.Client;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.bes.x2006.x08.besActivity.ActivityResourceAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besActivity.ActivityResourceAttributesDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusDocument;
import org.unigrids.x2006.x04.services.jms.AbortDocument;
import org.unigrids.x2006.x04.services.jms.AbortResponseDocument;
import org.unigrids.x2006.x04.services.jms.HoldDocument;
import org.unigrids.x2006.x04.services.jms.HoldResponseDocument;
import org.unigrids.x2006.x04.services.jms.ResumeDocument;
import org.unigrids.x2006.x04.services.jms.ResumeResponseDocument;
import org.unigrids.x2006.x04.services.jms.StartDocument;
import org.unigrids.x2006.x04.services.jms.StartResponseDocument;
import org.unigrids.x2006.x04.services.jms.SubmissionTimeDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class BESActivityImpl
extends UASWSResourceImpl
implements BESActivity {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", BESActivityImpl.class);
    @Persist
    private String factoryID;

    protected void addWSResourceInterfaces(BPSupportImpl baseProfile) {
        super.addWSResourceInterfaces(baseProfile);
        baseProfile.addWSResourceInterface(ACTIVITY_PORT);
    }

    public QName getPortType() {
        return ACTIVITY_PORT;
    }

    public void initialise(String serviceName, Map<String, Object> initParams) throws Exception {
        Action action = (Action)initParams.get(BESActivity.INIT_ACTION_KEY);
        initParams.put(INIT_UNIQUE_ID, action.getUUID());
        super.initialise(serviceName, initParams);
        EndpointReferenceDocument factoryEPR = (EndpointReferenceDocument)initParams.get(BESActivity.FACTORY_REF_KEY);
        this.factoryID = WSServerUtilities.extractResourceID((EndpointReferenceType)factoryEPR.getEndpointReference());
        ActivityDocumentDocument1 aDoc = (ActivityDocumentDocument1)initParams.get(BESActivity.ACTIVITY_DOC_KEY);
        BESProperties cfg = (BESProperties)((Object)this.kernel.getAttribute(BESProperties.class));
        if ("bes".equals(cfg.getValue("jobMode"))) {
            action.getProcessingContext().put((Object)"EMS_AUTOSUBMIT", (Object)Boolean.TRUE);
        }
        logger.info((Object)("Submitting BESActivity <" + this.getUniqueID() + "> for client " + this.getClient()));
        XNJSFacade.get((String)this.xnjsReference, (Kernel)this.kernel).getConfiguration().getEMSManager().add(action, this.getClient());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The Factory EPR in Activity Service:  " + factoryEPR.toString()));
            logger.debug((Object)("BESActivity: " + aDoc.toString()));
            logger.debug((Object)("activity status in properties map:  " + this.properties.get(RPStatus)));
        }
        this.properties.put(BESActivity.RPStatus, new StatusRP((Resource)this, this.xnjsReference, this.getUniqueID()));
        this.properties.put(BESActivity.RPFactoryReference, new ActivityFactoryReferenceRP(factoryEPR));
        this.properties.put(BESActivity.RPActivityDocument, new ActivityDocumentRP(aDoc));
        WorkingDirResourceProperty workDir = new WorkingDirResourceProperty(this.createUspace(action, this.getClient()));
        this.properties.put(JobManagement.RPWorkingDir, workDir);
        EndpointReferenceType[] smsEprs = (EndpointReferenceType[])initParams.get("uas.jobmanagement.SMS");
        if (smsEprs != null) {
            StorageReferenceResourceProperty sp = new StorageReferenceResourceProperty(smsEprs);
            this.properties.put(JobManagementImpl.RPStorageReference, sp);
        }
        this.properties.put(JobManagementImpl.STDOUT, new StdOutProperty((Resource)this, action.getUUID(), this.xnjsReference));
        this.properties.put(JobManagementImpl.STDERR, new StdErrProperty((Resource)this, action.getUUID(), this.xnjsReference));
        SubmissionTimeDocument std = SubmissionTimeDocument.Factory.newInstance();
        std.setSubmissionTime(Calendar.getInstance());
        this.properties.put(JobManagementImpl.RPSubmissionTime, new ImmutableResourceProperty((XmlObject)std));
        this.setDirty();
        if (Boolean.TRUE.equals(initParams.get(INITPARAM_PUBLISH_TO_REGISTRY))) {
            logger.debug((Object)"Publishing into the Registry");
            this.publish();
        }
    }

    protected EndpointReferenceType createStorageManagementService(Map<String, Object> initParams) {
        try {
            Home smsHome = this.kernel.getHome("StorageManagement");
            String id = smsHome.createWSRFServiceInstance(initParams);
            return WSServerUtilities.makeEPR((String)"StorageManagement", (String)id, (QName)StorageManagement.SMS_PORT, (Kernel)this.kernel);
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not create storage for job", (Throwable)e, (Logger)logger);
            return null;
        }
    }

    protected EndpointReferenceType createUspace(Action a, Client c) {
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        StorageDescription description = new StorageDescription("Uspace-" + this.getUniqueID(), "Uspace", a.getExecutionContext().getWorkingDirectory(), StorageManagementHomeImpl.StorageTypes.VARIABLE, null, null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), a.getUmask(), "Job's workspace", null);
        initMap.put(SMSBaseImpl.INIT_STORAGE_DESCRIPTION, description);
        initMap.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", this.getResourcePropertyObject(RPterminationTimeQName));
        initMap.put(INITPARAM_XNJS_REFERENCE, this.xnjsReference);
        return this.createStorageManagementService(initMap);
    }

    public XmlObject getResourcePropertyResponseDocument() {
        ActivityResourceAttributesDocumentDocument1 attributeDoc = ActivityResourceAttributesDocumentDocument1.Factory.newInstance();
        ActivityResourceAttributesDocumentType at = attributeDoc.addNewActivityResourceAttributesDocument();
        ActivityFactoryReferenceRP factoryRefRP = (ActivityFactoryReferenceRP)((Object)this.properties.get(RPFactoryReference));
        at.setFactoryReference(factoryRefRP.getFactoryEPR().getEndpointReference());
        ActivityDocumentRP activityDocRP = (ActivityDocumentRP)((Object)this.properties.get(RPActivityDocument));
        at.setActivityDocument(activityDocRP.getActivityDoc().getActivityDocument());
        StatusRP statusRP = (StatusRP)((Object)this.properties.get(RPStatus));
        at.setStatus(statusRP.getXml()[0].getActivityStatus());
        at.setActivityDocument(activityDocRP.getActivityDoc().getActivityDocument());
        at.setFactoryReference(factoryRefRP.getFactoryEPR().getEndpointReference());
        return attributeDoc;
    }

    public QName getResourcePropertyDocumentQName() {
        return ActivityResourceAttributesDocumentDocument1.type.getDocumentElementName();
    }

    public void destroy() {
        try {
            ResourceDeletedMessage m = new ResourceDeletedMessage((Serializable)((Object)("deleted:" + this.getUniqueID())));
            m.setServiceName(this.getServiceName());
            m.setDeletedResource(this.getUniqueID());
            this.kernel.getMessaging().getChannel(this.factoryID).publish((Message)m);
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not send internal message.", (Throwable)e, (Logger)logger);
        }
        try {
            XNJSFacade.get((String)this.xnjsReference, (Kernel)this.kernel).destroyAction(this.getUniqueID(), this.getClient());
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not destroy job on XNJS.", (Throwable)e, (Logger)logger);
        }
        super.destroy();
    }

    public StartResponseDocument Start(StartDocument in) throws BaseFault {
        StartResponseDocument res = StartResponseDocument.Factory.newInstance();
        try {
            XNJSFacade.get((String)this.xnjsReference, (Kernel)this.kernel).getManager().run(this.getUniqueID(), this.getClient());
            res.addNewStartResponse();
            logger.info((Object)("Started " + this.getUniqueID()));
            return res;
        }
        catch (Exception e) {
            String msg = "Could not start job " + this.getUniqueID();
            LogUtil.logException((String)msg, (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)msg, (Throwable)e);
        }
    }

    public AbortResponseDocument Abort(AbortDocument in) throws BaseFault {
        AbortResponseDocument res = AbortResponseDocument.Factory.newInstance();
        try {
            XNJSFacade.get((String)this.xnjsReference, (Kernel)this.kernel).getManager().abort(this.getUniqueID(), this.getClient());
            res.addNewAbortResponse();
            return res;
        }
        catch (Exception e) {
            String msg = "Could not abort job " + this.getUniqueID();
            LogUtil.logException((String)msg, (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)msg, (Throwable)e);
        }
    }

    public HoldResponseDocument Hold(HoldDocument in) throws BaseFault {
        HoldResponseDocument res = HoldResponseDocument.Factory.newInstance();
        try {
            XNJSFacade.get((String)this.xnjsReference, (Kernel)this.kernel).getManager().pause(this.getUniqueID(), this.getClient());
            res.addNewHoldResponse();
            return res;
        }
        catch (Exception e) {
            String msg = "Could not hold job " + this.getUniqueID();
            LogUtil.logException((String)msg, (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)msg, (Throwable)e);
        }
    }

    public ResumeResponseDocument Resume(ResumeDocument in) throws BaseFault {
        ResumeResponseDocument res = ResumeResponseDocument.Factory.newInstance();
        try {
            XNJSFacade.get((String)this.xnjsReference, (Kernel)this.kernel).getManager().resume(this.getUniqueID(), this.getClient());
            res.addNewResumeResponse();
            return res;
        }
        catch (Exception e) {
            String msg = "Could not resume job " + this.getUniqueID();
            LogUtil.logException((String)msg, (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)msg, (Throwable)e);
        }
    }

    public ActivityStatusDocument getStatusProperty() throws Exception {
        StatusRP statusRP = (StatusRP)((Object)this.properties.get(RPStatus));
        ActivityStatusDocument asDoc = statusRP.update().getProperty();
        return asDoc;
    }

    public EndpointReferenceDocument getActivityFactoryReferenceProperty() throws Exception {
        ActivityFactoryReferenceRP factoryRP = (ActivityFactoryReferenceRP)((Object)this.properties.get(RPFactoryReference));
        return factoryRP.getFactoryEPR();
    }

    public ActivityDocumentDocument1 getActivityDocumentProperty() {
        ActivityDocumentRP activityDocRP = (ActivityDocumentRP)((Object)this.properties.get(RPActivityDocument));
        return activityDocRP.getActivityDoc();
    }

    public String getActivityLog() {
        try {
            StringBuilder sb = new StringBuilder();
            List l = XNJSFacade.get((String)this.xnjsReference, (Kernel)this.kernel).getAction(this.getUniqueID()).getLog();
            for (String s : l) {
                sb.append(s).append("\n");
            }
            return sb.toString();
        }
        catch (Exception ex) {
            return "Error getting activity log: " + ex;
        }
    }
}

