/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.factory.rp;

import de.fzj.unicore.bes.impl.factory.BESFactoryImpl;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ApplicationEnvironmentT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ApplicationEnvironmentsDocument;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingEndpointT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingManagerT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingServiceT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.DomainsDocument;

public class GlueAttributesRP
extends ResourceProperty<DomainsDocument> {
    private static final long serialVersionUID = -4931735801831100110L;
    private DomainsDocument domainsDoc;
    private final String xnjsReference;
    private final String endpointId = "urn:fzj:jsc:vsgc:bes";

    public GlueAttributesRP(BESFactoryImpl parent, DomainsDocument domain, String xnjsReference) {
        super((Resource)parent);
        this.domainsDoc = domain;
        this.xnjsReference = xnjsReference;
    }

    public DomainsDocument[] getXml() {
        this.embedBESProperties();
        return new DomainsDocument[]{this.domainsDoc};
    }

    public void setProperty(DomainsDocument setTo) {
        this.domainsDoc = setTo;
    }

    protected void embedBESProperties() {
        String issuerCa;
        Kernel kernel = this.parentWSResource.getKernel();
        ComputingServiceT cs = this.domainsDoc.getDomains().getAdminDomainArray()[0].getComputingServiceArray()[0];
        ComputingEndpointT ct = cs.getComputingEndpointArray()[0];
        String url = kernel.getContainerProperties().getBaseUrl() + "/" + this.parentWSResource.getServiceName();
        String wsdl = url + "?wsdl";
        ct.setWSDLArray(new String[]{wsdl});
        ct.setStartTime(kernel.getUpSince());
        ct.setInterfaceName("OGSABES:" + this.parentWSResource.getServiceName());
        ct.setID("urn:fzj:jsc:vsgc:bes:" + this.parentWSResource.getUniqueID());
        if (((BESFactoryImpl)this.parentWSResource).getOwner() != null && (issuerCa = ((BESFactoryImpl)this.parentWSResource).getOwner().getName()) != null) {
            ct.setIssuerCA(issuerCa);
        }
        ct.setURL(url);
        ComputingManagerT crt = null;
        if (this.getApplicationTypes().getApplicationEnvironmentArray().length > 0) {
            crt = ComputingManagerT.Factory.newInstance();
            crt.setApplicationEnvironments(this.getApplicationTypes());
            cs.setComputingManagerArray(new ComputingManagerT[]{crt});
        }
    }

    protected ApplicationEnvironmentsDocument.ApplicationEnvironments getApplicationTypes() {
        Kernel kernel = this.parentWSResource.getKernel();
        ApplicationInfo[] appsInfo = XNJSFacade.get((String)this.xnjsReference, (Kernel)kernel).getDefinedApplications();
        ApplicationEnvironmentsDocument.ApplicationEnvironments appEnvs = ApplicationEnvironmentsDocument.ApplicationEnvironments.Factory.newInstance();
        for (int i = 0; i < appsInfo.length; ++i) {
            ApplicationEnvironmentT appt = appEnvs.addNewApplicationEnvironment();
            appt.setAppName(appsInfo[i].getApplicationName());
            appt.setAppVersion(appsInfo[i].getApplicationVersion());
        }
        return appEnvs;
    }
}

