/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.factory.rp;

import de.fzj.unicore.bes.impl.factory.BESFactoryImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import eu.unicore.security.Client;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class FilteredActivityReferenceRP
extends ResourceProperty<EndpointReferenceType[]> {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", FilteredActivityReferenceRP.class);

    public FilteredActivityReferenceRP(BESFactoryImpl parent) {
        super((Resource)parent);
    }

    public EndpointReferenceDocument[] getXml() {
        ArrayList<EndpointReferenceDocument> result = new ArrayList<EndpointReferenceDocument>();
        EndpointReferenceDocument[] eprs = null;
        try {
            eprs = (EndpointReferenceDocument[])((BESFactoryImpl)this.parentWSResource).getActivityReferenceProperty().update().getXml();
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't fetch EPRs ", (Throwable)e);
            eprs = new EndpointReferenceDocument[]{};
        }
        for (EndpointReferenceDocument epr : eprs) {
            if (!this.isAccessible(epr.getEndpointReference())) continue;
            result.add(epr);
        }
        return result.toArray(new EndpointReferenceDocument[result.size()]);
    }

    public boolean isAccessible(EndpointReferenceType epr) {
        try {
            Client c = ((BESFactoryImpl)this.parentWSResource).getClient();
            String serviceName = "BESActivity";
            String wsResourceID = WSServerUtilities.extractResourceID((EndpointReferenceType)epr);
            String ownerDN = ((BESFactoryImpl)this.parentWSResource).getOwnerForActivity(wsResourceID);
            Map voMembership = ((BESFactoryImpl)this.parentWSResource).getVOMembership();
            return this.parentWSResource.getKernel().getSecurityManager().isAccessible(c, serviceName, wsResourceID, ownerDN, voMembership);
        }
        catch (Exception ex) {
            LogUtil.logException((String)"Cannot access server endpoint.", (Throwable)ex, (Logger)logger);
            return false;
        }
    }

    public EndpointReferenceType[] getProperty() {
        ArrayList<EndpointReferenceType> result = new ArrayList<EndpointReferenceType>();
        EndpointReferenceType[] eprs = null;
        try {
            eprs = (EndpointReferenceType[])((BESFactoryImpl)this.parentWSResource).getActivityReferenceProperty().update().getProperty();
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't fetch EPRs ", (Throwable)e);
            eprs = new EndpointReferenceType[]{};
        }
        for (EndpointReferenceType epr : eprs) {
            if (!this.isAccessible(epr)) continue;
            result.add(epr);
        }
        return result.toArray(new EndpointReferenceType[result.size()]);
    }
}

