/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.factory.rp;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.impl.SecuredResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import eu.unicore.security.Client;
import org.ggf.schemas.bes.x2006.x08.besFactory.BasicResourceAttributesDocumentType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeValueType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

public class BasicResourceAttributesDocumentRP
extends ResourceProperty<BasicResourceAttributesDocumentType> {
    private static final long serialVersionUID = 2195249725570941816L;
    BasicResourceAttributesDocumentType resourceDoc = null;
    private final String xnjsReference;

    public BasicResourceAttributesDocumentRP(Resource res, String xnjsRef) {
        super(res);
        this.xnjsReference = xnjsRef;
        this.resourceDoc = BasicResourceAttributesDocumentType.Factory.newInstance();
    }

    public BasicResourceAttributesDocumentType[] getXml() {
        return new BasicResourceAttributesDocumentType[]{this.resourceDoc};
    }

    public BasicResourceAttributesDocumentRP update() throws Exception {
        Client client = ((SecuredResourceImpl)this.parentWSResource).getClient();
        Kernel kernel = this.parentWSResource.getKernel();
        ResourcesType res = XNJSFacade.get((String)this.xnjsReference, (Kernel)kernel).getResources(client);
        if (res.getCPUArchitecture() != null) {
            this.resourceDoc.setCPUArchitecture(res.getCPUArchitecture());
        }
        if (res.getTotalPhysicalMemory() != null) {
            this.resourceDoc.setPhysicalMemory(this.getMaximum(res.getTotalPhysicalMemory()));
        }
        if (res.getTotalCPUCount() != null) {
            this.resourceDoc.setCPUCount(this.getMaximum(res.getTotalCPUCount()));
        } else if (res.getIndividualCPUCount() != null && res.getTotalResourceCount() != null) {
            int nodes = (int)this.getMaximum(res.getTotalResourceCount());
            int cpusPerNode = (int)this.getMaximum(res.getIndividualCPUCount());
            this.resourceDoc.setCPUCount((double)(nodes * cpusPerNode));
        }
        if (res.getOperatingSystem() != null) {
            this.resourceDoc.setOperatingSystem(res.getOperatingSystem());
        }
        return this;
    }

    public BasicResourceAttributesDocumentType getProperty() {
        return this.resourceDoc;
    }

    private double getMaximum(RangeValueType range) {
        double value = 0.0;
        try {
            value = range.getRangeArray()[0].getUpperBound().getDoubleValue();
        }
        catch (Exception e) {
            value = range.getExactArray()[0].getDoubleValue();
        }
        return value;
    }
}

