/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.factory.rp;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class BESExtensionRP
extends ResourceProperty<String[]> {
    private static final long serialVersionUID = -5936988679686360462L;
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", BESExtensionRP.class);
    private final XmlObject[] extensions;
    private final String[] extArray;

    public BESExtensionRP(String str) {
        super(null);
        if (str != null) {
            logger.info((Object)("BESExtension support: " + str));
            this.extArray = str.split(" +");
            this.extensions = this.formatExtensions(this.extArray);
        } else {
            this.extArray = new String[0];
            this.extensions = new XmlObject[0];
        }
    }

    public XmlObject[] getXml() {
        return this.extensions;
    }

    private XmlObject[] formatExtensions(String[] extensions) {
        ArrayList<XmlObject> res = new ArrayList<XmlObject>();
        for (String ext : extensions) {
            String result = "<bes:BESExtension xmlns:bes='http://schemas.ggf.org/bes/2006/08/bes-factory'>" + ext + "</bes:BESExtension>";
            logger.debug((Object)("bes-ext: " + ext));
            try {
                res.add(XmlObject.Factory.parse((String)result));
            }
            catch (XmlException e1) {
                logger.error((Object)("Invalid extension: " + ext), (Throwable)e1);
            }
        }
        return res.toArray(new XmlObject[res.size()]);
    }

    public String[] getProperty() {
        return this.extArray;
    }
}

