/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.factory.rp;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public abstract class ActivityBaseProperty
extends ResourceProperty<EndpointReferenceType[]> {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", ActivityBaseProperty.class);
    private String ACTIVITY_BASE;
    private List<String> uuids = new ArrayList<String>();

    public ActivityBaseProperty(Resource p) {
        super(p);
        this.ACTIVITY_BASE = WSServerUtilities.makeAddress((String)"BESActivity", (String)"", (ContainerProperties)p.getKernel().getContainerProperties());
    }

    public ActivityBaseProperty() {
        this(null);
    }

    public void setProperty(EndpointReferenceType[] types) {
        ArrayList<String> newUuids = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            newUuids.add(WSServerUtilities.extractResourceID((EndpointReferenceType)types[i]));
        }
        this.uuids = newUuids;
    }

    public int getNumberOfElements() {
        return this.uuids.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EndpointReferenceType epr) {
        List<String> list = this.uuids;
        synchronized (list) {
            this.uuids.add(WSServerUtilities.extractResourceID((EndpointReferenceType)epr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) {
        List<String> list = this.uuids;
        synchronized (list) {
            Iterator<String> it = this.uuids.iterator();
            while (it.hasNext()) {
                try {
                    if (!it.next().equals(id)) continue;
                    it.remove();
                    logger.debug((Object)("Removed " + id));
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointReferenceType[] getProperty() {
        EndpointReferenceType[] res = new EndpointReferenceType[this.uuids.size()];
        int i = 0;
        String[] idArr = null;
        List<String> list = this.uuids;
        synchronized (list) {
            idArr = this.uuids.toArray(new String[this.uuids.size()]);
        }
        for (String uuid : idArr) {
            res[i++] = this.makeEPR(uuid);
        }
        return res;
    }

    protected EndpointReferenceType makeEPR(String id) {
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        epr.addNewAddress().setStringValue(this.ACTIVITY_BASE + id);
        return epr;
    }

    public List<String> getUUIDs() {
        return this.uuids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<String> ids) {
        List<String> list = this.uuids;
        synchronized (list) {
            this.uuids.addAll(ids);
        }
    }
}

