/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.activity.rp;

import de.fzj.unicore.bes.util.BESUtils;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusType;
import org.ogf.schemas.hpcp.x2007.x01.fs.ExecutingDocument;
import org.ogf.schemas.hpcp.x2007.x01.fs.QueuedDocument;
import org.ogf.schemas.hpcp.x2007.x01.fs.ReadyDocument;
import org.ogf.schemas.hpcp.x2007.x01.fs.StagingInDocument;
import org.ogf.schemas.hpcp.x2007.x01.fs.StagingOutDocument;
import org.ogf.schemas.hpcp.x2007.x01.fs.StartingDocument;
import org.xmlsoap.schemas.soap.envelope.Fault;

public final class BESActivityConverter {
    public static synchronized ActivityStatusDocument getBESStatefromXNJSState(Kernel k, String xnjsReference, String actionId, Integer status) {
        ActivityStatusType aType = ActivityStatusType.Factory.newInstance();
        ActivityStatusDocument aDoc = ActivityStatusDocument.Factory.newInstance();
        switch (status) {
            case 0: {
                aType.setState(ActivityStateEnumeration.PENDING);
                aDoc.setActivityStatus(aType);
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 22: {
                QueuedDocument qDoc = QueuedDocument.Factory.newInstance();
                qDoc.addNewQueued();
                aType.setState(ActivityStateEnumeration.RUNNING);
                aDoc.setActivityStatus(aType);
                WSServerUtilities.append((XmlObject)qDoc, (XmlObject)aDoc);
                break;
            }
            case 1: {
                aType.setState(ActivityStateEnumeration.RUNNING);
                aDoc.setActivityStatus(aType);
                StagingInDocument staginDoc = StagingInDocument.Factory.newInstance();
                staginDoc.addNewStagingIn();
                WSServerUtilities.append((XmlObject)staginDoc, (XmlObject)aDoc);
                break;
            }
            case 2: {
                aType.setState(ActivityStateEnumeration.RUNNING);
                aDoc.setActivityStatus(aType);
                ReadyDocument rDoc = ReadyDocument.Factory.newInstance();
                rDoc.addNewReady();
                WSServerUtilities.append((XmlObject)rDoc, (XmlObject)aDoc);
                break;
            }
            case 21: {
                aType.setState(ActivityStateEnumeration.RUNNING);
                aDoc.setActivityStatus(aType);
                StartingDocument sDoc = StartingDocument.Factory.newInstance();
                sDoc.addNewStarting();
                WSServerUtilities.append((XmlObject)sDoc, (XmlObject)aDoc);
                break;
            }
            case 5: {
                ExecutingDocument execDoc = ExecutingDocument.Factory.newInstance();
                execDoc.addNewExecuting();
                aType.setState(ActivityStateEnumeration.RUNNING);
                aDoc.setActivityStatus(aType);
                WSServerUtilities.append((XmlObject)execDoc, (XmlObject)aDoc);
                break;
            }
            case 6: {
                StagingOutDocument stagoutDoc = StagingOutDocument.Factory.newInstance();
                stagoutDoc.addNewStagingOut();
                aType.setState(ActivityStateEnumeration.RUNNING);
                aDoc.setActivityStatus(aType);
                WSServerUtilities.append((XmlObject)stagoutDoc, (XmlObject)aDoc);
                break;
            }
            case 7: {
                if (XNJSFacade.get((String)xnjsReference, (Kernel)k).getAction(actionId).getResult().isSuccessful()) {
                    aType.setState(ActivityStateEnumeration.FINISHED);
                    int exitCode = XNJSFacade.get((String)xnjsReference, (Kernel)k).getAction(actionId).getResult().getExitCode();
                    aType.setExitCode(exitCode);
                    aDoc.setActivityStatus(aType);
                    break;
                }
                if (XNJSFacade.get((String)xnjsReference, (Kernel)k).getAction(actionId).getResult().getStatusCode() == 1) {
                    aType.setState(ActivityStateEnumeration.CANCELLED);
                    aDoc.setActivityStatus(aType);
                    break;
                }
                aType.setState(ActivityStateEnumeration.FAILED);
                int exitCode = XNJSFacade.get((String)xnjsReference, (Kernel)k).getAction(actionId).getResult().getExitCode();
                String message = XNJSFacade.get((String)xnjsReference, (Kernel)k).getAction(actionId).getResult().getErrorMessage();
                Fault fault = BESUtils.buildSOAP11Fault((QName)new QName("http://schemas.ggf.org/bes/2006/08/bes-factory", "UnknownActivityExecutionFault"), (String)message);
                aType.setExitCode(exitCode);
                aType.setFault(fault);
                aDoc.setActivityStatus(aType);
            }
        }
        return aDoc;
    }
}

