/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlBeansUtils {
    public static void append(XmlObject what, XmlObject toWhere) {
        XmlCursor sourceCurs = what.newCursor();
        sourceCurs.toNextToken();
        XmlCursor targetCurs = toWhere.newCursor();
        targetCurs.toEndDoc();
        targetCurs.toPrevToken();
        sourceCurs.copyXml(targetCurs);
        sourceCurs.dispose();
        targetCurs.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QName getQNameFor(XmlObject o) {
        XmlCursor c = o.newCursor();
        try {
            c.toFirstChild();
            QName qName = c.getName();
            return qName;
        }
        finally {
            c.dispose();
        }
    }

    public static XmlObject[] extractAnyElements(XmlObject source, QName q) throws XmlException {
        NodeList nodes = source.getDomNode().getChildNodes();
        ArrayList<XmlObject> results = new ArrayList<XmlObject>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            XmlObject o;
            Node n = nodes.item(i);
            if (q != null) {
                if (!q.getNamespaceURI().equals(n.getNamespaceURI()) || !q.getLocalPart().equals(n.getLocalName())) continue;
                o = XmlObject.Factory.parse((Node)n);
                results.add(o);
                continue;
            }
            o = XmlObject.Factory.parse((Node)n);
            results.add(o);
        }
        return results.toArray(new XmlObject[results.size()]);
    }

    public static XmlObject extractFirstAnyElement(XmlObject source, QName q) throws XmlException, IOException {
        XmlCursor c = source.newCursor();
        if (XmlBeansUtils.skipToElement(c, q)) {
            XmlObject res = XmlObject.Factory.parse((InputStream)c.newInputStream());
            c.dispose();
            return res;
        }
        return null;
    }

    public static XmlObject extractFirstAnyElement(XmlObject source, QName[] q) throws XmlException, IOException {
        XmlCursor c = source.newCursor();
        if (XmlBeansUtils.skipToElement(c, q)) {
            XmlObject res = XmlObject.Factory.parse((InputStream)c.newInputStream());
            c.dispose();
            return res;
        }
        return null;
    }

    public static Map<String, String> extractAttributes(XmlObject source) {
        XmlCursor.TokenType type;
        HashMap<String, String> result = new HashMap<String, String>();
        XmlCursor curs = source.newCursor();
        while (curs.hasNextToken() && !XmlCursor.TokenType.END.equals(type = curs.toNextToken())) {
            if (!XmlCursor.TokenType.ATTR.equals(type)) continue;
            QName q = curs.getName();
            String val = curs.getTextValue();
            result.put(q.getLocalPart(), val);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractElementTextAsString(XmlObject source) {
        XmlCursor c = null;
        try {
            c = source.newCursor();
            while (c.hasNextToken()) {
                if (!c.toNextToken().equals(XmlCursor.TokenType.TEXT)) continue;
                String string = c.getChars();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            try {
                c.dispose();
            }
            catch (Exception e) {}
        }
    }

    public static boolean skipToElement(XmlCursor cursor, QName name) {
        if (name.equals(cursor.getName())) {
            return true;
        }
        boolean hasMoreChildren = true;
        int i = 0;
        while (hasMoreChildren) {
            if (!(hasMoreChildren = cursor.toChild(i++))) continue;
            boolean foundInChild = XmlBeansUtils.skipToElement(cursor, name);
            if (foundInChild) {
                return true;
            }
            cursor.toParent();
        }
        return false;
    }

    public static boolean skipToElement(XmlCursor cursor, QName[] names) {
        for (QName name : names) {
            if (!name.equals(cursor.getName())) continue;
            return true;
        }
        boolean hasMoreChildren = true;
        int i = 0;
        while (hasMoreChildren) {
            if (!(hasMoreChildren = cursor.toChild(i++))) continue;
            boolean foundInChild = XmlBeansUtils.skipToElement(cursor, names);
            if (foundInChild) {
                return true;
            }
            cursor.toParent();
        }
        return false;
    }

    public static String getElementText(XmlObject source, QName[] names) {
        try {
            XmlObject o = XmlBeansUtils.extractFirstAnyElement(source, names);
            return XmlBeansUtils.extractElementTextAsString(o);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getElementText(XmlObject source, QName name) {
        try {
            XmlObject o = XmlBeansUtils.extractFirstAnyElement(source, name);
            if (o == null) {
                return null;
            }
            return XmlBeansUtils.extractElementTextAsString(o);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getAttributeText(XmlObject source, QName elementName, QName attributeName) {
        try {
            XmlObject o = XmlBeansUtils.extractFirstAnyElement(source, elementName);
            if (o == null) {
                return null;
            }
            return XmlBeansUtils.getAttributeText(o, attributeName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAttributeText(XmlObject source, QName attributeName) {
        XmlCursor c = source.newCursor();
        try {
            XmlCursor.TokenType t = null;
            do {
                if (!(t = c.toNextToken()).isAttr() || !attributeName.equals(c.getName())) continue;
                String string = c.getTextValue();
                return string;
            } while (!XmlCursor.TokenType.END.equals(t));
            String string = null;
            return string;
        }
        finally {
            c.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> extractAnyElements(XmlObject source, QName q, Class<? extends XmlObject> asClass) {
        ArrayList<XmlObject> results = new ArrayList<XmlObject>();
        XmlCursor cursor = null;
        try {
            if (source != null) {
                cursor = source.newCursor();
                XmlBeansUtils.skipToElement(cursor, q);
                String ns = q.getNamespaceURI();
                boolean hasMore = true;
                while (hasMore) {
                    XmlObject next = XmlObject.Factory.parse((XMLStreamReader)cursor.newXMLStreamReader());
                    QName name = cursor.getName();
                    if (name != null && (ns.equals(name.getNamespaceURI()) || "*".equals(ns)) && q.getLocalPart().equals(name.getLocalPart())) {
                        results.add(next);
                    }
                    hasMore = cursor.toNextSibling();
                }
            }
        }
        catch (XmlException xe) {
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
        return results;
    }
}

